/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.SQLExecuteTimer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.properties.AttributeListing;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;

public final class SQLExecuteBatchTimer
extends SQLExecuteTimer {
    public SQLExecuteBatchTimer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected String getNormalizedSQL(InvocationData data) {
        String normalizedSQL = super.getNormalizedSQL(data);
        if (normalizedSQL == null) {
            Object tracedObject = data.getInvocationObject();
            if (tracedObject instanceof CallableStatement) {
                this.getAgent().IAgent_getModuleFeedback().warn("SQLExecuteBatchTimer.getNormalizedSQL: Traced Object is a CallableStatement, and its subtype was not found in the superclass.  This is likely because a java.sql.Connection subclass wasn't traced by the StatementToSQLMappingTracer.");
            }
            if (tracedObject instanceof PreparedStatement) {
                this.getAgent().IAgent_getModuleFeedback().warn("SQLExecuteBatchTimer.getNormalizedSQL: Traced Object is a PreparedStatement, and its subtype was not found in the superclass.  This is likely because a java.sql.Connection subclass wasn't traced by the StatementToSQLMappingTracer.");
            }
            normalizedSQL = "All Dynamic Batched Statements";
        }
        return normalizedSQL;
    }

    @Override
    protected String getSQLSubtype(InvocationData data) {
        String sqlSubtype = super.getSQLSubtype(data);
        if (sqlSubtype == null) {
            Object tracedObject = data.getInvocationObject();
            if (tracedObject instanceof CallableStatement) {
                this.getAgent().IAgent_getModuleFeedback().warn("SQLExecuteBatchTimer.getSQLSubtype: Traced Object is a CallableStatement, and its subtype was not found in the superclass.  This is likely because a java.sql.Connection subclass wasn't traced by the StatementToSQLMappingTracer.");
            }
            if (tracedObject instanceof PreparedStatement) {
                this.getAgent().IAgent_getModuleFeedback().warn("SQLExecuteBatchTimer.getSQLSubtype: Traced Object is a PreparedStatement, and its subtype was not found in the superclass.  This is likely because a java.sql.Connection subclass wasn't traced by the StatementToSQLMappingTracer.");
            }
            sqlSubtype = "Dynamic";
        }
        return sqlSubtype;
    }
}

