/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.sqlagent.SQLAgentConfiguration;
import com.wily.introscope.agent.sqlagent.SQLJRTStatementToSQLMappingTracer;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.util.HashMap;
import java.util.Map;

public class SQLJRTSQLExecuteTimer
extends ASingleInstanceTracerFactory {
    public static final int kDefaultStringBufferSize = 200;
    public static final Map sMethodToSQLSubtypeMap;
    public static final Map sMethodToRateAttributeMap;
    public static final Map sMethodToAverageAttributeMap;
    public static final Map sSQLSubtypeToTTKeyMap;
    public static final String kMetricPathCacheKey = "com.wily.introscope.agent.sqlagent.execute.metric.path";
    private final SQLAgentConfiguration fConfiguration;

    static {
        HashMap<String, String> methodToSubtype = null;
        HashMap<String, String> methodToRate = null;
        HashMap<String, String> methodToAverage = null;
        HashMap<String, String> subtypeToTTKey = null;
        try {
            methodToSubtype = new HashMap<String, String>();
            methodToRate = new HashMap<String, String>();
            methodToAverage = new HashMap<String, String>();
            subtypeToTTKey = new HashMap<String, String>();
            methodToSubtype.put("execute", "General");
            methodToRate.put("execute", "Statements Per Second");
            methodToAverage.put("execute", "Average Statement Time (ms)");
            methodToSubtype.put("executeQuery", "Query");
            methodToRate.put("executeQuery", "Queries Per Second");
            methodToAverage.put("executeQuery", "Average Query Time (ms)");
            methodToSubtype.put("executeRTQuery", "Query");
            methodToRate.put("executeRTQuery", "Queries Per Second");
            methodToAverage.put("executeRTQuery", "Average Query Time (ms)");
            methodToSubtype.put("executeUpdate", "Update");
            methodToRate.put("executeUpdate", "Updates Per Second");
            methodToAverage.put("executeUpdate", "Average Update Time (ms)");
            methodToSubtype.put("executeBatch", "Batch");
            methodToRate.put("executeBatch", "Statement Batches Per Second");
            methodToAverage.put("executeBatch", "Average Statement Batch Time (ms)");
            subtypeToTTKey.put("Dynamic", "Dynamic SQL");
            subtypeToTTKey.put("Prepared", "Prepared SQL");
            subtypeToTTKey.put("Stored Procedures", "Stored Procedure SQL");
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError((String)"Exception initializing SQLJRTSQLExecuteTimer", (Throwable)t);
            }
            catch (Throwable throwable) {}
        }
        sMethodToSQLSubtypeMap = methodToSubtype;
        sMethodToRateAttributeMap = methodToRate;
        sMethodToAverageAttributeMap = methodToAverage;
        sSQLSubtypeToTTKeyMap = subtypeToTTKey;
    }

    public static String getTTKey(String sqlSubtype) {
        return (String)sSQLSubtypeToTTKeyMap.get(sqlSubtype);
    }

    public SQLJRTSQLExecuteTimer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fConfiguration = SQLAgentConfiguration.getInstance(agent);
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kInstance;
    }

    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String path;
        data.storeWallClockStartTime();
        ComponentTracer componentTracer = this.getComponentTracer();
        if (this.fConfiguration.shouldParticipateInBlame() && componentTracer != null && (path = this.getMetricPath(data)) != null) {
            IBlameStack stack = data.getStack(componentTracer, true);
            componentTracer.addComponent(stack, path, SQLJRTSQLExecuteTimer.getTTKey(this.getSQLSubtype(data)), this.getNormalizedSQLForUserView(data));
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        int elapsedTime = data.getWallClockElapsedTimeAsInt();
        try {
            this.handleFinishTrace(data, elapsedTime);
        }
        finally {
            String path;
            ComponentTracer componentTracer = this.getComponentTracer();
            if (this.fConfiguration.shouldParticipateInBlame() && componentTracer != null && (path = this.getMetricPath(data)) != null) {
                IBlameStack stack = data.getStack(componentTracer, false);
                componentTracer.removeComponent(stack, path);
            }
        }
    }

    private void handleFinishTrace(InvocationData data, int elapsedTime) {
        IIntegerAverageDataAccumulator average = null;
        IIntegerRateDataAccumulator rate = null;
        String method = this.getProbeIdentification().getProbeMethodName();
        String path = this.getMetricPath(data);
        if (path == null) {
            return;
        }
        String rateAttribute = (String)sMethodToRateAttributeMap.get(method);
        String averageAttribute = (String)sMethodToAverageAttributeMap.get(method);
        try {
            String averageMetric = String.valueOf(path) + ":" + averageAttribute;
            average = this.getDataAccumulatorFactory().getIntegerAverageDataAccumulator(averageMetric);
            String rateMetric = String.valueOf(path) + ":" + rateAttribute;
            rate = this.getDataAccumulatorFactory().getIntegerRateDataAccumulator(rateMetric);
        }
        catch (ConflictingTypesException conflictingTypesException) {
            Assertion.wilyAssert((String)"conflicting types");
            return;
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
            Assertion.wilyAssert((String)"badly formed name");
            return;
        }
        BlameStackSnapshot snapshot = this.getBlameStackSnapshot(data, path);
        if (!rate.IDataAccumulator_isShutOff()) {
            rate.IIntegerRateDataAccumulator_addSingleIncident(snapshot);
        }
        if (!average.IDataAccumulator_isShutOff()) {
            average.IIntegerAggregatingDataAccumulator_recordDataPoint(elapsedTime, snapshot);
        }
    }

    private BlameStackSnapshot getBlameStackSnapshot(InvocationData data, String path) {
        ComponentTracer componentTracer = this.getComponentTracer();
        if (this.fConfiguration.shouldParticipateInBlame() && componentTracer != null) {
            IBlameStack stack = data.getStack(componentTracer, false);
            return componentTracer.getSnapshot(stack, path);
        }
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    protected String getNormalizedSQLForMetricName(InvocationData data) {
        Object tracedObject = data.getInvocationObject();
        return SQLJRTStatementToSQLMappingTracer.getSQL(tracedObject);
    }

    protected String getNormalizedSQLForUserView(InvocationData data) {
        Object tracedObject = data.getInvocationObject();
        return SQLJRTStatementToSQLMappingTracer.getSQL(tracedObject, false);
    }

    protected String getSQLSubtype(InvocationData data) {
        Object tracedObject = data.getInvocationObject();
        return SQLJRTStatementToSQLMappingTracer.getSQLType(tracedObject);
    }

    protected final String getMetricPath(InvocationData data) {
        Object answer = data.get(kMetricPathCacheKey);
        if (answer == null && (answer = this.createMetricPath(data)) != null) {
            data.put(kMetricPathCacheKey, answer);
        }
        return (String)answer;
    }

    protected String createMetricPath(InvocationData data) {
        data.getInvocationObject();
        String method = this.getProbeIdentification().getProbeMethodName();
        String type = this.getSQLSubtype(data);
        String sql = this.getNormalizedSQLForMetricName(data);
        if (type == null || sql == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append("JDBC|SQL");
        sb.append("|");
        sb.append(type);
        sb.append("|");
        sb.append(sMethodToSQLSubtypeMap.get(method));
        sb.append("|");
        sb.append(sql);
        return sb.toString();
    }
}

