/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.gcmonitor.instrumentation;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.util.JavaVersion;
import com.wily.introscope.gcmonitor.agent.GCMonitorAgentService;
import com.wily.introscope.gcmonitor.instrumentation.Collector;
import com.wily.util.feedback.Module;
import java.lang.management.GarbageCollectorMXBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class CollectorFactory {
    private static final Module module = new Module("GCMonitor");
    public static final IAgent agent;
    static final String GC_EVENT_MEM_COLLECTION_ENABLED = "introscope.agent.gcmonitor.gcEventMemoryCollection.enabled";

    static {
        IAgent jagent = GCMonitorAgentService.getAgent();
        if (jagent == null) {
            try {
                jagent = AgentShim.getAgent();
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
        }
        agent = jagent;
    }

    public static List<Collector> getGCEventMemoryCollectors(List<GarbageCollectorMXBean> garbageCollectorMXBeans, Set<String> heapPoolNames) {
        return CollectorFactory.getGCEventMemoryCollectors(JavaVersion.CURRENT, garbageCollectorMXBeans, heapPoolNames);
    }

    static List<Collector> getGCEventMemoryCollectors(JavaVersion version, List<GarbageCollectorMXBean> garbageCollectorMXBeans, Set<String> heapPoolNames) {
        ArrayList<Collector> list = new ArrayList<Collector>();
        if (version.satisfies(">=1.7")) {
            if (CollectorFactory.isGCEventMemoryCollectorEnabled()) {
                for (GarbageCollectorMXBean gcMXbean : garbageCollectorMXBeans) {
                    Collector gc = CollectorFactory.createInstanceOfMemoryCollector(gcMXbean, heapPoolNames);
                    if (gc == null || !gc.init()) continue;
                    list.add(gc);
                }
            }
        } else {
            agent.IAgent_getModuleFeedback().debug(module, "GC Event Collector is not supported for jvm version: " + version);
        }
        return list;
    }

    private static Collector createInstanceOfMemoryCollector(GarbageCollectorMXBean gcMXbean, Set<String> heapPoolNames) {
        String className = "com.wily.introscope.gcmonitor.jvm17.GCListenerMemoryCollector";
        String errorMessage = "Unable to create collector instance for class " + className;
        try {
            Class<?> clazz = Class.forName(className);
            Object obj = clazz.getConstructor(GarbageCollectorMXBean.class, Set.class).newInstance(gcMXbean, heapPoolNames);
            if (obj instanceof Collector) {
                agent.IAgent_getModuleFeedback().trace(module, "Successfully created instance of class: " + className + " with argument gc bean: " + gcMXbean.getName());
                return (Collector)obj;
            }
        }
        catch (Exception e) {
            agent.IAgent_getModuleFeedback().error(module, errorMessage, (Throwable)e);
        }
        return null;
    }

    private static boolean isGCEventMemoryCollectorEnabled() {
        boolean enabled = true;
        if (agent != null && agent.IAgent_getIndexedProperties() != null) {
            enabled = Boolean.parseBoolean(agent.IAgent_getIndexedProperties().getProperty(GC_EVENT_MEM_COLLECTION_ENABLED, Boolean.TRUE.toString()));
        }
        return enabled;
    }
}

