/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.parent.instrumentation.filter;

import com.ca.apm.parent.instrumentation.filter.TraceElementFilter;
import com.ca.apm.parent.instrumentation.helper.WrappedStackTraceElement;
import java.util.HashSet;
import java.util.Set;

public class MethodFilter
implements TraceElementFilter {
    private final Set<String> methodFilters = new HashSet<String>();
    private boolean isMatchingFilter = true;

    public MethodFilter(String commaSepratedMethodList, boolean isMatchingFilter) {
        this.isMatchingFilter = isMatchingFilter;
        String[] stringArray = commaSepratedMethodList.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName = stringArray[n2];
            this.methodFilters.add(methodName);
            ++n2;
        }
    }

    @Override
    public boolean doFilter(WrappedStackTraceElement traceElement) {
        String methodName = traceElement.getMethodName();
        if (methodName != null) {
            int length = methodName.length();
            for (String filterMethod : this.methodFilters) {
                if (this.isMatchingFilter && length == filterMethod.length() && methodName.equals(filterMethod)) {
                    traceElement.SetAsThreadStartElement();
                    return true;
                }
                if (this.isMatchingFilter || length < filterMethod.length() || !methodName.contains(filterMethod)) continue;
                return false;
            }
        }
        return !this.isMatchingFilter;
    }
}

