/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.jms.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.cas.IUpdater;
import com.wily.introscope.agent.trace.cas.UpdaterFactory;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.hc2.MethodTimer;
import com.wily.util.properties.AttributeListing;

public class JMSSyncReceiverTimerTracer
extends MethodTimer
implements BackendProtocolsConstants {
    static ThreadLocal<Long> lastReceivedTimeOnThisThread = new ThreadLocal();
    static final IUpdater kUpdater = UpdaterFactory.getCombiningUpdater();

    public JMSSyncReceiverTimerTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (!JMSHelper.isStackEmpty(data) && this.shouldRun(data)) {
            super.ITracer_startTrace(tracerIndex, data);
        }
    }

    protected void doOnStartTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
        Long lastReceivedTime = null;
        try {
            super.doOnStartTrace(tracerIndex, data, mh);
            lastReceivedTime = lastReceivedTimeOnThisThread.get();
            if (lastReceivedTime != null) {
                long elapsed = data.getWallClockStartTime() - lastReceivedTime;
                mh.getRepository().update(kUpdater, elapsed, lastReceivedTime.longValue(), data.hashCode());
            }
        }
        finally {
            if (lastReceivedTime != null) {
                lastReceivedTimeOnThisThread.remove();
            }
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (!this.shouldRun(data)) {
            return;
        }
        super.ITracer_finishTrace(tracerIndex, data);
    }

    private boolean shouldRun(InvocationData data) {
        Boolean shouldRun = (Boolean)data.get("jms.receiver.tracer.should.run");
        return shouldRun != null && shouldRun != false;
    }

    protected void doOnEndTrace(int tracerIndex, IStackElement element, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
        InvocationData invocationData = (InvocationData)element;
        if (invocationData.getInvocationReturnValueAsObject() == null) {
            return;
        }
        InvocationData data = (InvocationData)element;
        JMSHelper.getConsumerDestinationInfoFromSession(data.getInvocationObject());
        lastReceivedTimeOnThisThread.set(data.getWallClockFinishTime());
    }
}

