/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives.apply;

import com.wily.diagnos.cmp.batch.IMethodSpanningCacheLine;
import com.wily.diagnos.cmp.batch.MethodSpanningCache;
import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.directives.DGMethodSkippedException;
import com.wily.diagnos.cmp.directives.DGSetAsSkippedException;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.mutate.IMethodMutator;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.tracer.DGAggregateMethodTracer;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.diagnos.cmp.tracer.MethodTracerAggregator;
import com.wily.diagnos.cmp.transform.ITransformation;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.wilyassert.Assertion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MethodSettingsApplier {
    private final DGCompilerSettings fSettings;
    private final ICompilerLog fLog;
    private final MethodSpanningCache fMethodSpanningCache;
    private final IMethodMutator fTargetMethodMutator;
    private final IModeledMethod fTargetMethod;
    private final IModeledClass fTargetClass;
    private boolean fModifiedAnything;

    public MethodSettingsApplier(DGCompilerSettings settings, ICompilerLog log, MethodSpanningCache cache, IModeledMethod targetMethod, IMethodMutator targetMethodMutator) {
        Assertion.wilyAssert((log != null ? 1 : 0) != 0);
        this.fSettings = settings;
        this.fLog = log;
        this.fMethodSpanningCache = cache;
        this.fTargetClass = targetMethod.getModeledClass();
        this.fTargetMethod = targetMethod;
        this.fTargetMethodMutator = targetMethodMutator;
        this.fModifiedAnything = false;
    }

    private void noticeModification() {
        this.fModifiedAnything = true;
    }

    private boolean modifiedAnything() {
        return this.fModifiedAnything;
    }

    public boolean apply() throws DGClassModificationException, IOException {
        this.preflight();
        this.applyTracerMutations();
        this.applyTransformationDrivenMutations();
        this.postflight();
        return this.modifiedAnything();
    }

    private void preflight() throws DGClassModificationException, IOException {
        this.checkIfShouldSkipMethod(this.fTargetClass, this.fTargetMethod);
        this.fTargetMethodMutator.throwIfAlreadyInstrumented(this.fTargetMethod);
        this.fTargetMethodMutator.preflight(this.fSettings, this.fTargetMethod);
    }

    private void postflight() throws DGClassModificationException, IOException {
        this.fTargetMethodMutator.markInstrumented(this.fSettings, this.fTargetMethod);
    }

    private void checkIfShouldSkipMethod(IModeledClass modeledClass, IModeledMethod modeledMethod) throws DGSetAsSkippedException {
    }

    public static void executeBatchMutations(IMutation[] mutations) throws DGClassModificationException, IOException {
        int x = 0;
        while (x < mutations.length) {
            mutations[x].mutate();
            ++x;
        }
    }

    private void applyTransformationDrivenMutations() throws DGClassModificationException, IOException {
        ArrayList allMutationsList = new ArrayList();
        Iterator transformations = this.fSettings.getTransformationsIterator();
        while (transformations.hasNext()) {
            ITransformation transform = (ITransformation)transformations.next();
            Object[] newMutations = transform.generateMutations(this.fSettings, this.fTargetMethod, this.fTargetMethodMutator);
            MethodSettingsApplier.appendToList(allMutationsList, newMutations);
        }
        for (IMutation mutation : allMutationsList) {
            mutation.mutate();
            this.noticeModification();
        }
    }

    private static void appendToList(List target, Object[] newElements) {
        int x = 0;
        while (x < newElements.length) {
            target.add(newElements[x]);
            ++x;
        }
    }

    private void applyTracerMutations() throws DGClassModificationException, IOException {
        List tracers = null;
        tracers = this.analyzeSettingsAndLogAndComputeTracers();
        this.mutateForTracers(tracers);
    }

    private List analyzeSettingsAndLogAndComputeTracers() throws DGClassModificationException, IOException {
        ArrayList<MethodTracer> tracers = null;
        tracers = new ArrayList<MethodTracer>();
        IMethodSpanningCacheLine cacheLine = this.fMethodSpanningCache.getCacheLine(this.fTargetClass, this.fSettings.getTracersCount());
        Iterator iterator = this.fSettings.getTracersIterator();
        int tracerIndex = 0;
        while (iterator.hasNext()) {
            boolean classMatches;
            MethodTracer tracer = (MethodTracer)iterator.next();
            boolean shouldSkipClassForGroup = cacheLine.shouldSkipClassForTracerGroup(tracer.getTracerGroup(), this, tracerIndex);
            if (!shouldSkipClassForGroup && (classMatches = cacheLine.doesTracerMatchClass(tracer, tracerIndex))) {
                boolean methodMatches;
                IMethodMatcher methodMatcher = tracer.getMethodMatcher();
                if (!this.shouldSkipMethodInClassForTracerGroup(this.fLog, this.fTargetClass, this.fTargetMethod, tracer.getTracerGroup()) && !this.shouldSkipMethodForClass(this.fLog, this.fTargetClass, this.fTargetMethod) && (methodMatches = methodMatcher.IMethodMatcher_matches(this.fTargetMethod))) {
                    tracers.add(tracer);
                }
            }
            ++tracerIndex;
        }
        this.fMethodSpanningCache.commitCacheLine(this.fTargetClass, cacheLine);
        return tracers;
    }

    private void mutateForTracers(List tracers) throws DGClassModificationException, IOException {
        if (this.fTargetMethod.hasBytecode() && !tracers.isEmpty()) {
            DGAggregateMethodTracer aggregateTracer = MethodTracerAggregator.aggregate(tracers);
            IMutation tracerMutation = aggregateTracer.newMutation(this.fTargetMethodMutator, this.fTargetMethod);
            try {
                tracerMutation.mutate();
                this.noticeModification();
                this.fLog.ICompilerLog_logMethodTraced(this.fTargetMethod);
                aggregateTracer.logAggregateMethodTracer(this.fLog, this.fTargetMethod);
            }
            catch (DGMethodSkippedException dGMethodSkippedException) {
                this.fLog.ICompilerLog_logSkippedMethod(this.fTargetMethod.getModeledClass().getClassName(), this.fTargetMethod.getMethodName());
            }
            catch (IOException e) {
                this.fLog.ICompilerLog_logMessage(e.getMessage());
                throw e;
            }
        }
    }

    private boolean shouldSkipMethodForClass(ICompilerLog log, IModeledClass targetClass, IModeledMethod method) {
        Set methodsSkippedForClass;
        Map methodSkips = this.fSettings.getFilter().getSkipMethodsForClasses();
        boolean result = false;
        if (methodSkips != null && (methodsSkippedForClass = (Set)methodSkips.get(targetClass.getClassName())) != null) {
            Iterator it = methodsSkippedForClass.iterator();
            while (it.hasNext() && !result) {
                IMethodMatcher matcher = (IMethodMatcher)it.next();
                result = matcher.IMethodMatcher_matches(method);
            }
        }
        return result;
    }

    public boolean shouldSkipClassForTracerGroup(TracerGroup tracerGroup) {
        return MethodSettingsApplier.shouldSkipClassForTracerGroup(this.fLog, this.fTargetClass, tracerGroup);
    }

    private static boolean shouldSkipClassForTracerGroup(ICompilerLog log, IModeledClass theClass, TracerGroup tracerGroup) {
        boolean shouldSkip = false;
        if (tracerGroup != null) {
            if (tracerGroup.isEnabled()) {
                if (tracerGroup.shouldSkipInstrumentationInClass(theClass)) {
                    log.ICompilerLog_logSkippedClassForFlag(tracerGroup.getName().getName());
                    shouldSkip = true;
                }
            } else {
                shouldSkip = true;
            }
        }
        return shouldSkip;
    }

    private boolean shouldSkipMethodInClassForTracerGroup(ICompilerLog log, IModeledClass theClass, IModeledMethod theMethod, TracerGroup tracerGroup) {
        return this.shouldSkipMethodInClassForTracerGroup(log, theClass, theMethod, false, tracerGroup);
    }

    private boolean shouldSkipMethodInClassForTracerGroup(ICompilerLog log, IModeledClass theClass, IModeledMethod theMethod, boolean checkClass, TracerGroup tracerGroup) {
        boolean skipMethod = false;
        if (tracerGroup != null) {
            if (tracerGroup.isEnabled()) {
                if (checkClass && tracerGroup.shouldSkipInstrumentationInClass(theClass)) {
                    log.ICompilerLog_logSkippedClassForFlag(tracerGroup.getName().getName());
                    skipMethod = true;
                }
                if (!skipMethod) {
                    boolean skipBecauseOfClass = tracerGroup.shouldSkipInstrumentationInClassForMethod(theClass, theMethod);
                    boolean skipBecauseOfFlag = tracerGroup.shouldSkipFlaggedMethod(theMethod);
                    skipMethod = skipBecauseOfClass || skipBecauseOfFlag;
                }
            } else {
                skipMethod = true;
            }
        }
        return skipMethod;
    }
}

