/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.filter.sampling;

import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.transactiontrace.ISamplingInput;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;

public class SamplingInput {
    public static ISamplingInput wrap(final IStackElement stackElement) {
        return new ISamplingInput(){

            @Override
            public boolean valid() {
                return true;
            }

            @Override
            public long duration() {
                return stackElement.getWallClockElapsedTime();
            }

            @Override
            public String resource() {
                String resource = stackElement.getComponentName();
                if (resource != null) {
                    return resource;
                }
                ITransactionElement start = stackElement.getStartTransactionElement();
                if (start != null && start instanceof IBlameTransactionElement) {
                    IBlameTransactionElement blameElement = (IBlameTransactionElement)start;
                    resource = blameElement.getComponentName();
                    if (resource != null) {
                        return resource;
                    }
                    resource = blameElement.getResourceName();
                    if (resource != null) {
                        return resource;
                    }
                }
                return null;
            }
        };
    }

    public static ISamplingInput wrap(final TransactionComponentData tcd) {
        return new ISamplingInput(){

            @Override
            public boolean valid() {
                return true;
            }

            @Override
            public long duration() {
                return tcd.getDurationInMillisecs();
            }

            @Override
            public String resource() {
                return tcd.getResource();
            }
        };
    }
}

