/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.api.instrument.JPMSClassFileTransformerImpl;
import com.wily.util.extension.IExtension;
import java.lang.instrument.Instrumentation;
import java.lang.module.ModuleFinder;
import java.lang.module.ModuleReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class AgentJPMSEnabler {
    static Map<String, String> staticExportList = Map.of("java.net", "java.base", "java.io", "java.base", "java.lang", "java.base", "com.sun.management.internal", "jdk.management", "sun.instrument", "java.instrument");
    private static AgentJPMSEnabler instance;

    public static AgentJPMSEnabler getInstance(Instrumentation instrumentation) {
        if (instance == null) {
            instance = new AgentJPMSEnabler(instrumentation);
        }
        return instance;
    }

    private AgentJPMSEnabler(Instrumentation instrumentation) {
        try {
            this.startSetup(instrumentation);
        }
        catch (Exception e) {
            this.logSever("Error Starting AgentJPMSEnabler: " + e);
        }
    }

    private void startSetup(Instrumentation inst) {
        try {
            boolean isModulePathLauncher = this.isModulePathLauncher();
            this.logSever("Starting Agent module configuration" + (isModulePathLauncher ? " for modular launch" : " for traditional/classpath launch"));
            if (!ModuleLayer.boot().findModule("java.base").isPresent()) {
                this.logSever("java.base is not loaded yet! We came in too early.");
                return;
            }
            Module agentCoreModule = AgentJPMSEnabler.class.getModule();
            this.redefineModulesForAgent(inst, Set.of(agentCoreModule), staticExportList);
            if (isModulePathLauncher) {
                this.logMessage("Module Path launch detected. ");
                this.loadAgentModule("java.sql");
            } else {
                this.logMessage("Classpath launch detected. Not modifying modules.. ");
            }
        }
        catch (Exception e) {
            this.logSever("Unexpected error when setting up AgentModules " + e);
        }
    }

    public static void finishSetup(Instrumentation inst, List<IExtension> extensionsList, String extraExportsFromConfig) {
        AgentJPMSEnabler.getInstance(inst).processFinishSetup(inst, extensionsList, extraExportsFromConfig);
    }

    private void processFinishSetup(Instrumentation inst, List<IExtension> extensionsList, String extraExportsFromConfig) {
        try {
            this.logMessage("Finishing up Agent module configuration");
            Map<String, String> extraExports = this.processExtraExports(extraExportsFromConfig);
            this.logMessage("Extra exports from config: " + extraExports);
            Set<Module> extensionModules = this.getAgentExtensionsModules(extensionsList);
            this.logMessage(extensionModules.size() + " extension modules found");
            this.redefineModulesForAgent(inst, extensionModules, staticExportList);
            if (!extraExports.containsKey("*")) {
                HashSet<Module> combinedSet = new HashSet<Module>();
                combinedSet.addAll(extensionModules);
                combinedSet.add(AgentJPMSEnabler.class.getModule());
                this.redefineModulesForAgent(inst, combinedSet, extraExports);
            }
            if (this.isModulePathLauncher() || extraExports.containsKey("*")) {
                inst.addTransformer(new JPMSClassFileTransformerImpl(inst));
            }
        }
        catch (Exception e) {
            this.logMessage("Unexpected error when finishing AgentModules setup: " + e);
        }
    }

    private void redefineModulesForAgent(Instrumentation inst, Set<Module> agentModules, Map<String, String> redefinitionList) {
        try {
            if (redefinitionList == null) {
                return;
            }
            redefinitionList.forEach((packageName, moduleName) -> {
                Optional<Module> optModule = ModuleLayer.boot().findModule((String)moduleName);
                if (optModule.isPresent()) {
                    try {
                        inst.redefineModule(optModule.get(), Set.of(), Map.of(), Map.of(packageName, agentModules), Set.of(), Map.of());
                    }
                    catch (Exception e) {
                        this.logMessage("Error in redefining Modules " + moduleName + ": " + e);
                    }
                } else {
                    this.logMessage("module " + moduleName + " is not found in boot layer");
                }
            });
        }
        catch (Exception e) {
            this.logSever("Unexpected Error in redefining Modules for agent " + e);
        }
    }

    private Set<Module> getAgentExtensionsModules(List<IExtension> extensionsList) {
        HashSet<Module> unnamedModules = new HashSet<Module>();
        try {
            this.logMessage("Giving access to agent core extensions...");
            for (IExtension extension : extensionsList) {
                try {
                    ClassLoader extensionCL = extension.IExtension_getClassLoader();
                    unnamedModules.add(extensionCL.getUnnamedModule());
                }
                catch (Exception log) {
                    this.logMessage("Error adding extensionCL unnamed module for extension: " + log);
                }
            }
        }
        catch (Exception suppress) {
            this.logMessage("Error adding extensionCL: " + suppress);
        }
        return unnamedModules;
    }

    private static void openModulesForAgent(Instrumentation inst) {
        try {
            Module javaBaseModule = ModuleLayer.boot().findModule("java.base").get();
            Module agentCodeModule = AgentJPMSEnabler.class.getModule();
            inst.redefineModule(javaBaseModule, Set.of(), Map.of(), Map.of("java.lang", Set.of(agentCodeModule)), Set.of(), Map.of());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadAgentModule(String name) {
        try {
            boolean isModuleAlreadyPresent;
            ModuleLayer boot = ModuleLayer.boot();
            boolean bl = isModuleAlreadyPresent = boot.modules().stream().filter(module -> name.equals(module.getName())).findAny().orElse(null) != null;
            if (isModuleAlreadyPresent) {
                this.logMessage("Module " + name + ", already present in boot layer. ");
                return;
            }
            this.logMessage("Loading module " + name);
            Optional<ModuleReference> ref = ModuleFinder.ofSystem().find(name);
            if (!ref.isPresent()) {
                this.logMessage("System JRE doesn't have the requested module." + name + ". This could be either because the JRE is a custom one with minimal modules or that its a flavour of runtime (" + System.getProperty("java.version") + ") that doesn't have the modules needed for the agent to work ");
                return;
            }
            Module _javaBaseModule = boot.findModule("java.base").get();
            if (!_javaBaseModule.isOpen("jdk.internal.loader")) {
                Method addOpens = _javaBaseModule.getClass().getDeclaredMethod("implAddOpens", String.class);
                addOpens.setAccessible(true);
                addOpens.invoke((Object)_javaBaseModule, "jdk.internal.loader");
                addOpens.invoke((Object)_javaBaseModule, "jdk.internal.module");
            }
            ClassLoader scl = this.findClassLoaderToUse(name);
            Method loadModule = scl.getClass().getMethod("loadModule", ModuleReference.class);
            loadModule.invoke((Object)scl, ref.get());
            this.logMessage("Done loading module : " + name);
        }
        catch (Exception e) {
            this.logSever("Error loading module : " + name + ": " + e);
        }
    }

    private ClassLoader findClassLoaderToUse(String name) {
        ClassLoader returnLoader = ClassLoader.getSystemClassLoader();
        try {
            Method _platformModules = Class.forName("jdk.internal.module.ModuleLoaderMap").getDeclaredMethod("platformModules", new Class[0]);
            Set platformModules = (Set)_platformModules.invoke(null, null);
            Method _bootModules = Class.forName("jdk.internal.module.ModuleLoaderMap").getDeclaredMethod("bootModules", new Class[0]);
            Set bootModules = (Set)_bootModules.invoke(null, null);
            if (bootModules.contains(name)) {
                Method _bootLoader = Class.forName("jdk.internal.loader.ClassLoaders").getDeclaredMethod("bootLoader", new Class[0]);
                _bootLoader.setAccessible(true);
                returnLoader = (ClassLoader)_bootLoader.invoke(null, null);
            } else if (platformModules.contains(name)) {
                Method _platformClassLoader = Class.forName("jdk.internal.loader.ClassLoaders").getDeclaredMethod("platformClassLoader", new Class[0]);
                _platformClassLoader.setAccessible(true);
                returnLoader = (ClassLoader)_platformClassLoader.invoke(null, null);
            }
        }
        catch (Exception e) {
            this.logSever("Error  findClassLoaderToUse: " + e);
        }
        return returnLoader;
    }

    public boolean isModulePathLauncher() {
        try {
            String[] MODULEPATH_LAUNCHER_PROPERTIES;
            for (String property : MODULEPATH_LAUNCHER_PROPERTIES = new String[]{"jdk.module.path", "jdk.module.main", "jdk.module.minimumBoot", "jdk.module.limitmods", "jdk.module.upgrade.path"}) {
                if (System.getProperty(property) == null) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Map<String, String> processExtraExports(String extraExports) {
        HashMap<String, String> exportList;
        block4: {
            exportList = new HashMap<String, String>();
            try {
                String[] modulesPackages;
                this.logMessage("Processing Extra Exports from config " + extraExports);
                if (extraExports == null || extraExports.trim().length() <= 0) break block4;
                for (String item : modulesPackages = extraExports.split("#")) {
                    String exportItem = item.trim();
                    if (exportItem.equals("*") || exportItem.equals("*/*")) {
                        exportList.clear();
                        exportList.put("*", "*");
                        break;
                    }
                    String[] expKV = exportItem.split("/");
                    if (expKV == null || expKV.length != 2) continue;
                    String moduleName = expKV[0].trim();
                    String packageName = expKV[1].trim();
                    if (exportList.containsKey(packageName)) continue;
                    exportList.put(packageName, moduleName);
                }
            }
            catch (Exception ignore) {
                this.logSever("Error in processing extra exports: " + ignore);
            }
        }
        return exportList;
    }

    private void logMessage(String message) {
    }

    private void logSever(String message) {
        System.out.println(message);
    }
}

