/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.launch.util;

import com.wily.introscope.agent.launch.core.BootstrapAgent;
import com.wily.introscope.agent.launch.core.BootstrapAgentLogger;
import com.wily.introscope.agent.launch.core.ProcessIdFinder;
import com.wily.introscope.agent.launch.util.AgentArtifact;
import com.wily.introscope.agent.launch.util.BootstrapAgentConstants;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;

public class BootstrapAgentUtil
implements BootstrapAgentConstants {
    private static final String PATH_PREFIX_FILE = "file:/";
    private static final DateFormat df = new SimpleDateFormat("MM-dd-yyyy HH:mm:ss.SSS");
    public static String PROCESS_ID = ProcessIdFinder.getProcessId("Unknown");
    private static String OS = null;

    private BootstrapAgentUtil() {
    }

    public static AgentArtifact getAgentForVersion(String version, String agentHome, String coreAgentJarName) {
        if ("latest".equals(version.toLowerCase())) {
            List<AgentArtifact> agentArtifacts = BootstrapAgentUtil.getValidAgentJars(BootstrapAgentUtil.getPathToReleasesDir(agentHome), coreAgentJarName);
            if (agentArtifacts.isEmpty()) {
                return null;
            }
            if (agentArtifacts.size() == 1) {
                return agentArtifacts.get(0);
            }
            Collections.sort(agentArtifacts, AGENT_ARTIFACT_COMPARATOR);
            return agentArtifacts.get(0);
        }
        String location = String.valueOf(BootstrapAgentUtil.getPathToReleasesDir(agentHome)) + FILE_SEPARATOR + version + FILE_SEPARATOR + coreAgentJarName;
        return new AgentArtifact(version, location, true);
    }

    public static String getBootstrapAgentInstallDir(String bootstrapJarLocn) {
        if (bootstrapJarLocn != null) {
            return new File(bootstrapJarLocn).getParentFile().getAbsolutePath();
        }
        return null;
    }

    public static String getBootstrapAgentJar() {
        URL url = BootstrapAgent.class.getResource("BootstrapAgent.class");
        if (url == null) {
            return null;
        }
        String urlPath = url.getPath();
        try {
            urlPath = URLDecoder.decode(urlPath, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        int index = urlPath.indexOf("!/");
        if (index == -1) {
            return null;
        }
        String path = urlPath.substring(0, index);
        if (path.startsWith(PATH_PREFIX_FILE)) {
            path = BootstrapAgentUtil.isWindows() ? path.substring(PATH_PREFIX_FILE.length()) : path.substring("file:".length());
            return path;
        }
        return null;
    }

    public static String getBootstrapAgentInstallDir() {
        String specifiedBootStrapPath = System.getProperty("bootstrap.jar.absolute.location");
        if (specifiedBootStrapPath != null && specifiedBootStrapPath.trim().length() != 0) {
            return BootstrapAgentUtil.getBootstrapAgentInstallDir(specifiedBootStrapPath);
        }
        return BootstrapAgentUtil.getBootstrapAgentInstallDir(BootstrapAgentUtil.getBootstrapAgentJar());
    }

    public static List<AgentArtifact> getAllInstalledAgentJars(String releasesDir, String coreAgentJarName) {
        ArrayList<AgentArtifact> output = new ArrayList<AgentArtifact>();
        BootstrapAgentUtil.searchRecursivley(releasesDir, coreAgentJarName, output);
        return output;
    }

    public static List<AgentArtifact> getValidAgentJars(String releasesDir, String coreAgentJarName) {
        ArrayList<AgentArtifact> output = new ArrayList<AgentArtifact>();
        for (AgentArtifact ar : BootstrapAgentUtil.getAllInstalledAgentJars(releasesDir, coreAgentJarName)) {
            if (ar.isAPMReleaseVersion()) {
                output.add(ar);
                continue;
            }
            BootstrapAgentLogger.getLogger().warning("ignoring agent release version: " + ar.getVersion() + " due to invalid version format");
        }
        return output;
    }

    public static void searchRecursivley(String dir, String artifactName, List<AgentArtifact> output) {
        File file = new File(dir);
        if (file.isFile()) {
            if (file.getName().equals(artifactName)) {
                String version = file.getParentFile().getName();
                AgentArtifact artifact = null;
                artifact = BootstrapAgentUtil.isValidVersion(version) ? new AgentArtifact(version, file.getAbsolutePath(), true) : new AgentArtifact(version, file.getAbsolutePath(), false);
                output.add(artifact);
            }
        } else if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                BootstrapAgentUtil.searchRecursivley(children[i].getAbsolutePath(), artifactName, output);
                ++i;
            }
        }
    }

    public static void appendToBootstrapClassLoaderSearch(Instrumentation instrumentation, JarFile jarFile) {
        try {
            Method m = Instrumentation.class.getDeclaredMethod("appendToBootstrapClassLoaderSearch", JarFile.class);
            m.invoke((Object)instrumentation, jarFile);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void appendToSystemClassLoaderSearch(Instrumentation instrumentation, JarFile jarFile) {
        try {
            Method m = Instrumentation.class.getDeclaredMethod("appendToSystemClassLoaderSearch", JarFile.class);
            m.invoke((Object)instrumentation, jarFile);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static boolean isProfileLocationAbsolute(String location) {
        File file = new File(location);
        return file.isAbsolute();
    }

    public static boolean fileExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static boolean isAgentNoReDefUsed(Map<String, String> startupParams) {
        String bootstrapJarLocn = startupParams.get("bootstrap.jar.absolute.location");
        return bootstrapJarLocn != null && bootstrapJarLocn.endsWith("AgentNoRedefNoRetrans.jar");
    }

    public static boolean isValidVersion(String version) {
        String[] split = version.split("\\.");
        int i = 0;
        while (i < split.length) {
            if (!BootstrapAgentUtil.isValidNumber(split[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isValidNumber(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public static String getPathToReleasesDir(String agentHome) {
        return String.valueOf(agentHome) + FILE_SEPARATOR + "releases" + FILE_SEPARATOR;
    }

    public static String getListOfAvailableAgent(String agentHome, String coreAgentJarName) {
        List<AgentArtifact> agentArtifacts = BootstrapAgentUtil.getAllInstalledAgentJars(BootstrapAgentUtil.getPathToReleasesDir(agentHome), coreAgentJarName);
        Iterator<AgentArtifact> it = agentArtifacts.iterator();
        if (!it.hasNext()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        while (true) {
            sb.append(it.next().getVersion());
            if (!it.hasNext()) {
                return sb.toString();
            }
            sb.append(",");
        }
    }

    public static String prepareLoggingMsg(String input) {
        StringBuilder builder = new StringBuilder();
        builder.append(df.format(new Date()));
        builder.append("\t");
        builder.append("[Process id=" + PROCESS_ID + "]");
        builder.append("\t");
        builder.append(input);
        builder.append("\n");
        return builder.toString();
    }

    public static String getOsName() {
        if (OS == null) {
            OS = System.getProperty("os.name");
        }
        return OS;
    }

    public static boolean isWindows() {
        return BootstrapAgentUtil.getOsName().startsWith("Windows");
    }
}

