/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.classmatcher;

import com.wily.diagnos.cmp.classmatcher.ACachingImmutableClassMatcher;
import com.wily.diagnos.cmp.classmatcher.DGCompoundClassMatcher;
import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.util.CollectionEquivalenceCheckers;
import com.wily.util.HashCodeUtils;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class FixedCompoundClassMatcher
extends ACachingImmutableClassMatcher {
    private final IClassMatcher[] fMatchers;

    public FixedCompoundClassMatcher(IClassMatcher[] matchers) {
        this.fMatchers = matchers;
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls) {
        int i = 0;
        while (i < this.fMatchers.length) {
            if (this.fMatchers[i].IClassMatcher_matches(cls)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean IClassMatcher_matches(IModeledClass cls, Map<IClassMatcher, Boolean> resultCache) {
        int i = 0;
        while (i < this.fMatchers.length) {
            if (this.fMatchers[i].IClassMatcher_matches(cls, resultCache)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean IClassMatcher_supportsNameMatching() {
        int i = 0;
        while (i < this.fMatchers.length) {
            if (this.fMatchers[i].IClassMatcher_supportsNameMatching()) {
                return true;
            }
            ++i;
        }
        return this.fMatchers.length == 0;
    }

    @Override
    public boolean IClassMatcher_matches(IClassName className) {
        int i = 0;
        while (i < this.fMatchers.length) {
            if (this.fMatchers[i].IClassMatcher_supportsNameMatching() && this.fMatchers[i].IClassMatcher_matches(className)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public DGCompoundClassMatcher generateMutableMatcher() {
        DGCompoundClassMatcher mutableClassMatcher = new DGCompoundClassMatcher();
        int i = 0;
        while (i < this.fMatchers.length) {
            IClassMatcher classMatcher = this.fMatchers[i];
            if (classMatcher instanceof FixedCompoundClassMatcher) {
                mutableClassMatcher.addClassMatcher(((FixedCompoundClassMatcher)classMatcher).generateMutableMatcher());
            } else {
                mutableClassMatcher.addClassMatcher(this.fMatchers[i]);
            }
            ++i;
        }
        return mutableClassMatcher;
    }

    public int hashCode() {
        int result = 17;
        int matcherListResult = 0;
        int i = 0;
        while (i < this.fMatchers.length) {
            matcherListResult += this.fMatchers[i].hashCode();
            ++i;
        }
        result = HashCodeUtils.accumulateHashCode((int)result, (int)matcherListResult);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FixedCompoundClassMatcher) {
            FixedCompoundClassMatcher m = (FixedCompoundClassMatcher)obj;
            return CollectionEquivalenceCheckers.listsAreEquivalent(Arrays.asList(this.fMatchers), Arrays.asList(m.fMatchers));
        }
        return false;
    }

    @Override
    public String[] getMatcherKeys() {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < this.fMatchers.length) {
            String[] matcherKeys = this.fMatchers[i].getMatcherKeys();
            if (matcherKeys != null) {
                int j = 0;
                while (j < matcherKeys.length) {
                    result.add(matcherKeys[j]);
                    ++j;
                }
            } else {
                return null;
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }
}

