/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.AnalysedClassesMapInitializer;
import com.wily.diagnos.cmp.directives.ClassModificationFilter;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.TracerGroup;
import com.wily.diagnos.cmp.directives.UnsupportedDGCompilerSettingModificationException;
import com.wily.diagnos.cmp.directives.parser.DGInvalidFlagNameException;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.diagnos.cmp.tracer.MethodTracer;
import com.wily.diagnos.cmp.transform.ITracerGroupTransformation;
import com.wily.diagnos.cmp.transform.ITransformation;
import com.wily.diagnos.personality.ICompilerPersonality;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.subscription.ISubscriberAdministrator;
import com.wily.introscope.api.instrument.DGRuntimeClass;
import com.wily.isengard.messageprimitives.MethodNotFoundError;
import com.wily.util.CollectionEquivalenceCheckers;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class DGCompilerSettings {
    private final List kEmptyTracerList = new ArrayList();
    private final ICompilerPersonality fPersonality;
    private final ClassModificationFilter fFilter;
    private final String fInstrumentationInfo;
    private final int fMinOffsetForJumpWidening;
    private final ITransformation[] fTransformations;
    private final MethodTracer[] fTracers;
    private final Map fTracersMap;
    private final IClassName fTraceClassName;
    private final Map fGroupMap;
    private MethodTracer fIntelligentInstrumentationTracer;
    private int fIntelligentInstrumentationMinimumMethodCalls;
    private int fIntelligentInstrumentationMinimumBranchCount;
    private int fIntelligentInstrumentationMinimumCombined;
    private static AnalysedClassesMapInitializer mapObj = new AnalysedClassesMapInitializer();
    private final ISubscriberAdministrator fSubscriberAdminstrator;

    public DGCompilerSettings(ICompilerPersonality personality, ClassModificationFilter filter, String instrumentationInfo, int minOffsetForJumpWidening, ITransformation[] transformations, MethodTracer[] tracers, Map tracersMap, IClassName traceClassName, Map groupMap, ISubscriberAdministrator subscriberAdministrator, MethodTracer intelligentInstrumentationTracer) {
        this.fPersonality = personality;
        this.fFilter = filter;
        this.fInstrumentationInfo = instrumentationInfo;
        this.fMinOffsetForJumpWidening = minOffsetForJumpWidening;
        this.fTransformations = transformations;
        this.fTracers = tracers;
        this.fTracersMap = tracersMap;
        this.fTraceClassName = traceClassName;
        this.fGroupMap = groupMap;
        this.fSubscriberAdminstrator = subscriberAdministrator;
        this.fIntelligentInstrumentationTracer = intelligentInstrumentationTracer;
    }

    public ICompilerPersonality getPersonality() {
        return this.fPersonality;
    }

    public ClassModificationFilter getFilter() {
        return this.fFilter;
    }

    public String getInstrumentationInfo() {
        return this.fInstrumentationInfo;
    }

    public int getMinOffsetForJumpWidening() {
        return this.fMinOffsetForJumpWidening;
    }

    public IClassName getInstrumentationTraceClass() {
        return this.fTraceClassName;
    }

    public Iterator getTracersIterator() {
        return Arrays.asList(this.fTracers).iterator();
    }

    public Iterator getTracersIterator(String key) {
        List tracersByKey = (List)this.fTracersMap.get(key);
        if (tracersByKey == null) {
            return this.kEmptyTracerList.iterator();
        }
        return tracersByKey.iterator();
    }

    public int getTracersCount() {
        return this.fTracers.length;
    }

    public Iterator getTransformationsIterator() {
        return Arrays.asList(this.fTransformations).iterator();
    }

    private List getClassStructureAlteringTransformations(boolean forValidation) {
        ArrayList<ITransformation> classStructureAlteringTransforms = new ArrayList<ITransformation>();
        int i = 0;
        while (i < this.fTransformations.length) {
            ITransformation t = this.fTransformations[i];
            if (t.isClassStructureAltering(null) && t.shouldValidateDurinDirectiveReload()) {
                classStructureAlteringTransforms.add(t);
            }
            ++i;
        }
        return classStructureAlteringTransforms;
    }

    public DGCompilerSettings validateReloadedSettings(IModuleFeedbackChannel feedback, IStringLocalizer localizer, DGCompilerSettings activeSettings) throws UnsupportedDGCompilerSettingModificationException {
        boolean resetSettings;
        List reloadedClassReplacements = this.getClassStructureAlteringTransformations(true);
        List activeClassReplacements = activeSettings.getClassStructureAlteringTransformations(true);
        boolean bl = resetSettings = !CollectionEquivalenceCheckers.listsAreEquivalent((List)activeClassReplacements, (List)reloadedClassReplacements);
        if (resetSettings) {
            feedback.info(localizer.IStringLocalizer_getLocalizedString("Diagnos_Directives_Unsupported_SubstituteClass_Instrumentation_Change_Info"));
            reloadedClassReplacements.removeAll(activeClassReplacements);
            Iterator i = reloadedClassReplacements.iterator();
            while (i.hasNext()) {
                feedback.info(i.next().toString());
            }
            throw new UnsupportedDGCompilerSettingModificationException();
        }
        ClassModificationFilter reloadedGlobalFilter = this.fFilter;
        ClassModificationFilter activeGlobalFilter = activeSettings.fFilter;
        boolean resetFilter = false;
        if (!activeGlobalFilter.getSkipClasses().equals(reloadedGlobalFilter.getSkipClasses())) {
            feedback.info(localizer.IStringLocalizer_getLocalizedString("Diagnos_Directives_Unsupported_Class_Skip_Instrumentation_Change_Info"));
            resetFilter = true;
        }
        if (!activeGlobalFilter.getSkipPackages().equals(reloadedGlobalFilter.getSkipPackages())) {
            feedback.info(localizer.IStringLocalizer_getLocalizedString("Diagnos_Directives_Unsupported_Package_Skip_Instrumentation_Change_Info"));
            resetFilter = true;
        }
        if (!activeGlobalFilter.getSkipPackagePrefixes().equals(reloadedGlobalFilter.getSkipPackagePrefixes())) {
            feedback.info(localizer.IStringLocalizer_getLocalizedString("Diagnos_Directives_Unsupported_Package_Prefix_Skip_Instrumentation_Change_Info"));
            resetFilter = true;
        }
        if (!activeGlobalFilter.getSkipMethods().equals(reloadedGlobalFilter.getSkipMethods())) {
            feedback.info(localizer.IStringLocalizer_getLocalizedString("Diagnos_Directives_Unsupported_Method_Skip_Instrumentation_Change_Info"));
            resetFilter = true;
        }
        if (resetFilter) {
            throw new UnsupportedDGCompilerSettingModificationException();
        }
        return this;
    }

    public boolean isLikelyToChange(ICompilerLog fLog, Class c) throws InvalidClassNameException {
        if (this.fTransformations != null && this.fTransformations.length > 1) {
            try {
                IModuleFeedbackChannel feedback = AgentShim.getAgent().IAgent_getModuleFeedback();
                if (feedback.isTraceEnabled()) {
                    AgentShim.getAgent().IAgent_getModuleFeedback().trace("There are transformation, the classes are all likely to change");
                }
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
            return true;
        }
        return this.hasTracers(fLog, c);
    }

    public boolean isLikelyToChangeIfRetransformed(ICompilerLog fLog, Class c) throws InvalidClassNameException {
        IModeledClass fTargetClass = this.createRuntimeClass(c);
        if (fTargetClass == null) {
            return true;
        }
        if (this.fFilter.isInstrumentableBootstrapClass(fTargetClass)) {
            return true;
        }
        return this.hasTracers(fLog, fTargetClass, null);
    }

    public boolean hasTracers(ICompilerLog fLog, Class c) throws InvalidClassNameException {
        Iterator iterator = this.getTracersIterator();
        IModeledClass fTargetClass = null;
        if (iterator.hasNext() && (fTargetClass = this.createCodelessClass(c)) == null) {
            return true;
        }
        return this.hasTracers(fLog, fTargetClass, null);
    }

    public boolean hasTracers(ICompilerLog fLog, IModeledClass fTargetClass, IModeledMethod m) throws InvalidClassNameException {
        Iterator iterator = this.getTracersIterator();
        while (iterator.hasNext()) {
            MethodTracer tracer = (MethodTracer)iterator.next();
            if (!tracer.getClassMatcher().IClassMatcher_matches(fTargetClass)) continue;
            IMethodMatcher methodMatcher = tracer.getMethodMatcher();
            if (m != null) {
                if (!this.hasTracerMethod(fLog, fTargetClass, tracer, methodMatcher, m)) continue;
                return true;
            }
            Iterator methods = fTargetClass.getAllDeclaredMethods();
            while (methods.hasNext()) {
                IModeledMethod method = (IModeledMethod)methods.next();
                if (!this.hasTracerMethod(fLog, fTargetClass, tracer, methodMatcher, method)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasTracerMethod(ICompilerLog fLog, IModeledClass fTargetClass, MethodTracer tracer, IMethodMatcher methodMatcher, IModeledMethod method) {
        return methodMatcher.IMethodMatcher_matches(method);
    }

    private IModeledClass createCodelessClass(Class c) {
        IModeledClass result = null;
        try {
            Constructor<?> constr;
            Class<?> codelessClass = Class.forName("com.wily.diagnos.personality.java.classfile.DGCodelessClass");
            if (codelessClass != null && (constr = codelessClass.getConstructor(Class.class)) != null) {
                result = (IModeledClass)constr.newInstance(c);
            }
        }
        catch (MethodNotFoundError methodNotFoundError) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return result;
    }

    private IModeledClass createRuntimeClass(Class c) {
        DGRuntimeClass result = null;
        try {
            result = new DGRuntimeClass(c);
        }
        catch (InvalidClassNameException invalidClassNameException) {}
        return result;
    }

    public TracerGroup getTracerGroup(String groupName) {
        FlagName name = null;
        try {
            name = FlagName.getFlagName(groupName);
        }
        catch (DGInvalidFlagNameException dGInvalidFlagNameException) {}
        if (name == null) {
            return null;
        }
        TracerGroup group = (TracerGroup)this.fGroupMap.get(name);
        return group;
    }

    public ISubscriberAdministrator getSubscriberAdminstrator() {
        return this.fSubscriberAdminstrator;
    }

    public Map getGroupInstrumentableMap() {
        HashMap<Object, Boolean> result = new HashMap<Object, Boolean>();
        Iterator groups = this.fGroupMap.values().iterator();
        while (groups.hasNext()) {
            result.put(groups.next(), Boolean.TRUE);
        }
        List classStructureAlteringTransformation = this.getClassStructureAlteringTransformations(false);
        for (ITransformation t : classStructureAlteringTransformation) {
            TracerGroup tg;
            if (t == null || !(t instanceof ITracerGroupTransformation) || (tg = ((ITracerGroupTransformation)t).getTracerGroup()) == null) continue;
            result.put(tg, Boolean.FALSE);
        }
        return result;
    }

    public MethodTracer getIntelligentInstrumentationMethodTracer() {
        return this.fIntelligentInstrumentationTracer;
    }

    public void setIntelligentInstrumentationTracer(MethodTracer intelligentTracer) {
        this.fIntelligentInstrumentationTracer = intelligentTracer;
    }

    public boolean isIntelligentInstrumentationEnabled() {
        return this.fIntelligentInstrumentationTracer != null;
    }

    public void setIntelligentInstrumentationCriterea(int minimumMethodCallsProperty, int minimumBranchCountProperty, int minimumCombinedProperty) {
        this.fIntelligentInstrumentationMinimumMethodCalls = minimumMethodCallsProperty;
        this.fIntelligentInstrumentationMinimumBranchCount = minimumBranchCountProperty;
        this.fIntelligentInstrumentationMinimumCombined = minimumCombinedProperty;
    }

    public int getIntelligentInstrumentationMinimumMethodCalls() {
        return this.fIntelligentInstrumentationMinimumMethodCalls;
    }

    public int getIntelligentInstrumentationMinimumBranchCount() {
        return this.fIntelligentInstrumentationMinimumBranchCount;
    }

    public int getIntelligentInstrumentationMinimumCombined() {
        return this.fIntelligentInstrumentationMinimumCombined;
    }
}

