/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes.annotations;

import com.wily.diagnos.personality.java.classfile.attributes.annotations.DGAnnotationTypeElementValue;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.DGArrayTypeElementValue;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.DGClassTypeElementValue;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.DGConstantTypeElementValue;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.DGElementValue;
import com.wily.diagnos.personality.java.classfile.attributes.annotations.DGEnumTypeElementValue;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import java.io.DataInputStream;
import java.io.IOException;

public class DGAnnotationAttribute {
    public static final String kRuntimeVisibleAnnotationAttribute = "RuntimeVisibleAnnotations";
    public static final String kRuntimeInvisibleAnnotationAttribute = "RuntimeInvisibleAnnotations";
    public static final String kRuntimeVisibleParameterAnnotationAttribute = "RuntimeVisibleParameterAnnotations";
    public static final String kRuntimeInvisibleParameterAnnotationAttribute = "RuntimeInvisibleParameterAnnotations";
    public static final String kAnnotationDefaultAttribute = "AnnotationDefault";

    public static boolean isPrimitive(char tag) {
        if (tag == 'B') {
            return true;
        }
        if (tag == 'C') {
            return true;
        }
        if (tag == 'D') {
            return true;
        }
        if (tag == 'F') {
            return true;
        }
        if (tag == 'I') {
            return true;
        }
        if (tag == 'J') {
            return true;
        }
        if (tag == 'S') {
            return true;
        }
        return tag == 'Z';
    }

    public static boolean isConstantTypeIndex(char tag) {
        if (DGAnnotationAttribute.isPrimitive(tag)) {
            return true;
        }
        return tag == 's';
    }

    public static boolean isEnumType(char tag) {
        return tag == 'e';
    }

    public static boolean isClassType(char tag) {
        return tag == 'c';
    }

    public static boolean isAnnotationType(char tag) {
        return tag == '@';
    }

    public static boolean isArrayType(char tag) {
        return tag == '[';
    }

    public static DGElementValue getElementValue(char tag, DataInputStream input, DGConstantPool constantPool) throws IOException {
        if (DGAnnotationAttribute.isConstantTypeIndex(tag)) {
            return new DGConstantTypeElementValue(tag, input, constantPool);
        }
        if (DGAnnotationAttribute.isEnumType(tag)) {
            return new DGEnumTypeElementValue(tag, input, constantPool);
        }
        if (DGAnnotationAttribute.isArrayType(tag)) {
            return new DGArrayTypeElementValue(tag, input, constantPool);
        }
        if (DGAnnotationAttribute.isClassType(tag)) {
            return new DGClassTypeElementValue(tag, input, constantPool);
        }
        if (DGAnnotationAttribute.isAnnotationType(tag)) {
            return new DGAnnotationTypeElementValue(tag, input, constantPool);
        }
        return null;
    }
}

