/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.compiler;

import com.wily.diagnos.cmp.DGCompilationFailedException;
import com.wily.diagnos.cmp.batch.DGFileSettings;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.ui.ICompilerUI;
import com.wily.diagnos.personality.java.compiler.DGStreamBatchCompiler;
import com.wily.diagnos.personality.java.compiler.FixZipInputStream;
import com.wily.util.io.ExtendedFile;
import com.wily.util.io.StreamCopier;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class DGZipCompiler
extends DGStreamBatchCompiler {
    private static final String kEmptyArchive = "Archive contains no entries";
    private static final String kTempPrefix = "tmp";
    private static final String kTempSuffix = null;
    protected boolean fInitializationError = false;
    private static int fTempFileCounter = 0;
    private String fDir;
    private String fName;
    private ZipFile fSourceZip;
    private ZipOutputStream fDestZip;
    private Hashtable fWrittenEntries = new Hashtable(47);
    private boolean fHasTempFiles;
    private File fTempSource;
    private File fTempDest;
    private OutputStream fOutput;

    public DGZipCompiler(DGCompilerSettings settings, DGFileSettings fileSettings, ICompilerUI ui, ICompilerLog log, File source, File dest) throws DGCompilationFailedException, IOException {
        super(settings, fileSettings, ui, log);
        this.initialize(source, dest);
    }

    public DGZipCompiler(DGCompilerSettings settings, DGFileSettings fileSettings, ICompilerUI ui, ICompilerLog log, InputStream source, OutputStream dest, String name) throws DGCompilationFailedException, IOException {
        super(settings, fileSettings, ui, log);
        this.initialize(source, dest, name);
    }

    private void initialize(File source, File dest) throws DGCompilationFailedException, IOException {
        this.initialize(source, dest, ExtendedFile.safeGetCanonicalPath((File)source), source.getName());
    }

    private void initialize(File source, File dest, String dir, String name) throws DGCompilationFailedException, IOException {
        this.fDir = dir;
        this.fName = name;
        try {
            this.fSourceZip = this.createSource(source);
            this.fDestZip = this.createDest(dest);
        }
        catch (ZipException ze) {
            this.logException(dir, ze);
            try {
                if (this.fProgressUI != null) {
                    this.fProgressUI.ICompilerUI_handleExceptionProcessingFile(name, ze);
                }
                throw new DGCompilationFailedException(10);
            }
            catch (DGCompilationFailedException dgcfe) {
                this.fInitializationError = true;
                switch (dgcfe.getOption()) {
                    case 10: {
                        this.fileCopy(source, dest);
                        break;
                    }
                    case 11: {
                        this.skipFile(source.getPath());
                        break;
                    }
                    default: {
                        throw dgcfe;
                    }
                }
            }
        }
        if (this.fInitializationError) {
            return;
        }
        Enumeration<? extends ZipEntry> e = this.fSourceZip.entries();
        int entryCount = 0;
        while (e.hasMoreElements()) {
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory()) continue;
            ++entryCount;
        }
        this.prepare(this.fName, entryCount);
    }

    protected ZipFile createSource(File source) throws DGCompilationFailedException, IOException {
        return new ZipFile(source);
    }

    protected ZipOutputStream createDest(File dest) throws IOException {
        return new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));
    }

    protected int getCompressionMethod(ZipEntry entry) {
        return 0;
    }

    private void initialize(InputStream source, OutputStream dest, String name) throws DGCompilationFailedException, IOException {
        this.fHasTempFiles = true;
        this.fTempSource = this.createTempFile(kTempPrefix, kTempSuffix);
        FileOutputStream tempSourceOutput = new FileOutputStream(this.fTempSource);
        StreamCopier.copy((InputStream)source, (OutputStream)tempSourceOutput);
        this.fTempDest = this.createTempFile(kTempPrefix, kTempSuffix);
        this.fOutput = dest;
        this.initialize(this.fTempSource, this.fTempDest, name, name);
    }

    private File createTempFile(String prefix, String suffix) {
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        String directory = System.getProperty("java.io.tmpdir");
        File result = null;
        do {
            String name = String.valueOf(prefix) + fTempFileCounter + suffix;
            result = directory == null ? new File(name) : new File(directory, name);
            if (fTempFileCounter >= 100000) {
                return null;
            }
            ++fTempFileCounter;
        } while (result.exists());
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void compileClassFiles() throws DGCompilationFailedException {
        if (this.fInitializationError) {
            return;
        }
        log = this.getLog();
        if (log != null) {
            log.ICompilerLog_startArchive(this.fDir);
        }
        if ((enumeration = this.fSourceZip.entries()).hasMoreElements()) ** GOTO lbl-1000
        this.logMessage("Archive contains no entries");
        try lbl-1000:
        // 2 sources

        {
            block11: while (true) lbl-1000:
            // 6 sources

            {
                if (!enumeration.hasMoreElements()) {
                    if (log == null) return;
                    log.ICompilerLog_finishArchive(this.fDir);
                    return;
                }
                this.pauseIfNecessary();
                if (this.shouldStop()) {
                    if (log != null) {
                        log.ICompilerLog_finishAborted(this.fDir);
                    }
                    this.cancel();
                    return;
                }
                entry = enumeration.nextElement();
                entryName = entry.getName();
                try {
                    this.verifyEntry(entry);
                    try {
                        entryIn = this.getZipStream(entry, this.fSourceZip);
                        if (this.isClassFile(entryName)) {
                            this.handleClassFile(entry, entryIn);
                            continue;
                        }
                        if (this.isZipFile(entryName) || this.isJarFile(entryName)) {
                            this.handleZipFile(entry, entryIn);
                            continue;
                        }
                        this.handleGenericFile(entry, entryIn);
                        continue;
                    }
                    catch (IOException ioe) {
                        this.logException(entryName, ioe);
                        if (this.fProgressUI == null) throw new DGCompilationFailedException(12);
                        this.fProgressUI.ICompilerUI_handleExceptionCopyingFile(entryName, ioe);
                        throw new DGCompilationFailedException(12);
                    }
                }
                catch (DGCompilationFailedException dgcfe) {
                    switch (dgcfe.getOption()) {
                        case 10: {
                            this.copyEntry(entry);
                            ** break;
                        }
                        case 11: {
                            this.skipFile(entryName);
                            continue block11;
                        }
                    }
                    throw dgcfe;
                }
                break;
            }
        }
        catch (DGCompilationFailedException dgcfe) {
            if (log == null) throw dgcfe;
            log.ICompilerLog_finishException(this.fDir);
            throw dgcfe;
        }
        catch (IOException ioe) {
            this.logException(this.fName, ioe);
            if (log == null) throw new DGCompilationFailedException(10);
            log.ICompilerLog_finishException(this.fDir);
            throw new DGCompilationFailedException(10);
        }
    }

    protected void verifyEntry(ZipEntry entry) throws DGCompilationFailedException {
    }

    private InputStream getZipStream(ZipEntry entry, ZipFile source) throws IOException {
        InputStream input = this.fSourceZip.getInputStream(entry);
        return new BufferedInputStream(new FixZipInputStream(input));
    }

    private InputStream getZipStreamAgain(ZipEntry entry) throws IOException {
        return this.getZipStream(entry, this.fSourceZip);
    }

    private void copyEntry(ZipEntry entry) throws DGCompilationFailedException, IOException {
        InputStream entryIn = this.getZipStreamAgain(entry);
        this.writeNewEntry(entryIn, entry);
    }

    private void handleClassFile(ZipEntry entry, InputStream entryIn) throws DGCompilationFailedException, IOException {
        try {
            ByteArrayOutputStream entryOut = new ByteArrayOutputStream(16384);
            this.compileClassFile(entryIn, entryOut, entry.getName());
            this.outputToZip(entry, entryOut);
        }
        catch (DGCompilationFailedException dgcfe) {
            switch (dgcfe.getOption()) {
                case 10: {
                    InputStream input = this.getZipStreamAgain(entry);
                    this.writeNewEntry(input, entry);
                    break;
                }
                case 11: {
                    this.skipFile(entry.getName());
                    break;
                }
                default: {
                    throw dgcfe;
                }
            }
        }
    }

    private void handleZipFile(ZipEntry entry, InputStream entryIn) throws DGCompilationFailedException, IOException {
        try {
            try {
                ByteArrayOutputStream entryOut = new ByteArrayOutputStream(16384);
                DGZipCompiler cmp = new DGZipCompiler(this.fSettings, this.fFileSettings, this.fProgressUI, this.getLog(), entryIn, entryOut, entry.getName());
                cmp.setInterruptSource(this.getInterruptSource());
                cmp.compileAll();
                this.outputToZip(entry, entryOut);
            }
            catch (DGCompilationFailedException dgcfe) {
                switch (dgcfe.getOption()) {
                    case 10: {
                        InputStream input = this.getZipStreamAgain(entry);
                        this.writeNewEntry(input, entry);
                        break;
                    }
                    case 11: {
                        this.skipFile(entry.getName());
                        break;
                    }
                    default: {
                        throw dgcfe;
                    }
                }
                this.setupUI();
            }
        }
        finally {
            this.setupUI();
        }
    }

    private void handleGenericFile(ZipEntry entry, InputStream entryIn) throws DGCompilationFailedException, IOException {
        this.updateStatusBar(entry.getName());
        if (this.fFileSettings.shouldCopyItems()) {
            this.writeNewEntry(entryIn, entry);
        } else {
            this.skipFile(entry.getName());
        }
    }

    private void outputToZip(ZipEntry entry, ByteArrayOutputStream output) throws DGCompilationFailedException, IOException {
        this.output(entry, null, output.toByteArray(), false);
    }

    protected void writeNewEntry(InputStream entryData, ZipEntry entry) throws DGCompilationFailedException, IOException {
        this.output(entry, entryData, null, true);
    }

    protected void writeNewEntry(InputStream entryData, String entryPath) throws DGCompilationFailedException, IOException {
        entryPath = entryPath.replace(File.separatorChar, '/');
        this.output(new ZipEntry(entryPath), entryData, null, true);
    }

    private void output(ZipEntry srcEntry, InputStream input, byte[] bytes, boolean isCopy) throws DGCompilationFailedException, IOException {
        if (input == null && bytes == null) {
            throw new NullPointerException("No data source supplied!");
        }
        String entryName = srcEntry.getName();
        if (this.fWrittenEntries.get(entryName) != null) {
            return;
        }
        int compressionMethod = this.getCompressionMethod(srcEntry);
        ZipEntry outEntry = new ZipEntry(entryName);
        outEntry.setMethod(compressionMethod);
        if (compressionMethod == 0) {
            if (bytes == null) {
                ByteArrayOutputStream output = new ByteArrayOutputStream(16384);
                StreamCopier.copy((InputStream)input, (OutputStream)output);
                bytes = output.toByteArray();
                input = null;
            }
            CRC32 crc = new CRC32();
            crc.update(bytes);
            outEntry.setSize(bytes.length);
            outEntry.setCrc(crc.getValue());
        }
        if (input == null) {
            input = new ByteArrayInputStream(bytes);
        }
        this.fDestZip.putNextEntry(outEntry);
        if (isCopy) {
            this.copyFile(input, this.fDestZip, entryName);
        } else {
            StreamCopier.copy((InputStream)input, (OutputStream)this.fDestZip);
        }
        this.fDestZip.closeEntry();
        this.fWrittenEntries.put(entryName, entryName);
    }

    protected void sign() {
    }

    @Override
    protected void close() throws IOException {
        super.close();
        if (this.fInitializationError) {
            return;
        }
        this.fDestZip.close();
        this.fSourceZip.close();
        this.sign();
        if (this.fHasTempFiles) {
            FileInputStream input = new FileInputStream(this.fTempDest);
            StreamCopier.copy((InputStream)input, (OutputStream)this.fOutput);
            this.fTempSource.delete();
            this.fTempDest.delete();
        }
    }
}

