/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.tracer;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.cmp.classfile.DGInvalidDescriptorException;
import com.wily.diagnos.cmp.mutate.IMutation;
import com.wily.diagnos.cmp.tracer.DGAggregateMethodTracer;
import com.wily.diagnos.cmp.tracer.TracerUtilities;
import com.wily.diagnos.personality.java.classfile.DGMethod;
import com.wily.diagnos.personality.java.classfile.DGMethodDescriptor;
import com.wily.diagnos.personality.java.classfile.bytecode.AggregateMethodTracerBeginByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.DGByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.MethodExitByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.MethodStubbingByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.MethodTracerCatchByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.MinimumAggregateMethodTracerBeginByteCode;
import com.wily.diagnos.personality.java.classfile.bytecode.MinimumExceptionHandlingMethodTracerCatchByteCode;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.diagnos.personality.java.tracer.IJavaMethodTracerInstance;
import com.wily.util.classfile.java.ClassName;
import com.wily.wilyassert.Assertion;
import java.io.IOException;

public class DGAggregateMethodTracerInstance
implements IMutation,
IJavaMethodTracerInstance {
    private final DGAggregateMethodTracer fMethodTracer;
    private final DGMethod fMethod;
    private final ClassName fTracerLoadingClass;
    private final DGMethodDescriptor fMethodDescriptor;
    private int fCPITracerLoader;
    private int fCPITracerFinishTrace;
    private int fCPIProbeHashCode;
    private int fCPIProbeClassName;
    private int fCPIProbeMethodName;
    private int fCPIProbeMethodDescriptor;
    private int fCPIParameter;
    private int fLocalTracer;
    private int fCPIShouldStubMethod;

    public DGAggregateMethodTracerInstance(DGAggregateMethodTracer tracer, DGMethod method, ClassName tracerLoadingClass) {
        this.fMethodTracer = tracer;
        this.fMethod = method;
        this.fTracerLoadingClass = tracerLoadingClass;
        this.fMethodDescriptor = this.getDescriptor(this.fMethod);
        String lineInfo = this.fMethod.getLineOfCodeInfo();
        this.fMethodTracer.setLineInfo(lineInfo);
    }

    @Override
    public final void mutate() throws DGClassModificationException, IOException {
        this.initialize();
        this.fMethod.applyTracerMutation(this);
    }

    private DGMethodDescriptor getDescriptor(DGMethod method) {
        try {
            return new DGMethodDescriptor(method.getTypeDescriptor());
        }
        catch (DGInvalidDescriptorException dGInvalidDescriptorException) {
            Assertion.unimplemented((String)"All methods should have valid descriptors");
            return new DGMethodDescriptor();
        }
    }

    protected void initialize() throws DGClassModificationException {
        String probeClassName = this.fMethod.getDGClass().getClassName().getPackageAndNameString().replace('/', '.');
        String parameter = this.fMethodTracer.getTracerParameter();
        DGConstantPool constantPool = this.fMethod.getConstantPool();
        String loaderName = this.getLoaderName();
        String loaderDescriptor = this.getLoaderDescriptor();
        this.fCPITracerLoader = constantPool.addMethodReferenceIfNecessary(this.fTracerLoadingClass.toString(), loaderName, loaderDescriptor);
        this.fCPITracerFinishTrace = constantPool.addInterfaceMethodReferenceIfNecessary("com/wily/introscope/agent/trace/IMethodTracer", "IMethodTracer_finishTrace", "()V");
        this.fCPIProbeClassName = constantPool.addStringIfNecessary(probeClassName);
        this.fCPIProbeMethodName = constantPool.addStringIfNecessary(this.fMethod.getName());
        this.fCPIProbeMethodDescriptor = constantPool.addStringIfNecessary(this.fMethodDescriptor.toString());
        int hashcode = this.getHashcode(probeClassName, this.fMethod.getName(), this.fMethodDescriptor.toString(), parameter);
        this.fCPIProbeHashCode = constantPool.addInteger(hashcode);
        this.fCPIParameter = constantPool.addStringIfNecessary(parameter);
        this.fCPIShouldStubMethod = this.addShouldStubMethod(constantPool);
    }

    private int addShouldStubMethod(DGConstantPool constantPool) throws DGClassModificationException {
        return constantPool.addInterfaceMethodReferenceIfNecessary("com/wily/introscope/agent/trace/IMethodTracer", "IMethodTracer_shouldStub", "()Z");
    }

    protected int getHashcode(String probeClassName, String methodName, String methodDescriptor, String parameter) {
        return TracerUtilities.calculateProbeHashCode(probeClassName, methodName, methodDescriptor, parameter);
    }

    protected final int getProbeHashCodeCPI() {
        return this.fCPIProbeHashCode;
    }

    protected final DGMethodDescriptor getMethodDescriptor() {
        return this.fMethodDescriptor;
    }

    protected int getTracerLoaderCPI() {
        return this.fCPITracerLoader;
    }

    protected int getTracerFinishTracerCPI() {
        return this.fCPITracerFinishTrace;
    }

    protected int getProbeClassNameCPI() {
        return this.fCPIProbeClassName;
    }

    protected int getProbeMethodNameCPI() {
        return this.fCPIProbeMethodName;
    }

    protected int getProbeMethodDescriptorCPI() {
        return this.fCPIProbeMethodDescriptor;
    }

    protected int getParameterCPI() {
        return this.fCPIParameter;
    }

    protected int getLocalTracer() {
        return this.fLocalTracer;
    }

    protected void setLocalTracer(int localTracer) {
        this.fLocalTracer = localTracer;
    }

    protected DGMethod getMethod() {
        return this.fMethod;
    }

    protected DGConstantPool getConstantPool() {
        return this.getMethod().getConstantPool();
    }

    protected String getTracerLoadingClass() {
        return this.fTracerLoadingClass.toString();
    }

    protected String getLoaderName() {
        return "ProbeBuilderEntryPoint_loadTracer";
    }

    protected String getLoaderDescriptor() {
        return "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;Ljava/lang/String;)Lcom/wily/introscope/agent/trace/IMethodTracer;";
    }

    protected int getLocalThisStorage() {
        return -1;
    }

    protected int getSetInvocationObjectCPI() {
        return -1;
    }

    @Override
    public DGByteCode IMethodTracerInstance_getBeginByteCode() throws DGClassModificationException, IOException {
        if (this.isMinimum()) {
            MinimumAggregateMethodTracerBeginByteCode beginByteCode = new MinimumAggregateMethodTracerBeginByteCode(this.fMethod.getCode(), this.fCPITracerLoader, this.fMethod.isStatic(), this.fCPIProbeHashCode, this.fCPIProbeClassName, this.fCPIProbeMethodName, this.fCPIProbeMethodDescriptor, this.fCPIParameter, this.getLocalThisStorage());
            this.setLocalTracer(beginByteCode.fLocal_tracer);
            return beginByteCode;
        }
        AggregateMethodTracerBeginByteCode beginByteCode = new AggregateMethodTracerBeginByteCode(this.fMethod.getCode(), this.fCPITracerLoader, this.fMethod.isStatic(), this.fCPIProbeHashCode, this.fCPIProbeClassName, this.fCPIProbeMethodName, this.fCPIProbeMethodDescriptor, this.fCPIParameter, this.getLocalThisStorage(), this.fCPIShouldStubMethod, this.needsStubbing());
        this.setLocalTracer(beginByteCode.fLocal_tracer);
        return beginByteCode;
    }

    protected boolean isMinimum() {
        return false;
    }

    @Override
    public DGByteCode IMethodTracerInstance_getCatchByteCode() throws DGClassModificationException, IOException {
        if (this.isMinimum()) {
            MinimumExceptionHandlingMethodTracerCatchByteCode catchByteCode = new MinimumExceptionHandlingMethodTracerCatchByteCode(this.getLocalTracer(), this.getTracerFinishTracerCPI(), this.getTracerSetThrownExceptionCPI());
            catchByteCode.initialize();
            return catchByteCode;
        }
        MethodTracerCatchByteCode catchByteCode = new MethodTracerCatchByteCode(this.getLocalTracer(), this.getTracerFinishTracerCPI());
        catchByteCode.initialize();
        return catchByteCode;
    }

    protected int getTracerSetThrownExceptionCPI() {
        return 0;
    }

    @Override
    public DGByteCode IMethodTracerInstance_getMethodExitByteCode(int exitOpcode) throws DGClassModificationException, IOException {
        MethodExitByteCode methodExitCode = new MethodExitByteCode(this.getLocalThisStorage(), this.getSetInvocationObjectCPI(), this.getLocalTracer());
        methodExitCode.initialize(exitOpcode, this.getTracerFinishTracerCPI());
        return methodExitCode;
    }

    protected boolean needsStubbing() {
        return this.fMethodTracer.needsStubbing();
    }

    @Override
    public DGByteCode IMethodTracerInstance_getStubbingCode() throws DGClassModificationException, IOException {
        if (this.needsStubbing()) {
            MethodStubbingByteCode methodStubbingCode = new MethodStubbingByteCode(this.getLocalThisStorage(), this.fCPIShouldStubMethod, this.getLocalTracer());
            methodStubbingCode.initialize(true, this.fMethod.getCode());
            return methodStubbingCode;
        }
        return null;
    }
}

