# Set Enterprise Manager Connection Properties

Specify the Enterprise Manager host and port as properties on the
application start-up command, e.g.

	-DagentManager.url.1={EMHost}:{EMPort}
---
# spring-boot (2022.6.0.9)

# Instructions
Place tar.gz into extensions/deploy inside java agent directory
---
# muleesb (2022.6.0.9)
# Mule Esb Monitoring

## Description
Mule ESB is a lightweight Java-based enterprise service bus (ESB) and integration platform that allows developers to connect applications together quickly and easily, enabling them to exchange data. Mule ESB enables easy integration of existing systems, regardless of the different technologies that the applications use, including JMS, Web Services, JDBC, HTTP, and more. The key advantage of an ESB is that it allows different applications to communicate with each other by acting as a transit system for carrying data between applications within your enterprise or across the Internet.

# Installation Instructions
Mule extension is part of the default agent installer, no additional steps are needed.
## Usage Instructions
The Mule ESB is structured into three main areas driven by defined "Flow" The monitoring solution extension provides visibility into the Transport Layer, Integration Layer and Application Layer visualizing the invocation elements by individual Flows.

          
### Inbound HTTP Traffic

* HTTP Endpoint ( Mule 3.6 and higher) : 
 The monitoring solution aligns with the standard CA APM features and visualizes inbound HTTP traffic via SOAP or Restful Web Services in the Frontend node in the investigator. The Apps metric path item is replaced with the name 
 or identification of the deployed Mule ESB application. The URI section, if not configured different (configuration section) is formatted with the defined URI of the HTTP Listener configuration. 
 'Frontends|Apps|{mule-application-name}' and 
 'Frontends|Apps|{mule-application-name}|URLs|{URI defined in Mule HTTP Listener}'
  		  	
* Mule ESB 3.3.0 HTTP Message Receiver Support : 
  The usage of the deprecated older HTTP Message Receiver is still supported. Metrics are visualized different on this HTTP Message Receiver component. The App node in the metric path is replaced by the receiver name and the URLs path with the 
  initial HTTP listening flow name.
 'Frontends|Apps|{mule-http-receiver-name}' and 
 'Frontends|Apps|{mule-http-receiver-name}|URLs|{mule-flow-name}'
 
* CXF Inbound Web Services : 
  In addition to the inbound http frontend metrics, the mule esb extension also visualizes inbound Web Services calls under the Web Services node in the Investigator. The first part of the custom metric path contains the http request path and the 
  second any available soap action.
  'Webservices|Server|{http-request-path}' and 
  'Webservices|Server|{http-request-path}|{soap-action}'
  		

### Outbound HTTP requests
 For outbound HTTP requests, the monitoring solution leverages the Backends node identical to all other CA APM solutions. HTTP calls are shown with the formatting 'Backends|WebService at {protocol}_//{host}_{port}|Paths|{path}' where the path component is being replaced by the path element of the request URI.In addition to the standard metrics, the Mule monitoring extension creates the metric Async Invocation Time (ms) metric. The Async Invocation Time is computed based on the async communication behaviour for outbound HTTP calls. By measuring the HTTP Response in the request flow, CA APM can measure the time to establish a request (Async Invocation Time) and the total round trip / request - response time for a request (Average Response Time).The Transaction Trace visualization also differs because of the async nature of the requests.		


### HTTP request payload visualization
As a special feature, the monitoring solution visualizes the HTTP payload of all inbound and outbound requests including the response payload. The payload is visualized in the transaction trace on the root component of the correspondent process sending or receiving the call.Besides HTTP traffic monitoring, this solution provides inbound and outbound message processing coverage for all defined endpoints in the Mule Flow. 
   

### Flow Visualization

Flows are the main transactional processes inside the Mule ESB framework. The monitoring solution has a special coverage for Flows with additional metrics making it easier to understand the requests and showing detailed error and analysis 
information.Flows are visualized at the Mule|Flows node.

Flow usage Metrics : 
'Mule|Flows:Active Flow Instances'	- The number of active flow instances. Instances are usually active while in listening mode.
'Mule|Flows:Average Branch Processing Time (ms)' - The average total time spent on the flow for processing. 
'Mule|Flows:Branch Processings Per Interval' -	The number of branches processed for this flow per interval.
---
#This extension comes with java agent..no installation needed for this
---
#This extension comes with java agent..no installation needed for this
---
#This extension comes with java agent..no installation needed for this
---
## Description

# Installation Instructions
---
# Simpleframework extension
There is no installation required. This extension is part of default agent installation.

# Simpleframework Monitoring
This extension fully supports handle operations displaying details like metrics, correlation and Team Center support.
* Whenever a new request is initiated, the Investigator in Introscope shows the metric under Backends. 
  * Metric "Backends|Simpleframework on 127.0.0.1 at {port}"

---
#  JSMPP extension
There is no installation required. This extension is part of default agent installation.
# JSMPP Monitoring
This extension fully supports JSMPP Session operations  displaying details like metrics, correlation and Team Center support.
* Whenever a new request is initiated, the Investigator in Introscope shows the metric under Backends. 
  * Metric "Backends|SMPP on {jsmpp_host} at {jsmpp_port}|{method name}"

---
## Description
The extension provides web service backend visibility where OkHttp is used as a client in web applications.


# Installation Instructions
There is no installation required. This comes as a part of default java agent.
---
#  Elasticsearch Server extension
There is no installation required. This extension is part of default agent installation.


# Elasticsearch Monitoring
This extension supports following Elasticsearch operations 
(namely get, index, update, delete, bulk request and search query) 
displaying details like metrics, correlation and Team Center support.
* Whenever a new request is initiated, the Investigator in Introscope shows the initiation as a metric under Backends. It contains the node and port values.
  * Metric "Backends|Elasticsearch at 127.0.0.1 on port 9300|Indices|{Index Name}|{Operation}"
---
#  Couchbase Server extension
There is no installation required. This extension is part of default agent installation.

# Couchbase Monitoring
This extension fully supports Couchbase operations (namely get, insert, update, replace and query) displaying details like metrics, correlation and Team Center support.
* Whenever a new request is initiated, the Investigator in Introscope shows the metric under Backends. It contains the bucket, node and port values.
  * Metric "Backends|Couchbase on 127.0.0.1 at 8091|{bucket name}| {method name}"

---
#  Zuul Extension
There is no installation required. This extension is part of all java agents.

# Zuul Monitoring
represents metrics corresponds to filters
---
#  Ribbon Extension
There is no installation required. This extension is part of all java agents.

# Ribbon Monitoring
represents metrics corresponds to ribbon load balancer.
---
#  Spring Cloud Gateway Extension
There is no installation required. This extension is part of all java agents.

# Spring Cloud Gateway Monitoring
represents metrics corresponds to routers and filters
---
#  Hystrix Extension
There is no installation required. This extension is part of all java agents.

# Hystrix Monitoring
represents metrics corresponds to Hystrix commands.
---
# springrabbitmq (2022.6.0.9)

# Spring AMQP Rabbit MQ Monitoring
In addition to the core Introscope Agent capability of JMS monitoring, this monitoring extensions adds support for Spring AMQP based message handling for Rabbit MQ.
* Inbound Message Handling
  1. With the help of this extension,Introscope discovers inbound messages as request and transaction starting points.
  2. Introscope visualizes the inbound message and request start point as a Frontends|Messaging Services (onMessage)|Queue|{queue}.
* Outbound Message Handling
  1. Outbound messaging calls (Message Put) are shown at the Backends node in the Investigator.The Rabbit MQ and the detailed queue name for the outbound message.
  2. Metric "Backends|Messaging Services (outgoing)|Queue|{queue}".

---
# spring-mongo (2022.6.0.9)

# Spring Mongo DB Monitoring
* This is a monitoring solution for Spring MongoDB API requests with full support of request details towards the Mongo DB instance.
* Introscope shows the calls to the MongoDB at the Backend node starting with "Mongo DB on {host} at {port}". 
* Further details are discovered request type, the related object to the request and if available, the request criteria.
---
# Other Bundle: Instrument any Java Application

1. Add this at the beginning of your JVM command line arguments:

        -javaagent:$AGENT_HOME/Agent.jar

2. Restart the JVM.

Note: the notional variable `AGENT_HOME` is a convention used throughout the install instructions to refer to the `wily` directory under
where the Agent package was extracted.