@echo off
:: START OF USAGE
::
:: This script generates the value for the -javaagent directive to your java process
::
:: Add a variable JAVA_AGENT to your script, that starts your java process, to store the generated value from this script (example shown below)
::     FOR /F "tokens=*" %%g IN ('call path-to\agent-location.bat') do (SET JAVA_AGENT=%%g)
::
:: Then, use this variable against the -javaagent directive in your command that starts your java process (shown below)
::     <initial part of command> -javaagent:%JAVA_AGENT% <rest of command>
::
:: NOTE: The variable needs to be declared before it is used
::
::
:: END OF USAGE
::
::
::
::
::Get the scriptfile location
set SCRIPT_DIR=%~dp0%
:: Get release version
set /p RELEASE=<%SCRIPT_DIR%agent.release
:: Generate release dir
set RELEASE_DIR=%SCRIPT_DIR%releases\%RELEASE%
:: Generate java agent string
echo %RELEASE_DIR%\Agent.jar -Dcom.wily.introscope.agentProfile=%RELEASE_DIR%\core\config\IntroscopeAgent.profile -Dintroscope.agent.bootstrap.home=%SCRIPT_DIR% -Dintroscope.agent.bootstrap.release.version=%RELEASE% -Dintroscope.agent.bootstrap.version.loaded=%RELEASE%