/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.SQLAgentConfiguration;
import com.wily.introscope.agent.sqlagent.StatementNormalizer;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ISharedMetricHolder;
import com.wily.introscope.agent.trace.hc2.ASingleMetricTracerFactory;
import com.wily.util.adt.WeakIdentityHashMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.sql.Statement;

public final class ProbeStatementToSQLMappingTracer
extends ASingleMetricTracerFactory {
    private static SQLAgentConfiguration fConfiguration;
    public static final String kSQLParameterIndexKey = "sqlparameterindex";
    private static IModuleFeedbackChannel feedback;
    private static final Module module;
    private final int sqlParameterIndex;
    private static ThreadLocal<WeakIdentityHashMap> threadLocalMap;

    static {
        module = new Module("ProbeStatementToSQLMappingTracer");
        try {
            fConfiguration = SQLAgentConfiguration.getInstance(AgentShim.getAgent());
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
        threadLocalMap = new ThreadLocal<WeakIdentityHashMap>(){

            @Override
            protected WeakIdentityHashMap initialValue() {
                return new WeakIdentityHashMap();
            }
        };
    }

    public ProbeStatementToSQLMappingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        feedback = this.getAgent().IAgent_getModuleFeedback();
        this.sqlParameterIndex = this.getIntegerParameter(kSQLParameterIndexKey, 0);
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String normalizedSqlForMetricName;
        Object statement = data.getInvocationObject();
        if (statement == null) {
            return;
        }
        if (!(statement instanceof Statement)) {
            Assertion.wilyAssert((String)"Expected a Statement");
            return;
        }
        if (data.getInvocationParameterCount() == 0) {
            Assertion.wilyAssert((String)"No parameters are available");
            return;
        }
        Object sql = data.getInvocationParameterAsObject(this.sqlParameterIndex);
        String rawSQL = "null";
        if (sql != null) {
            rawSQL = sql.toString();
        }
        if ((normalizedSqlForMetricName = this.normalizeForMetricName(rawSQL)) == null) {
            Assertion.wilyAssert((String)"Normalization didn't work");
            return;
        }
        String normalizedSqlForUserView = this.normalizeForUserView(rawSQL, normalizedSqlForMetricName);
        if (normalizedSqlForUserView == null) {
            Assertion.wilyAssert((String)"Normalization didn't work");
            return;
        }
        String sqlType = "Prepared";
        String rawSQL_LC = rawSQL.toLowerCase();
        if (rawSQL_LC.startsWith("call")) {
            sqlType = "Stored Procedures";
        }
        String sqlCRUDType = "Query";
        if (rawSQL_LC.startsWith("update") || rawSQL_LC.startsWith("delete") || rawSQL_LC.startsWith("insert")) {
            sqlCRUDType = "Update";
        }
        String rawSQLinMap = null;
        try {
            if (fConfiguration.shouldIncludeRawSQL()) {
                rawSQLinMap = rawSQL;
            }
        }
        catch (Exception exception) {}
        ProbeStatementToSQLMappingTracer.putMapping(statement, rawSQLinMap, normalizedSqlForMetricName, normalizedSqlForUserView, sqlType, sqlCRUDType);
    }

    public static void putMapping(Object statement, String rawSQL, String sqlForMetricName, String sqlForUserView, String sqlType, String sqlcrudtype) {
        SQLAndTypeRecord rec = new SQLAndTypeRecord(rawSQL, sqlForMetricName, sqlForUserView, sqlType, sqlcrudtype);
        WeakIdentityHashMap statementToSQL = threadLocalMap.get();
        statementToSQL.put(statement, (Object)rec);
    }

    private String normalizeForMetricName(String sql) {
        String answer = StatementNormalizer.normalizeSQL(sql, fConfiguration.getNormalizedMaxSQLLength());
        return answer;
    }

    private String normalizeForUserView(String sql, String normalizedForMetricName) {
        String answer = StatementNormalizer.normalizeSQLForUserView(sql, normalizedForMetricName, fConfiguration.getNormalizedMaxSQLLength());
        return answer;
    }

    public static String getSQL(Statement statement) {
        return ProbeStatementToSQLMappingTracer.getSQL(statement, true);
    }

    public static String getSQL(Statement statement, boolean forMetricName) {
        WeakIdentityHashMap statementToSQL;
        SQLAndTypeRecord record;
        String result = null;
        if (statement != null && (record = (SQLAndTypeRecord)(statementToSQL = threadLocalMap.get()).get((Object)statement)) != null) {
            result = forMetricName ? record.fSQLForMetricName : record.fSQLForUserView;
        }
        return result;
    }

    public static String getRawSQL(Statement statement) {
        WeakIdentityHashMap concStatementToSQL;
        SQLAndTypeRecord record;
        String result = null;
        if (statement != null && (record = (SQLAndTypeRecord)(concStatementToSQL = threadLocalMap.get()).get((Object)statement)) != null) {
            result = record.fRawSQL;
        }
        return result;
    }

    public static String getSQLType(Statement statement) {
        WeakIdentityHashMap concStatementToSQL;
        SQLAndTypeRecord record;
        if (statement != null && (record = (SQLAndTypeRecord)(concStatementToSQL = threadLocalMap.get()).get((Object)statement)) != null) {
            return record.fType;
        }
        return null;
    }

    public static String getSQLOPType(Statement statement) {
        WeakIdentityHashMap concStatementToSQL;
        SQLAndTypeRecord record;
        if (statement != null && (record = (SQLAndTypeRecord)(concStatementToSQL = threadLocalMap.get()).get((Object)statement)) != null) {
            return record.fSqlCRUDType;
        }
        return null;
    }

    protected IRepository getRepository(InvocationData data, ISharedMetricHolder holder) {
        return null;
    }

    protected void doOnStartTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    protected void doOnEndTrace(int tracerIndex, IStackElement data, ASingleMetricTracerFactory.ISingleMetricHolder mh) {
    }

    private static final class SQLAndTypeRecord {
        public String fSQLForMetricName;
        public String fSQLForUserView;
        public String fType;
        public String fSqlCRUDType;
        public String fRawSQL;

        public SQLAndTypeRecord(String rawSQL, String sqlForMetricName, String sqlForUserView, String type, String sqlcrudtype) {
            this.fRawSQL = rawSQL;
            this.fSQLForMetricName = sqlForMetricName;
            this.fSQLForUserView = sqlForUserView;
            this.fType = type;
            this.fSqlCRUDType = sqlcrudtype;
        }
    }
}

