/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.sqlagent.SQLAgentConfiguration;
import com.wily.introscope.agent.sqlagent.StatementToSQLMappingTracer;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class SQLExecuteTimer
extends ASingleInstanceTracerFactory {
    public static final int kDefaultStringBufferSize = 200;
    public static final Map sMethodToSQLSubtypeMap = new HashMap();
    public static final Map sMethodToRateAttributeMap = new HashMap();
    public static final Map sMethodToAverageAttributeMap = new HashMap();
    public static final Map sSQLSubtypeToTTKeyMap = new HashMap();
    public static final String kMetricPathCacheKey = "com.wily.introscope.agent.sqlagent.execute.metric.path";
    private final SQLAgentConfiguration fConfiguration;

    static {
        sMethodToSQLSubtypeMap.put("execute", "General");
        sMethodToRateAttributeMap.put("execute", "Statements Per Second");
        sMethodToAverageAttributeMap.put("execute", "Average Statement Time (ms)");
        sMethodToSQLSubtypeMap.put("executeQuery", "Query");
        sMethodToRateAttributeMap.put("executeQuery", "Queries Per Second");
        sMethodToAverageAttributeMap.put("executeQuery", "Average Query Time (ms)");
        sMethodToSQLSubtypeMap.put("executeUpdate", "Update");
        sMethodToRateAttributeMap.put("executeUpdate", "Updates Per Second");
        sMethodToAverageAttributeMap.put("executeUpdate", "Average Update Time (ms)");
        sMethodToSQLSubtypeMap.put("executeBatch", "Batch");
        sMethodToRateAttributeMap.put("executeBatch", "Statement Batches Per Second");
        sMethodToAverageAttributeMap.put("executeBatch", "Average Statement Batch Time (ms)");
        sSQLSubtypeToTTKeyMap.put("Dynamic", "Dynamic SQL");
        sSQLSubtypeToTTKeyMap.put("Prepared", "Prepared SQL");
        sSQLSubtypeToTTKeyMap.put("Stored Procedures", "Stored Procedure SQL");
    }

    public static String getTTKey(String sqlSubtype) {
        return (String)sSQLSubtypeToTTKeyMap.get(sqlSubtype);
    }

    public SQLExecuteTimer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fConfiguration = SQLAgentConfiguration.getInstance(agent);
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kInstance;
    }

    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String path;
        data.storeWallClockStartTime();
        ComponentTracer componentTracer = this.getComponentTracer();
        if (this.fConfiguration.shouldParticipateInBlame() && componentTracer != null && (path = this.getMetricPath(data)) != null) {
            IBlameStack stack = data.getStack(componentTracer, true);
            componentTracer.addComponent(stack, path, SQLExecuteTimer.getTTKey(this.getSQLSubtype(data)), this.getNormalizedSQL(data));
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        int elapsedTime = data.getWallClockElapsedTimeAsInt();
        try {
            this.handleFinishTrace(data, elapsedTime);
        }
        finally {
            String path;
            ComponentTracer componentTracer = this.getComponentTracer();
            if (this.fConfiguration.shouldParticipateInBlame() && componentTracer != null && (path = this.getMetricPath(data)) != null) {
                IBlameStack stack = data.getStack(componentTracer, false);
                componentTracer.removeComponent(stack, path);
            }
        }
    }

    private void handleFinishTrace(InvocationData data, int elapsedTime) {
        IIntegerAverageDataAccumulator average = null;
        IIntegerRateDataAccumulator rate = null;
        String method = this.getProbeIdentification().getProbeMethodName();
        String path = this.getMetricPath(data);
        if (path == null) {
            return;
        }
        String rateAttribute = (String)sMethodToRateAttributeMap.get(method);
        String averageAttribute = (String)sMethodToAverageAttributeMap.get(method);
        try {
            String averageMetric = String.valueOf(path) + ":" + averageAttribute;
            average = this.getDataAccumulatorFactory().getIntegerAverageDataAccumulator(averageMetric);
            String rateMetric = String.valueOf(path) + ":" + rateAttribute;
            rate = this.getDataAccumulatorFactory().getIntegerRateDataAccumulator(rateMetric);
        }
        catch (ConflictingTypesException conflictingTypesException) {
            Assertion.wilyAssert((String)"conflicting types");
            return;
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
            Assertion.wilyAssert((String)"badly formed name");
            return;
        }
        BlameStackSnapshot snapshot = this.getBlameStackSnapshot(data, path);
        if (!rate.IDataAccumulator_isShutOff()) {
            rate.IIntegerRateDataAccumulator_addSingleIncident(snapshot);
        }
        if (!average.IDataAccumulator_isShutOff()) {
            average.IIntegerAggregatingDataAccumulator_recordDataPoint(elapsedTime, snapshot);
        }
    }

    private BlameStackSnapshot getBlameStackSnapshot(InvocationData data, String path) {
        ComponentTracer componentTracer = this.getComponentTracer();
        if (this.fConfiguration.shouldParticipateInBlame() && componentTracer != null) {
            IBlameStack stack = data.getStack(componentTracer, false);
            return componentTracer.getSnapshot(stack, path);
        }
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    protected String getNormalizedSQL(InvocationData data) {
        Statement tracedObject = (Statement)data.getInvocationObject();
        return StatementToSQLMappingTracer.getSQL(tracedObject);
    }

    protected String getSQLSubtype(InvocationData data) {
        Statement tracedObject = (Statement)data.getInvocationObject();
        return StatementToSQLMappingTracer.getSQLType(tracedObject);
    }

    protected final String getMetricPath(InvocationData data) {
        Object answer = data.get(kMetricPathCacheKey);
        if (answer == null && (answer = this.createMetricPath(data)) != null) {
            data.put(kMetricPathCacheKey, answer);
        }
        return (String)answer;
    }

    protected String createMetricPath(InvocationData data) {
        Statement cfr_ignored_0 = (Statement)data.getInvocationObject();
        String method = this.getProbeIdentification().getProbeMethodName();
        String type = this.getSQLSubtype(data);
        String sql = this.getNormalizedSQL(data);
        if (type == null || sql == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(200);
        sb.append("JDBC|SQL");
        sb.append("|");
        sb.append(type);
        sb.append("|");
        sb.append(sMethodToSQLSubtypeMap.get(method));
        sb.append("|");
        sb.append(sql);
        return sb.toString();
    }
}

