/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.util.WilyStringBuilder;

public final class SQLTokenizer {
    public static final int kTokenType_None = -1;
    public static final int kTokenType_Character = 0;
    public static final int kTokenType_Word = 1;
    public static final int kTokenType_Number = 2;
    public static final int kTokenType_QuotedString = 3;
    public static final int kTokenType_EndOfString = 4;
    private static final int kTokenType_Whitespace = 5;
    private static final int kTokenType_Digit = 6;
    private static final int kTokenType_NonDigitNumber = 7;
    public static final int kTokenType_OpenParenthesis = 10;
    public static final int kTokenType_CloseParenthesis = 11;
    public static final int kTokenType_QuestionMark = 12;
    public static final int kTokenType_Comma = 13;
    public static final int kTokenType_ResourceSeparator = 14;
    public static final int kTokenType_MetricSeparator = 15;
    public static final int kTokenType_AtSign = 16;
    private static final byte[] fCharacterType = new byte[256];
    private char[] fSource;
    private int fSrcLen;
    private int fStartIndex;
    private int fEndIndex;

    static {
        int i = 97;
        while (i <= 122) {
            SQLTokenizer.fCharacterType[i] = 1;
            ++i;
        }
        i = 65;
        while (i <= 90) {
            SQLTokenizer.fCharacterType[i] = 1;
            ++i;
        }
        i = 160;
        while (i <= 255) {
            SQLTokenizer.fCharacterType[i] = 1;
            ++i;
        }
        SQLTokenizer.fCharacterType[95] = 1;
        SQLTokenizer.fCharacterType[34] = System.getProperty("SQLAgentNormalizeDoubleQuoteString") != null ? 3 : 1;
        SQLTokenizer.fCharacterType[39] = 3;
        i = 48;
        while (i <= 57) {
            SQLTokenizer.fCharacterType[i] = 6;
            ++i;
        }
        SQLTokenizer.fCharacterType[45] = 7;
        SQLTokenizer.fCharacterType[46] = 7;
        i = 0;
        while (i <= 32) {
            SQLTokenizer.fCharacterType[i] = 5;
            ++i;
        }
        SQLTokenizer.fCharacterType[40] = 10;
        SQLTokenizer.fCharacterType[41] = 11;
        SQLTokenizer.fCharacterType[63] = 12;
        SQLTokenizer.fCharacterType[44] = 13;
        SQLTokenizer.fCharacterType[64] = 16;
        SQLTokenizer.fCharacterType[124] = 14;
        SQLTokenizer.fCharacterType[58] = 15;
    }

    public SQLTokenizer(String source) {
        this.initialize(source);
    }

    public SQLTokenizer() {
    }

    public void initialize(String source) {
        this.fSrcLen = source.length();
        if (this.fSource == null || this.fSource.length < this.fSrcLen) {
            this.fSource = new char[this.fSrcLen];
        }
        source.getChars(0, this.fSrcLen, this.fSource, 0);
        this.fStartIndex = -1;
        this.fEndIndex = -1;
    }

    private char getChar(int index) {
        return this.fSource[index];
    }

    private int getType(char ch) {
        return ch < '\u0100' ? fCharacterType[ch] : 1;
    }

    private boolean isDigit(char ch) {
        return this.getType(ch) == 6;
    }

    public void appendCurrentTextToBuffer(StringBuffer buffer) {
        int i = this.fStartIndex;
        while (i <= this.fEndIndex) {
            buffer.append(Character.toUpperCase(this.getChar(i)));
            ++i;
        }
    }

    public void appendCurrentTextToBuffer(WilyStringBuilder buffer) {
        int i = this.fStartIndex;
        while (i <= this.fEndIndex) {
            buffer.append(Character.toUpperCase(this.getChar(i)));
            ++i;
        }
    }

    public char getCurrentCharacter() {
        return Character.toUpperCase(this.getChar(this.getStartIndex()));
    }

    public int getStartIndex() {
        return this.fStartIndex;
    }

    public int getEndIndex() {
        return this.fEndIndex;
    }

    public int getNextTokenType() {
        int size = this.fSrcLen;
        if (this.fEndIndex == size) {
            return 4;
        }
        this.fStartIndex = this.fEndIndex + 1;
        while (this.fStartIndex < size) {
            char ch = this.getChar(this.fStartIndex);
            int tokenType = this.getType(ch);
            switch (tokenType) {
                case 5: {
                    ++this.fStartIndex;
                    break;
                }
                case 6: 
                case 7: {
                    return this.handleNumber(ch, size);
                }
                case 3: {
                    return this.handleQuotedString(ch, size);
                }
                case 1: {
                    return this.handleWord(ch, size);
                }
                default: {
                    this.fEndIndex = this.fStartIndex;
                    return tokenType;
                }
            }
        }
        this.fEndIndex = this.fStartIndex;
        return 4;
    }

    /*
     * Unable to fully structure code
     */
    private int handleNumber(char ch, int size) {
        block13: {
            block12: {
                seenDecimalPoint = false;
                index = this.fStartIndex + 1;
                if (index == size) {
                    this.fEndIndex = this.fStartIndex;
                    if (ch == '-' || ch == '.') {
                        return 0;
                    }
                    return 2;
                }
                ch2 = this.getChar(index);
                if (ch != '-') break block12;
                if (ch2 != '.' && !this.isDigit(ch2)) {
                    this.fEndIndex = this.fStartIndex;
                    return 0;
                }
                ** GOTO lbl44
            }
            if (ch != '.') break block13;
            if (!this.isDigit(ch2)) {
                if (ch2 == '.') {
                    ch3 = this.getChar(index + 1);
                    if (ch3 == '.') {
                        this.fEndIndex = this.fStartIndex + 2;
                        return 1;
                    }
                } else if (!this.isDigit(ch2)) {
                    this.fEndIndex = this.fStartIndex;
                    return 0;
                }
            }
            seenDecimalPoint = true;
            ** GOTO lbl44
        }
        if (ch != '0' || ch2 != 'x' && ch2 != 'X') ** GOTO lbl44
        if (index + 1 == size) {
            this.fEndIndex = index - 1;
            return 2;
        }
        ch2 = this.getChar(++index);
        while (this.isDigit(ch2) || ch2 >= 'A' && ch2 <= 'F' || ch2 >= 'a' && ch2 <= 'f') {
            if (++index == size) break;
            ch2 = this.getChar(index);
        }
        this.fEndIndex = index - 1;
        return 2;
lbl-1000:
        // 1 sources

        {
            if (ch2 == '.') {
                seenDecimalPoint = true;
            }
            if (++index == size) break;
            ch2 = this.getChar(index);
lbl44:
            // 4 sources

            ** while (this.isDigit((char)ch2) || ch2 == '.' && !seenDecimalPoint)
        }
lbl45:
        // 2 sources

        this.fEndIndex = index - 1;
        return 2;
    }

    private int handleQuotedString(char ch, int size) {
        int index = this.fStartIndex + 1;
        if (index == size) {
            this.fEndIndex = this.fStartIndex;
            return 3;
        }
        char ch2 = ch;
        while (index < size) {
            ch2 = this.getChar(index);
            if (ch2 == '\\' && index < size - 1) {
                ++index;
            }
            if (ch2 == ch && index < size - 1 && (ch2 = this.getChar(++index)) != ch) break;
            ++index;
        }
        this.fEndIndex = ch2 == ch ? index : index - 1;
        return 3;
    }

    private int handleWord(char ch, int size) {
        int index = this.fStartIndex + 1;
        while (index < size) {
            switch (this.getType(this.getChar(index))) {
                case 1: 
                case 6: 
                case 7: {
                    ++index;
                    break;
                }
                default: {
                    this.fEndIndex = index - 1;
                    return 1;
                }
            }
        }
        this.fEndIndex = index - 1;
        return 1;
    }
}

