/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Statement;

public class SybaseStatementHelpTracer
extends ASingleInstanceTracerFactory {
    private IModuleFeedbackChannel feedback = this.getAgent().IAgent_getModuleFeedback();
    private static final Module module = new Module("SybaseStatementHelpTracer");

    public SybaseStatementHelpTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (data.get("SybaseConnection") == null && data.getInvocationObject() instanceof Statement) {
            Statement stmt = (Statement)data.getInvocationObject();
            Connection result = null;
            if (stmt.getClass().getName().contains("SybCallableStatement")) {
                result = this.getSybaseConnection(stmt, this.feedback, stmt.getClass().getSuperclass().getSuperclass());
            } else if (stmt.getClass().getName().contains("SybPreparedStatement")) {
                result = this.getSybaseConnection(stmt, this.feedback, stmt.getClass().getSuperclass());
            } else if (stmt.getClass().getName().contains("SybStatement")) {
                result = this.getSybaseConnection(stmt, this.feedback, stmt.getClass());
            }
            if (result != null) {
                data.put("SybaseConnection", (Object)result);
            }
        }
    }

    private Connection getSybaseConnection(Statement stmt, IModuleFeedbackChannel feedback, Class<?> sybstateclass) {
        Connection realCon = null;
        try {
            Field field = sybstateclass.getDeclaredField("_context");
            field.setAccessible(true);
            Object context = field.get(stmt);
            field = context.getClass().getField("_conn");
            field.setAccessible(true);
            Object con = field.get(context);
            if (con instanceof Connection) {
                realCon = (Connection)con;
            }
        }
        catch (IllegalArgumentException e) {
            feedback.error(module, "IllegalArgumentException: ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            feedback.error(module, "IllegalAccessException: ", (Throwable)e);
        }
        catch (SecurityException e) {
            feedback.error(module, "SecurityException: ", (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            feedback.error(module, "NoSuchFieldException: ", (Throwable)e);
        }
        return realCon;
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

