/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlparamagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.sqlparamagent.SQLAgentConfiguration;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ASingleInstanceTracerFactoryHC;
import com.wily.introscope.agent.trace.jdbc.SQLNameFormatterUtilities;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class DynamicSQLExecuteTraceWithParams
extends ASingleInstanceTracerFactoryHC {
    public final IModuleFeedbackChannel fFeedback;
    public static final Module kModule = SQLAgentConfiguration.kModule;
    protected final SQLAgentConfiguration fConfiguration;
    private static final String kSQLWithVarsParamName = "SQL With Variables";
    private final boolean isShutOff;

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kInstance;
    }

    public DynamicSQLExecuteTraceWithParams(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fConfiguration = SQLAgentConfiguration.getInstance(agent);
        this.fFeedback = this.fConfiguration.fFeedback;
        this.isShutOff = !this.fConfiguration.shouldShowSQLParams();
    }

    public boolean ITracerFactory_isShutoff() {
        return this.isShutOff;
    }

    public void ITracer_startTrace(int i, InvocationData invocationdata) {
        IStackElement previousElement = VirtualStack.peek();
        if (previousElement != null) {
            previousElement.setParameterCallback(new IInvocationDataParameterCallback(){

                public void IInvocationDataParameterCallback_addParameters(InvocationData invocationdata, Map map) {
                    block8: {
                        Object fInvObj;
                        if (DynamicSQLExecuteTraceWithParams.this.fConfiguration.shouldShowConnUrl() && (fInvObj = invocationdata.getInvocationObject()) != null && fInvObj instanceof Statement) {
                            Statement stmt = (Statement)fInvObj;
                            try {
                                String connectionURL;
                                Connection conn = stmt.getConnection();
                                if (conn != null && (connectionURL = SQLNameFormatterUtilities.getSafeCachedURL(DynamicSQLExecuteTraceWithParams.this.fFeedback, conn)) != null) {
                                    map.put("Connection URL", connectionURL);
                                }
                            }
                            catch (SQLException sQLException) {
                            }
                            catch (Throwable t) {
                                if (!DynamicSQLExecuteTraceWithParams.this.fFeedback.isDebugEnabled(kModule)) break block8;
                                DynamicSQLExecuteTraceWithParams.this.fFeedback.debug(kModule, "Problem getting db connection URL from db statement", t);
                            }
                        }
                    }
                    if (invocationdata.getInvocationParameterCount() >= 1) {
                        String sqlString = invocationdata.getInvocationParameterAsObject(0).toString();
                        if (sqlString.length() < DynamicSQLExecuteTraceWithParams.this.fConfiguration.getNormalizedMaxSQLLength()) {
                            map.put(DynamicSQLExecuteTraceWithParams.kSQLWithVarsParamName, sqlString);
                        } else {
                            map.put(DynamicSQLExecuteTraceWithParams.kSQLWithVarsParamName, String.valueOf(sqlString.substring(0, DynamicSQLExecuteTraceWithParams.this.fConfiguration.getNormalizedMaxSQLLength())) + "...");
                        }
                        map.remove("SQL:");
                    }
                }
            });
        }
    }

    public void ITracer_finishTrace(int i, InvocationData invocationdata) {
    }

    public void doOnStartTrace(int i, IStackElement istackelement, ITransactionElement itransactionelement) {
    }

    public void doOnEndTrace(int i, IStackElement istackelement, ITransactionElement itransactionelement) {
    }

    protected void doOnAbortedTransactionEndTrace(int i, IStackElement istackelement) {
    }
}

