/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.metric.calculator;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;

public class SustainabilityMetrics {
    boolean enabled;
    private IAgent agent;
    public static final String prefix = "Agent Stats|Sustainability|Calculator Service";
    public static final String calculatorSetsMetricName = "Agent Stats|Sustainability|Calculator Service:Calculator Set Count";
    public static final String calculatorsMetricName = "Agent Stats|Sustainability|Calculator Service:Total Calculator Count";
    public static final String resultsMetricName = "Agent Stats|Sustainability|Calculator Service:Total Result Metrics";
    public static final String totalTimeMetricName = "Agent Stats|Sustainability|Calculator Service:Total Time (ms)";
    public static final String calculatorsPrefix = "Agent Stats|Sustainability|Calculator Service|Calculator Sets|";
    public static final String calculatorsSuffix = ":Calculator Count";
    public static final String resultsSuffix = ":Result Metrics";
    public static final String timeSuffix = ":Time (ms)";
    private IIntegerFluctuatingCounterDataAccumulator calculatorSetsAccumulator = null;
    private IIntegerFluctuatingCounterDataAccumulator calculatorsAccumulator = null;
    private IIntegerFluctuatingCounterDataAccumulator resultsAccumulator = null;
    private IIntegerAverageDataAccumulator totalTimeAccumulator = null;

    public SustainabilityMetrics(IAgent agent) {
        this.agent = agent;
        this.calculatorSetsAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(calculatorSetsMetricName);
        this.calculatorsAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(calculatorsMetricName);
        this.resultsAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(resultsMetricName);
        this.totalTimeAccumulator = agent.IAgent_getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(totalTimeMetricName);
    }

    public void reportTotalMetrics(int totalTime, int sets, int calcs, int res) {
        this.calculatorSetsAccumulator.IIntegerCounterDataAccumulator_setValue(sets);
        this.calculatorsAccumulator.IIntegerCounterDataAccumulator_setValue(calcs);
        this.resultsAccumulator.IIntegerCounterDataAccumulator_setValue(res);
        this.totalTimeAccumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(totalTime);
    }

    public void reportCalculatorSetMetrics(String name, int time, int calculators, int results) {
        IIntegerFluctuatingCounterDataAccumulator calcsAccumulator = this.agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(calculatorsPrefix + name + calculatorsSuffix);
        calcsAccumulator.IIntegerCounterDataAccumulator_setValue(calculators);
        IIntegerFluctuatingCounterDataAccumulator resAccumulator = this.agent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(calculatorsPrefix + name + resultsSuffix);
        resAccumulator.IIntegerCounterDataAccumulator_setValue(results);
        IIntegerAverageDataAccumulator timeAccumulator = this.agent.IAgent_getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(calculatorsPrefix + name + timeSuffix);
        timeAccumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(time);
    }
}

