/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.probebuilder.intelligent.analysis;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.probebuilder.intelligent.analysis.AutoInstrumentationWorker;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class VisibilityGapProcessor
implements ITimestampedRunnable {
    private IAgent fAgent;
    Module fModule;
    private ScheduledExecutorService executor;
    private Runnable fAutoInstrumentationWorker;

    public VisibilityGapProcessor(IAgent agent, Module kmodule) {
        this.fAgent = agent;
        this.fModule = kmodule;
    }

    public void ITimestampedRunnable_execute(long nowInMillis) {
        this.fAgent.IAgent_getModuleFeedback().debug(this.fModule, "Intelligent Instrumentation Visibility Gap Processor activated");
        if (this.fAutoInstrumentationWorker == null) {
            this.startExecutor();
        }
        this.scheduleExecutor();
    }

    public void startExecutor() {
        this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setDaemon(true);
                return thread;
            }
        });
        this.fAutoInstrumentationWorker = new AutoInstrumentationWorker(this.fAgent, this.fModule, this.executor, AutoInstrumentationWorker.WorkerType.VISIBILITYGAP);
    }

    public void scheduleExecutor() {
        this.executor.schedule(this.fAutoInstrumentationWorker, 0L, TimeUnit.SECONDS);
    }
}

