/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.jms.helper;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.reflect.InvocationTargetException;

public class JMSCorrelationHelper
implements BackendProtocolsConstants {
    private static Class<?> messageClazz = null;

    public static Object findMessageParameter(InvocationData invocationData, IModuleFeedbackChannel logger, Module callerModule) {
        boolean debug = logger.isDebugEnabled(callerModule);
        Object message = null;
        if (invocationData.getInvocationParameterCount() > 0) {
            int parameterIndex = 0;
            while (parameterIndex < invocationData.getInvocationParameterCount()) {
                message = JMSCorrelationHelper.getObjectIfMessage(invocationData.getInvocationParameterAsObject(parameterIndex), logger, callerModule);
                if (message != null) {
                    if (!debug) break;
                    logger.debug(callerModule, "Parameter " + parameterIndex + " is assignable to javax.jms.Message: " + message);
                    break;
                }
                ++parameterIndex;
            }
        }
        return message;
    }

    public static Object getReturnIfMessage(InvocationData invocationData, IModuleFeedbackChannel logger, Module callerModule) {
        boolean debug = logger.isDebugEnabled(callerModule);
        Object message = JMSCorrelationHelper.getObjectIfMessage(invocationData.getInvocationReturnValueAsObject(), logger, callerModule);
        if (message != null && debug) {
            logger.debug(callerModule, "The return value is assignable to javax.jms.Message: " + message);
        }
        return message;
    }

    public static String getCorrelationId(Object message, InvocationData invocationData, IModuleFeedbackChannel logger, Module callerModule) {
        if (message != null) {
            Object property = null;
            boolean getOk = false;
            try {
                property = ReflectionUtils.invokeMethodOnObject((Object)message, (String)"getStringProperty", (Class[])new Class[]{String.class}, (Object[])new Object[]{"CA_APM_CorID"});
                getOk = true;
            }
            catch (InvocationTargetException e) {
                logger.error(callerModule, "getStringProperty() failed for message object (" + message + ") parameter to method: " + invocationData.getProbeInformation().getProbeIdentification().getProbeMethodName(), (Throwable)e);
            }
            catch (Throwable t) {
                logger.error(callerModule, "Failed reflection call for getStringProperty() on message object: " + message, t);
            }
            if (getOk && property != null) {
                return (String)property;
            }
            if (logger.isDebugEnabled(callerModule)) {
                logger.debug(callerModule, "The message object has no Correlation ID string property: " + property);
            }
        }
        return null;
    }

    private static Object getObjectIfMessage(Object toTest, IModuleFeedbackChannel logger, Module callerModule) {
        if (toTest != null) {
            if (messageClazz == null) {
                try {
                    messageClazz = Class.forName("javax.jms.Message", true, toTest.getClass().getClassLoader());
                    if (logger.isDebugEnabled(callerModule)) {
                        logger.debug(callerModule, "Message class: " + messageClazz);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (messageClazz != null && messageClazz.isAssignableFrom(toTest.getClass())) {
                return toTest;
            }
        }
        return null;
    }
}

