/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.dns;

import com.wily.introscope.agent.dns.DnsQueryProviderDefault;
import com.wily.introscope.agent.dns.IDnsRawService;
import com.wily.introscope.agent.dns.IDnsService;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.net.InetAddress;

public class DnsServiceDirect
implements IDnsService {
    public static final Module kDnaServiceDirect_LogName = new Module("DnsServiceDirect");
    private final IModuleFeedbackChannel fFeedback;
    private final IDnsRawService fDnsQueryProvider;
    private volatile boolean fActive;

    public DnsServiceDirect(IModuleFeedbackChannel feedback) {
        this.fFeedback = feedback;
        if (this.fFeedback == null) {
            throw new NullPointerException("fFeedback is null");
        }
        this.fDnsQueryProvider = new DnsQueryProviderDefault();
        this.fActive = false;
    }

    public boolean isActive() {
        return this.fActive;
    }

    @Override
    public void start() {
        this.fActive = true;
    }

    @Override
    public void stop() {
        this.fActive = false;
    }

    @Override
    public String getDnsHostNameByIPAddr(String ipAddress) {
        String dnsName = this.fDnsQueryProvider.getDnsHostNameByIPAddr(ipAddress);
        return dnsName;
    }

    @Override
    public String getDnsHostNameByIPAddr(InetAddress ipAddress) {
        String dnsName = this.fDnsQueryProvider.getDnsHostNameByIPAddr(ipAddress);
        return dnsName;
    }

    @Override
    public InetAddress getIPAddressByDnsHostName(String dnsHostName) {
        InetAddress ipAddress = this.fDnsQueryProvider.getIPAddressByDnsHostName(dnsHostName);
        return ipAddress;
    }

    @Override
    public String trimDomain(String fqdn) {
        return this.fDnsQueryProvider.trimDomain(fqdn);
    }
}

