/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.remote.arf;

import com.wily.introscope.agent.remote.arf.ArfException;
import com.wily.introscope.agent.remote.arf.ArfMap;
import com.wily.util.WilyStringBuilder;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Map;

public class ArfParser {
    static final int kFirstLetter = 97;
    static final int kLastLetter = 122;
    static final int kTableSize = 25;
    private final ArfParserEntry kRoot = new ArfParserEntry("root", null);

    public void addParserEntry(String name, TypedSetter setter) {
        this.kRoot.addParserEntry(new ArfParserEntry(name, setter));
    }

    void clearEntries() {
        this.kRoot.lookupTable = null;
    }

    private static int toIndex(int c) {
        return c - 97;
    }

    public void parseFields(Object obj, String msg) throws ArfException {
        try {
            int ptr = 0;
            if (msg.charAt(ptr++) != '{') {
                throw new ArfException("Invalid message format. Message does not start with curly bracket.");
            }
            int end = msg.length() - 1;
            ArfParserEntry e = this.kRoot;
            int depth = 0;
            boolean nameInQuotes = false;
            while (ptr <= end && msg.charAt(ptr) != '}') {
                char c;
                if ((c = msg.charAt(ptr++)) == ',' && ptr <= end) {
                    c = msg.charAt(ptr++);
                }
                if (c == '\"' && ptr <= end) {
                    nameInQuotes = true;
                    c = msg.charAt(ptr++);
                }
                if (c < 'a' || c > 'z') {
                    nameInQuotes = false;
                    throw new ArfException("Invalid field name in message at position " + ptr + ".");
                }
                int i = ArfParser.toIndex(c);
                e = e.lookupTable[i];
                if (e == null) {
                    ptr = ArfParser.skipToNextField(msg, ptr, end);
                    nameInQuotes = false;
                    e = this.kRoot;
                    depth = 0;
                    continue;
                }
                if (e.name != null) {
                    c = msg.charAt(ptr);
                    while (ptr <= end && c != ':') {
                        if (c == '\"' && nameInQuotes) {
                            c = msg.charAt(++ptr);
                            continue;
                        }
                        if (++depth >= e.name.length()) {
                            if (e.lookupTable != null) {
                                ++depth;
                                break;
                            }
                            depth = 0;
                            break;
                        }
                        if (c != e.name.charAt(depth)) {
                            depth = 0;
                            break;
                        }
                        if (++ptr > end) break;
                        c = msg.charAt(ptr);
                    }
                    if (depth > e.name.length() - 1) {
                        --depth;
                        continue;
                    }
                    if (depth < e.name.length() - 1) {
                        ptr = ArfParser.skipToNextField(msg, ptr, end);
                        nameInQuotes = false;
                    } else {
                        if (++ptr > end) break;
                        int beginValue = ptr;
                        int endValue = ptr;
                        if (msg.charAt(beginValue) == '\"') {
                            beginValue = ptr + 1;
                            ptr = ArfParser.parseStringValue(msg, ptr, end);
                            endValue = ptr++;
                        } else {
                            endValue = msg.charAt(beginValue) == '{' ? (ptr = ArfParser.parseObjectValue(msg, ptr, end)) : (ptr = ArfParser.parseIntValue(msg, ptr, end));
                        }
                        e.setter.set(obj, msg.substring(beginValue, endValue));
                    }
                    e = this.kRoot;
                    depth = 0;
                    continue;
                }
                if (e.lookupTable != null) {
                    ++depth;
                    continue;
                }
                ptr = ArfParser.skipToNextField(msg, ptr, end);
                nameInQuotes = false;
                e = this.kRoot;
                depth = 0;
            }
            if (ptr > end || msg.charAt(ptr) != '}') {
                throw new ArfException("Invalid message format. Message does not end with curly bracket.");
            }
        }
        catch (Exception e) {
            throw new ArfException("Invalid message format. Parse exception.", e);
        }
    }

    public void parseMap(Map map, String msg) throws ArfException {
        try {
            int ptr = 0;
            if (msg.charAt(ptr++) != '{') {
                throw new ArfException("Invalid message format. Message does not start with curly bracket.");
            }
            int end = msg.length() - 1;
            while (ptr <= end && msg.charAt(ptr) != '}') {
                char c = msg.charAt(ptr);
                if (c == ',' && ptr <= end) {
                    c = msg.charAt(ptr++);
                }
                int beginKey = ptr + 1;
                ptr = ArfParser.parseStringValue(msg, ptr, end);
                int endKey = ptr++;
                if (++ptr > end) break;
                int beginValue = ptr;
                int endValue = ptr;
                if (msg.charAt(beginValue) == '\"') {
                    beginValue = ptr + 1;
                    ptr = ArfParser.parseStringValue(msg, ptr, end);
                    endValue = ptr++;
                    map.put(msg.substring(beginKey, endKey), msg.substring(beginValue, endValue));
                    continue;
                }
                if (msg.charAt(beginValue) == '{') {
                    endValue = ptr = ArfParser.parseObjectValue(msg, ptr, end);
                    map.put(msg.substring(beginKey, endKey), ArfMap.parseObject(msg.substring(beginValue, endValue)));
                    continue;
                }
                endValue = ptr = ArfParser.parseIntValue(msg, ptr, end);
                map.put(msg.substring(beginKey, endKey), Long.valueOf(msg.substring(beginValue, endValue)));
            }
            if (ptr > end || msg.charAt(ptr) != '}') {
                throw new ArfException("Invalid message format. Message does not end with curly bracket.");
            }
        }
        catch (Exception e) {
            throw new ArfException("Invalid message format. Parse exception.", e);
        }
    }

    private static int parseStringValue(String msg, int ptr, int end) throws ArfException {
        ++ptr;
        while (ptr <= end && msg.charAt(ptr) != '\"') {
            if (msg.charAt(ptr) == '\\') {
                ++ptr;
            }
            ++ptr;
        }
        if (ptr > end) {
            throw new ArfException("String with no end.");
        }
        return ptr;
    }

    private static int parseObjectValue(String msg, int ptr, int end) throws ArfException {
        int objects = 0;
        ++ptr;
        while (ptr <= end && (objects != 0 || msg.charAt(ptr) != '}')) {
            if (msg.charAt(ptr) == '{') {
                ++objects;
            }
            if (msg.charAt(ptr) == '}') {
                --objects;
            }
            ++ptr;
        }
        if (ptr > end) {
            throw new ArfException("Object with no end.");
        }
        return ++ptr;
    }

    private static boolean isNumberChar(char c) {
        if (c >= '0' && c <= '9') {
            return true;
        }
        return c == '-' || c == '+' || c == 'e' || c == 'E' || c == '.';
    }

    private static int parseIntValue(String msg, int ptr, int end) throws ArfException {
        while (ptr <= end && msg.charAt(ptr) != ',' && msg.charAt(ptr) != '}') {
            if (!ArfParser.isNumberChar(msg.charAt(ptr))) {
                throw new ArfException("Invalid integer at position " + ptr + ".");
            }
            ++ptr;
        }
        return ptr;
    }

    private static int skipToNextField(String msg, int ptr, int end) throws ArfException {
        int objects = 0;
        boolean pastName = false;
        while (++ptr <= end) {
            char c = msg.charAt(ptr);
            if (c == ':') {
                pastName = true;
                continue;
            }
            if (c == '\"') {
                if (!pastName) continue;
                ArfParser.parseStringValue(msg, ptr, end);
                continue;
            }
            if (c == ',') {
                ++ptr;
                break;
            }
            if (c == '{') {
                ++objects;
                continue;
            }
            if (c != '}') continue;
            ++ptr;
            if (objects == 0) break;
            --objects;
        }
        return ptr;
    }

    public class ArfParserEntry {
        String name;
        TypedSetter setter;
        ArfParserEntry[] lookupTable;

        public ArfParserEntry() {
        }

        public ArfParserEntry(String n, TypedSetter s) {
            this.name = n;
            this.setter = s;
        }

        public void addParserEntry(ArfParserEntry e) {
            this.addParserEntry(0, e);
        }

        private void addParserEntry(int level, ArfParserEntry e) {
            if (this.lookupTable == null) {
                this.lookupTable = new ArfParserEntry[25];
                if (this != ArfParser.this.kRoot && level < this.name.length()) {
                    int i = ArfParser.toIndex(this.name.charAt(level));
                    this.lookupTable[i] = new ArfParserEntry(this.name, this.setter);
                    this.name = null;
                    this.setter = null;
                }
            }
            if (level >= e.name.length()) {
                this.name = e.name;
                this.setter = e.setter;
                return;
            }
            int index = ArfParser.toIndex(e.name.charAt(level));
            ArfParserEntry existing = this.lookupTable[index];
            if (existing == null) {
                this.lookupTable[index] = e;
            } else {
                existing.addParserEntry(level + 1, e);
            }
        }
    }

    public static interface IIntSetter
    extends ISetter {
        public void set(Object var1, int var2);
    }

    public static interface ILongSetter
    extends ISetter {
        public void set(Object var1, long var2);
    }

    public static interface IObjectSetter
    extends ISetter {
        public void set(Object var1, String var2) throws ArfException;
    }

    public static interface ISetter {
    }

    public static interface IStringSetter
    extends ISetter {
        public void set(Object var1, String var2);
    }

    public static class TypedSetter {
        int fType;
        ISetter fSetter;

        public TypedSetter(int t, ISetter s) {
            this.fType = t;
            this.fSetter = s;
        }

        void set(Object o, String valueAsString) throws ArfException {
            switch (this.fType) {
                case 0: {
                    String unescapedString;
                    WilyStringBuilder sb = new WilyStringBuilder("\"");
                    sb.append(valueAsString);
                    sb.append('\"');
                    StreamTokenizer parser = new StreamTokenizer(new StringReader(sb.toString()));
                    try {
                        parser.nextToken();
                        unescapedString = parser.ttype == 34 ? parser.sval : "ERROR!";
                    }
                    catch (IOException e) {
                        unescapedString = e.toString();
                    }
                    ((IStringSetter)this.fSetter).set(o, unescapedString);
                    break;
                }
                case 1: {
                    ((IIntSetter)this.fSetter).set(o, Integer.valueOf(valueAsString));
                    break;
                }
                case 2: {
                    ((ILongSetter)this.fSetter).set(o, Long.valueOf(valueAsString));
                    break;
                }
                case 3: {
                    ((IObjectSetter)this.fSetter).set(o, valueAsString);
                }
            }
        }
    }
}

