/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.blame.IComponentParameterCallback;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerAggregatingDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.adt.CanonicalObjectPool;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.IndexedProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BlamePointTracer
extends ASingleInstanceTracerFactory
implements ITracer {
    private String responseTimeAttrSuffix;
    private String perIntervalAttrSuffix;
    private String concurrentAttrSuffix;
    private String errorsAttrSuffix;
    private String stallsAttrSuffix;
    private String renamedResponseTimeAttrSuffix = null;
    private String renamedPerIntervalAttrSuffix = null;
    private String renamedConcurrentAttrSuffix = null;
    private String renamedErrorsAttrSuffix = null;
    private String renamedStallsAttrSuffix = null;
    private ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);
    private static final String kStallAttr = "Stall Count";
    private static final String kResponseTimeAttr = "Average Response Time (ms)";
    private static final String kPerIntervalAttr = "Responses Per Interval";
    private static final String kConcurrentAttr = "Concurrent Invocations";
    private static final String kErrorsAttr = "Errors Per Interval";
    private String cacheSuffix = null;
    private static final String kForceStandardBlameMetricsKey = "forcestandardmetrics";
    protected static final String kAppsMetricGroupPrefix = "Frontends|Apps|";
    private final boolean fShouldForceStandardBlameMetrics = this.resolveForceStandardMetricsToExistProperty();
    private final boolean fShouldManageEJBContext;
    protected MetricGroupContainerCache metricGroupContainerCache;
    private boolean optimizeMemory = false;

    public BlamePointTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.optimizeMemory = agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.reduceAgentMemoryOverhead", false);
        this.metricGroupContainerCache = new MetricGroupContainerCache();
        this.responseTimeAttrSuffix = ":Average Response Time (ms)";
        String label = this.getParameter("responsetimemetric");
        if (label != null) {
            this.renamedResponseTimeAttrSuffix = ":" + label;
            this.cacheSuffix = label;
        }
        this.perIntervalAttrSuffix = ":Responses Per Interval";
        label = this.getParameter("perintervalmetric");
        if (label != null) {
            this.renamedPerIntervalAttrSuffix = ":" + label;
            this.cacheSuffix = this.cacheSuffix == null ? label : String.valueOf(this.cacheSuffix) + ":" + label;
        }
        this.concurrentAttrSuffix = ":Concurrent Invocations";
        label = this.getParameter("concurrentmetric");
        if (label != null) {
            this.renamedConcurrentAttrSuffix = ":" + label;
            this.cacheSuffix = this.cacheSuffix == null ? label : String.valueOf(this.cacheSuffix) + ":" + label;
        }
        this.stallsAttrSuffix = ":Stall Count";
        label = this.getParameter(kStallAttr);
        if (label != null) {
            this.renamedStallsAttrSuffix = ":" + label;
            this.cacheSuffix = this.cacheSuffix == null ? label : String.valueOf(this.cacheSuffix) + ":" + label;
        }
        this.errorsAttrSuffix = ":Errors Per Interval";
        label = this.getParameter(kErrorsAttr);
        if (label != null) {
            this.renamedErrorsAttrSuffix = ":" + label;
            this.cacheSuffix = this.cacheSuffix == null ? label : String.valueOf(this.cacheSuffix) + ":" + label;
        }
        this.fShouldManageEJBContext = new Boolean(this.getParameter("manageejbcontext"));
    }

    protected final boolean resolveForceStandardMetricsToExistProperty() {
        String blameType;
        boolean shouldForce = true;
        boolean useBoundaryBlame = true;
        IndexedProperties props = this.getAgent().IAgent_getIndexedProperties();
        if (props != null && (blameType = props.getProperty("introscope.agent.blame.type")) != null) {
            useBoundaryBlame = blameType.equalsIgnoreCase("boundary");
        }
        if (!useBoundaryBlame) {
            shouldForce = this.calculateBooleanParameter(kForceStandardBlameMetricsKey, true);
        }
        return shouldForce;
    }

    protected String getComponentName(InvocationData data) {
        String result = this.formatParameterizedName(data);
        return result;
    }

    protected void addComponentToBlameStack(String component, final InvocationData data) {
        IComponentParameterCallback callback = new IComponentParameterCallback(){

            @Override
            public void IComponentParameterCallback_addParameters(Map parameters) {
                String callingMethodName;
                String isDynamic;
                String labelName;
                String tracerName;
                String groupName;
                data.IComponentParameterCallback_addParameters(parameters);
                parameters.put("Resource Name", BlamePointTracer.this.getNameParameter());
                String declaringClassName = BlamePointTracer.this.getParameter("declaringClass");
                if (declaringClassName != null && !declaringClassName.equals(parameters.get("Class"))) {
                    parameters.put("Declaring Class", declaringClassName);
                }
                if ((groupName = BlamePointTracer.this.getParameter("groupName")) != null) {
                    parameters.put("Group Name", groupName);
                }
                if ((tracerName = BlamePointTracer.this.getParameter("tracerName")) != null) {
                    parameters.put("Tracer Name", tracerName);
                }
                if ((labelName = BlamePointTracer.this.getParameter("label")) != null) {
                    parameters.put("Label", labelName);
                }
                if ((isDynamic = BlamePointTracer.this.getParameter("dynamic")) != null) {
                    parameters.put("Is dynamic", isDynamic);
                } else {
                    parameters.put("Is dynamic", "false");
                }
                String isTransitory = BlamePointTracer.this.getParameter("temporary");
                if (isTransitory != null) {
                    parameters.put("Is temporary", isTransitory);
                } else {
                    parameters.put("Is temporary", "false");
                }
                String callingClassName = BlamePointTracer.this.getParameter("callingClass");
                if (callingClassName != null) {
                    parameters.put("Calling Class", callingClassName);
                }
                if ((callingMethodName = BlamePointTracer.this.getParameter("callingMethod")) != null) {
                    parameters.put("Calling Method", callingMethodName);
                }
            }
        };
        ComponentTracer componentTracer = this.getComponentTracer();
        IBlameStack stack = data.getStack(componentTracer, true);
        componentTracer.addComponent(stack, component, callback);
    }

    protected String getFrontendNameForComponent(String rootName) {
        return kAppsMetricGroupPrefix + rootName;
    }

    protected void removeComponentFromBlameStack(String component, InvocationData data) {
        ComponentTracer componentTracer = this.getComponentTracer();
        IBlameStack stack = data.getStack(componentTracer, false);
        componentTracer.removeComponent(stack, component);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        String component = this.getComponentName(data);
        data.setComponentNameAt(component, tracerIndex);
        this.doStartBlamePointTrace(tracerIndex, data, component);
        if (this.fShouldManageEJBContext) {
            this.getComponentTracer().setInEJBTracingContext();
        }
    }

    protected void doStartBlamePointTrace(int tracerIndex, InvocationData data, String component) {
        this.notifyMetricListenerRuntimeFormat(this.getNameParameter(), component);
        this.addComponentToBlameStack(component, data);
        data.storeWallClockStartTime();
        DataAccumulatorGroup cachedGroup = this.getAccumulatorGroup(component);
        IIntegerFluctuatingCounterDataAccumulator ciCounter = cachedGroup.concurrentInvocationAccumulator;
        data.setCounterAt(ciCounter, tracerIndex);
        ciCounter.IIntegerFluctuatingCounterDataAccumulator_increment();
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        String component = data.getComponentNameAt(tracerIndex);
        this.doFinishBlamePointTrace(tracerIndex, data, component);
        if (this.fShouldManageEJBContext) {
            this.getComponentTracer().clearInEJBTracingContext();
        }
    }

    protected void doFinishBlamePointTrace(int tracerIndex, InvocationData data, String component) {
        String[] defaultBackendData;
        this.removeComponentFromBlameStack(component, data);
        ComponentTracer componentTracer = this.getComponentTracer();
        IBlameStack stack = data.getStack(componentTracer, false);
        BlameStackSnapshot snap = componentTracer.getSnapshot(stack, component);
        DataAccumulatorGroup group = this.getAccumulatorGroup(component);
        group.timerAccumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(data.getWallClockElapsedTimeAsInt(), snap);
        group.perIntervalAccumulator.ILongIntervalCounterDataAccumulator_addSingleIncident(snap);
        IIntegerFluctuatingCounterDataAccumulator ciCounter = data.getCounterAt(tracerIndex);
        if (ciCounter != null) {
            ciCounter.IIntegerFluctuatingCounterDataAccumulator_decrement();
        }
        if (this.shouldForceStandardBlameMetrics()) {
            if (group.errorsAccumulator != null) {
                group.errorsAccumulator.forceMetricToExist(snap);
            }
            if (group.stallsAccumulator != null) {
                group.stallsAccumulator.forceMetricToExist(snap);
            }
        }
        if ((defaultBackendData = componentTracer.getDefaultBackendData(stack)) != null) {
            String backendComponent = defaultBackendData[0];
            String backendName = defaultBackendData[1];
            if (backendComponent != null && backendName != null & backendComponent.equals(component)) {
                BlameStackSnapshot defBackendSnap = componentTracer.getDefaultBackendSnapshot(stack);
                DataAccumulatorGroup backendGroup = this.getDefaultBackendAccumulatorGroup(backendName);
                backendGroup.timerAccumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(data.getWallClockElapsedTimeAsInt(), defBackendSnap);
                backendGroup.perIntervalAccumulator.ILongIntervalCounterDataAccumulator_addSingleIncident(defBackendSnap);
                if (this.shouldForceStandardBlameMetrics()) {
                    if (backendGroup.errorsAccumulator != null) {
                        backendGroup.errorsAccumulator.forceMetricToExist(defBackendSnap);
                    }
                    if (backendGroup.stallsAccumulator != null) {
                        backendGroup.stallsAccumulator.forceMetricToExist(defBackendSnap);
                    }
                }
            }
        }
    }

    protected final IIntegerAggregatingDataAccumulator getTimerDataAccumulator(String component, String suffix) {
        return this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(String.valueOf(component) + suffix);
    }

    protected final IIntegerAggregatingDataAccumulator getTimerDataAccumulator(String component) {
        return this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(String.valueOf(component) + this.responseTimeAttrSuffix);
    }

    protected final ILongIntervalCounterDataAccumulator getPerIntervalDataAccumulator(String component, String suffix) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(String.valueOf(component) + suffix);
    }

    protected final ILongIntervalCounterDataAccumulator getPerIntervalDataAccumulator(String component) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(String.valueOf(component) + this.perIntervalAttrSuffix);
    }

    protected final ILongIntervalCounterDataAccumulator getErrorsDataAccumulator(String component, String suffix) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(String.valueOf(component) + suffix);
    }

    protected final ILongIntervalCounterDataAccumulator getErrorsDataAccumulator(String component) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(String.valueOf(component) + this.errorsAttrSuffix);
    }

    protected final IIntegerFluctuatingCounterDataAccumulator getConcurrentInvocationDataAccumulator(String component, String suffix) {
        return this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(component) + suffix);
    }

    protected final IIntegerFluctuatingCounterDataAccumulator getConcurrentInvocationDataAccumulator(String component) {
        return this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(component) + this.concurrentAttrSuffix);
    }

    protected final IIntegerFluctuatingCounterDataAccumulator getStallDataAccumulator(String component, String suffix) {
        return this.getDataAccumulatorFactory().safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(String.valueOf(component) + suffix);
    }

    protected final IIntegerFluctuatingCounterDataAccumulator getStallDataAccumulator(String component) {
        return this.getDataAccumulatorFactory().safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(String.valueOf(component) + this.stallsAttrSuffix);
    }

    protected DataAccumulatorGroup getAccumulatorGroup(String component) {
        DataAccumulatorGroup result = null;
        HashMap groupContainer = null;
        if (this.metricGroupContainerCache.getRemovalKey() == DataAccumulatorFactory.getRemovalMetricKey()) {
            groupContainer = this.metricGroupContainerCache.getThreadLocalMap();
            result = (DataAccumulatorGroup)groupContainer.get(component);
        } else {
            this.metricGroupContainerCache.initialize(DataAccumulatorFactory.getRemovalMetricKey());
            groupContainer = this.metricGroupContainerCache.getThreadLocalMap();
        }
        if (result == null) {
            if (this.optimizeMemory) {
                component = CanonicalObjectPool.getCanonicalString(component);
            }
            result = this.createAccumulatorGroup(component);
            groupContainer.put(component, result);
        }
        return result;
    }

    protected DataAccumulatorGroup getDefaultBackendAccumulatorGroup(String component) {
        DataAccumulatorGroup result = null;
        HashMap groupContainer = null;
        if (this.metricGroupContainerCache.getRemovalKey() == DataAccumulatorFactory.getRemovalMetricKey()) {
            groupContainer = this.metricGroupContainerCache.getThreadLocalMap();
            result = (DataAccumulatorGroup)groupContainer.get(component);
        } else {
            this.metricGroupContainerCache.initialize(DataAccumulatorFactory.getRemovalMetricKey());
            groupContainer = this.metricGroupContainerCache.getThreadLocalMap();
        }
        if (result == null) {
            if (this.optimizeMemory) {
                component = CanonicalObjectPool.getCanonicalString(component);
            }
            result = this.createDefaultBackendAccumulatorGroup(component);
            groupContainer.put(component, result);
        }
        return result;
    }

    private DataAccumulatorGroup createAccumulatorGroup(String component) {
        ArrayList<AgentMetric> metrics = new ArrayList<AgentMetric>(5);
        DataAccumulatorGroup result = new DataAccumulatorGroup();
        result.timerAccumulator = this.createTimerDataAccumulator(this.getTimerMetricName(component));
        metrics.add(result.timerAccumulator.IDataAccumulator_getMetric());
        result.perIntervalAccumulator = this.createPerIntervalDataAccumulator(this.getPerIntervalMetricName(component));
        metrics.add(result.perIntervalAccumulator.IDataAccumulator_getMetric());
        result.concurrentInvocationAccumulator = this.createConcurrentInvocationDataAccumulator(this.getConcurrentInvocationMetricName(component));
        metrics.add(result.concurrentInvocationAccumulator.IDataAccumulator_getMetric());
        if (this.shouldForceStandardBlameMetrics()) {
            result.errorsAccumulator = this.createErrorsDataAccumulator(this.getErrorsMetricName(component));
            metrics.add(result.errorsAccumulator.IDataAccumulator_getMetric());
            result.stallsAccumulator = this.createStallsDataAccumulator(this.getStallsMetricName(component));
            metrics.add(result.stallsAccumulator.IDataAccumulator_getMetric());
        }
        this.getAgent().IAgent_getMetricRecordingAdministrator().addMetricGroup(component, metrics);
        return result;
    }

    private DataAccumulatorGroup createDefaultBackendAccumulatorGroup(String component) {
        ArrayList<AgentMetric> metrics = new ArrayList<AgentMetric>(5);
        DataAccumulatorGroup result = new DataAccumulatorGroup();
        result.timerAccumulator = this.createDefaultBackendTimerDataAccumulator(this.getTimerMetricName(component));
        metrics.add(result.timerAccumulator.IDataAccumulator_getMetric());
        result.perIntervalAccumulator = this.createDefaultBackendPerIntervalDataAccumulator(this.getPerIntervalMetricName(component));
        metrics.add(result.perIntervalAccumulator.IDataAccumulator_getMetric());
        result.concurrentInvocationAccumulator = this.createDefaultBackendConcurrentInvocationDataAccumulator(this.getConcurrentInvocationMetricName(component));
        metrics.add(result.concurrentInvocationAccumulator.IDataAccumulator_getMetric());
        if (this.shouldForceStandardBlameMetrics()) {
            result.errorsAccumulator = this.createDefaultBackendErrorsDataAccumulator(this.getErrorsMetricName(component));
            metrics.add(result.errorsAccumulator.IDataAccumulator_getMetric());
            result.stallsAccumulator = this.createDefaultBackendStallsDataAccumulator(this.getStallsMetricName(component));
            metrics.add(result.stallsAccumulator.IDataAccumulator_getMetric());
        }
        this.getAgent().IAgent_getMetricRecordingAdministrator().addMetricGroup(component, metrics);
        return result;
    }

    protected String getTimerMetricName(String component) {
        if (this.renamedResponseTimeAttrSuffix == null) {
            return String.valueOf(component) + this.responseTimeAttrSuffix;
        }
        return String.valueOf(component) + this.renamedResponseTimeAttrSuffix;
    }

    protected String getPerIntervalMetricName(String component) {
        if (this.renamedPerIntervalAttrSuffix == null) {
            return String.valueOf(component) + this.perIntervalAttrSuffix;
        }
        return String.valueOf(component) + this.renamedPerIntervalAttrSuffix;
    }

    private String getConcurrentInvocationMetricName(String component) {
        if (this.renamedConcurrentAttrSuffix == null) {
            return String.valueOf(component) + this.concurrentAttrSuffix;
        }
        return String.valueOf(component) + this.renamedConcurrentAttrSuffix;
    }

    protected String getErrorsMetricName(String component) {
        if (this.renamedErrorsAttrSuffix == null) {
            return String.valueOf(component) + this.errorsAttrSuffix;
        }
        return String.valueOf(component) + this.renamedErrorsAttrSuffix;
    }

    private String getStallsMetricName(String component) {
        if (this.renamedStallsAttrSuffix == null) {
            return String.valueOf(component) + this.stallsAttrSuffix;
        }
        return String.valueOf(component) + this.renamedStallsAttrSuffix;
    }

    protected IIntegerAggregatingDataAccumulator createTimerDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(formattedMetricName);
    }

    protected ILongIntervalCounterDataAccumulator createPerIntervalDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    protected IIntegerFluctuatingCounterDataAccumulator createConcurrentInvocationDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
    }

    protected ILongIntervalCounterDataAccumulator createErrorsDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    protected IIntegerFluctuatingCounterDataAccumulator createStallsDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(formattedMetricName);
    }

    protected IIntegerAggregatingDataAccumulator createDefaultBackendTimerDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendIntegerAverageDataAccumulator(formattedMetricName);
    }

    protected ILongIntervalCounterDataAccumulator createDefaultBackendPerIntervalDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    protected IIntegerFluctuatingCounterDataAccumulator createDefaultBackendConcurrentInvocationDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
    }

    protected ILongIntervalCounterDataAccumulator createDefaultBackendErrorsDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendLongIntervalCounterDataAccumulator(formattedMetricName);
    }

    protected IIntegerFluctuatingCounterDataAccumulator createDefaultBackendStallsDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetBackendIntegerAggregatingFluctuatingCounterDataAccumulator(formattedMetricName);
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public boolean shouldForceStandardBlameMetrics() {
        return this.fShouldForceStandardBlameMetrics;
    }

    public static class DataAccumulatorGroup {
        public IIntegerAggregatingDataAccumulator timerAccumulator;
        public ILongIntervalCounterDataAccumulator perIntervalAccumulator;
        public IIntegerFluctuatingCounterDataAccumulator concurrentInvocationAccumulator;
        public ILongIntervalCounterDataAccumulator errorsAccumulator;
        public IIntegerFluctuatingCounterDataAccumulator stallsAccumulator;
    }

    protected static class MetricGroupContainerCache {
        private ThreadLocal threadLocal = new ThreadLocal(){

            protected Object initialValue() {
                return new HashMap(2);
            }
        };
        private ThreadLocal removalMetricDataLocalKey = new ThreadLocal(){

            protected Object initialValue() {
                return 0;
            }
        };

        public void initialize(int key) {
            this.threadLocal = new ThreadLocal(){

                protected Object initialValue() {
                    return new HashMap(2);
                }
            };
            Integer mainKey = key;
            this.removalMetricDataLocalKey.set(mainKey);
        }

        public int getRemovalKey() {
            Integer localKey = (Integer)this.removalMetricDataLocalKey.get();
            return localKey;
        }

        public HashMap getThreadLocalMap() {
            return (HashMap)this.threadLocal.get();
        }
    }
}

