/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.io.ASocketCounter;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.util.properties.AttributeListing;
import java.net.ServerSocket;
import java.net.Socket;

public class SocketClosePerIntervalCounter
extends ASocketCounter
implements ITracer {
    protected final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public SocketClosePerIntervalCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (data.isSocketClamped()) {
            return null;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject == null) {
            return null;
        }
        if (invocationObject instanceof Socket) {
            try {
                if (((Socket)invocationObject).isClosed()) {
                    data.skipIntelligentTracerForThisMethod();
                    return null;
                }
            }
            catch (Exception exception) {}
            return this;
        }
        if (invocationObject instanceof ServerSocket) {
            try {
                if (((ServerSocket)invocationObject).isClosed()) {
                    data.skipIntelligentTracerForThisMethod();
                    return null;
                }
            }
            catch (Exception exception) {}
            return this;
        }
        return null;
    }

    @Override
    protected final ILongIntervalCounterDataAccumulator createDataAccumulator(InvocationData data) {
        String formattedName = this.quickFormat(data, this.getMetricPosition());
        if (formattedName != null) {
            return this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(formattedName);
        }
        return null;
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode() || OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND == OverheadAdministrator.getOverheadMode()) {
            return;
        }
        if (data.isSocketRequired() && data.hasSocketResource() && !data.hasInvocationThrownException()) {
            SocketFormatMetricsCache cache = (SocketFormatMetricsCache)data.getPartialSocketFormattedName();
            if (cache.getAccumulators(4) == null) {
                this.getAccumulator(data);
            }
            cache.addToCloseCounter();
        }
    }

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }

    @Override
    protected final int getMetricPosition() {
        return 4;
    }
}

