/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.introscope.agent.trace.io.SocketFormatterCacheOnFinishTrace;
import com.wily.util.WilyStringBuilder;
import com.wily.util.properties.AttributeListing;

public class SocketFormatterCacheOnFinishTraceHighPerformance
extends SocketFormatterCacheOnFinishTrace {
    private static final String kOutputBandwidthMetric = ":Output Bandwidth (Bytes Per Second)";
    private static final String kInputBandwithMetric = ":Input Bandwidth (Bytes Per Second)";
    private static final String kConcurrentWritersMetric = ":Concurrent Writers";
    private static final String kConcurrentReadersMetric = ":Concurrent Readers";
    private static final String kBackendTracerMetric = "Backends|System {hostname} on port {port}";
    private static final String kAppMapComponent = "System {hostname} on port {port}";
    public static final char[] kHostNamePlaceHolder = "{hostname}".toCharArray();
    public static final char[] kHostIPPlaceHolder = "{hostip}".toCharArray();
    public static final char[] kPortPlaceHolder = "{port}".toCharArray();

    public SocketFormatterCacheOnFinishTraceHighPerformance(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected void completeMetricsAndAccumulators(SocketFormatMetricsCache cache) {
        String resourceName = cache.getResourceName();
        int metricPosition = 0;
        metricPosition = 5;
        String formattedMetricName = String.valueOf(resourceName) + kConcurrentReadersMetric;
        formattedMetricName = this.getFormattedString(formattedMetricName, cache.getHostName(), cache.getPort());
        cache.setAccumulators(this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName), metricPosition);
        cache.setFormattedMetrics(formattedMetricName, metricPosition);
        metricPosition = 6;
        formattedMetricName = String.valueOf(resourceName) + kConcurrentWritersMetric;
        formattedMetricName = this.getFormattedString(formattedMetricName, cache.getHostName(), cache.getPort());
        cache.setAccumulators(this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName), metricPosition);
        cache.setFormattedMetrics(formattedMetricName, metricPosition);
        metricPosition = 8;
        formattedMetricName = String.valueOf(resourceName) + kInputBandwithMetric;
        formattedMetricName = this.getFormattedString(formattedMetricName, cache.getHostName(), cache.getPort());
        cache.setAccumulators(this.getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(formattedMetricName), metricPosition);
        cache.setFormattedMetrics(formattedMetricName, metricPosition);
        metricPosition = 7;
        formattedMetricName = String.valueOf(resourceName) + kOutputBandwidthMetric;
        formattedMetricName = this.getFormattedString(formattedMetricName, cache.getHostName(), cache.getPort());
        cache.setAccumulators(this.getDataAccumulatorFactory().safeGetIntegerRateDataAccumulator(formattedMetricName), metricPosition);
        cache.setFormattedMetrics(formattedMetricName, metricPosition);
        metricPosition = 9;
        formattedMetricName = kBackendTracerMetric;
        formattedMetricName = this.getFormattedString(formattedMetricName, cache.getHostName(), cache.getPort());
        cache.setFormattedMetrics(formattedMetricName, metricPosition);
        metricPosition = 10;
        formattedMetricName = kAppMapComponent;
        formattedMetricName = this.getFormattedString(formattedMetricName, cache.getHostName(), cache.getPort());
        cache.setFormattedMetrics(formattedMetricName, metricPosition);
    }

    private String getFormattedString(String resourceName, String hostName, int port) {
        WilyStringBuilder bldr = new WilyStringBuilder();
        bldr.setString(resourceName);
        int i = bldr.indexOf(kHostNamePlaceHolder);
        if (i >= 0) {
            bldr = bldr.replace(i, i + kHostNamePlaceHolder.length, hostName);
        }
        if ((i = bldr.indexOf(kPortPlaceHolder)) >= 0) {
            bldr = bldr.replace(i, i + kPortPlaceHolder.length, Integer.toString(port));
        }
        return bldr.toString();
    }
}

