/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import java.io.File;
import java.net.URL;

public class AgentJarPathFinder {
    private static final String PATH_PREFIX_FILE = "file:/";
    private static final String PATH_SEGMENT_LIB = "lib";
    private static final String JAR_PATH_KEY = "introscope.core.agent.jar.path";
    private static IAgent agent;

    static {
        try {
            agent = AgentShim.getAgent();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
    }

    public static String calculateAgentHomePath() {
        String path = AgentJarPathFinder.findAgentJarPath();
        return path == null ? null : AgentJarPathFinder.calculateAgentHomePath(path);
    }

    static String calculateAgentHomePath(String agentJarPath) {
        if (agentJarPath == null) {
            return "";
        }
        File file = new File(agentJarPath).getParentFile();
        agentJarPath = file.getName().equals(PATH_SEGMENT_LIB) ? file.getParentFile().getAbsolutePath() : file.getAbsolutePath();
        return agentJarPath;
    }

    public static String findAgentJarPath() {
        String path;
        block4: {
            path = System.getProperty(JAR_PATH_KEY);
            if (path == null) {
                try {
                    path = AgentJarPathFinder.calculateAgentPath();
                    if (path != null && path.length() > 0) {
                        System.setProperty(JAR_PATH_KEY, path);
                    }
                }
                catch (Exception e) {
                    if (agent == null) break block4;
                    agent.IAgent_getModuleFeedback().debug(e.getMessage());
                }
            }
        }
        return path;
    }

    private static String calculateAgentPath() {
        Class<IAgent> clazz = IAgent.class;
        String classFileName = "/" + clazz.getName().replace('.', '/') + ".class";
        URL url = clazz.getResource(classFileName);
        return AgentJarPathFinder.calculateAgentPath(url);
    }

    static String calculateAgentPath(URL url) {
        if (url == null) {
            return null;
        }
        String urlPath = url.getPath();
        if (!urlPath.contains(".jar")) {
            return null;
        }
        String path = urlPath.substring(0, urlPath.indexOf("!/"));
        if (path.startsWith(PATH_PREFIX_FILE)) {
            path = path.substring(PATH_PREFIX_FILE.length() - 1);
        }
        path = path.replaceAll("%20", " ");
        return path;
    }
}

