/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.introscope.agent.util.ReflectionLookupException;
import com.wily.introscope.agent.util.ReflectionLookupStore;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.misc.Unsafe;

public class ReflectionUtils {
    public static final char[] kIllegalResourceChars = new char[]{':'};

    private ReflectionUtils() {
    }

    public static Object invokeMethodOnObject(Object object, String methodName, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = object.getClass();
        Method method = clazz.getMethod(methodName, parameterTypes);
        method.setAccessible(true);
        return method.invoke(object, args);
    }

    public static Object getFieldValueOfObject(Class clazz, Object obj, String fieldName) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field privateField = clazz.getDeclaredField(fieldName);
        privateField.setAccessible(true);
        return privateField.get(obj);
    }

    public static Object invokeMethodOnObject(Object object, String methodName, boolean publicModifier, IModuleFeedbackChannel feedback) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ReflectionLookupException {
        Method method = ReflectionLookupStore.lookupMethod(object, methodName, publicModifier, feedback);
        return method.invoke(object, new Object[0]);
    }

    public static Object invokeMethodOnObject(Object object, String methodName, String[] strings, Object[] args, boolean publicModifier, IModuleFeedbackChannel feedback) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ReflectionLookupException {
        Method method = ReflectionLookupStore.lookupMethod(object, methodName, strings, publicModifier, feedback);
        return method.invoke(object, args);
    }

    public static Object invokeMethodOnObject(Class classToInvoke, Object object, String methodName, String[] strings, Object[] args, boolean publicModifier, IModuleFeedbackChannel feedback) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, ReflectionLookupException {
        Method method = ReflectionLookupStore.lookupMethodOnClass(classToInvoke, methodName, strings, publicModifier, feedback);
        return method.invoke(object, args);
    }

    public static Object invokeMethodOnClass(ClassLoader classLoader, String className, String methodName, String[] strings, Object[] objects, boolean publicModifier, IModuleFeedbackChannel feedback) throws ReflectionLookupException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class bxAttributes = ReflectionLookupStore.lookupClass(className, classLoader);
        Method method = ReflectionLookupStore.lookupMethodOnClass(bxAttributes, methodName, strings, publicModifier, feedback);
        return method.invoke(null, objects);
    }

    public static String formatToBeResourceSafe(String value) {
        return StringUtils.replaceIllegalChars(value, kIllegalResourceChars, '_');
    }

    public static boolean checkMethodExists(Object object, String methodName, boolean publicModifier, IModuleFeedbackChannel feedback) {
        try {
            ReflectionLookupStore.lookupMethod(object, methodName, publicModifier, feedback);
            return true;
        }
        catch (ReflectionLookupException reflectionLookupException) {
            return false;
        }
    }

    public static Object getFieldValueFromClass(ClassLoader classLoader, Object callableObject, String className, String fieldName, boolean publicModifier) throws ReflectionLookupException, IllegalArgumentException, IllegalAccessException {
        Field field = ReflectionLookupStore.lookupField(classLoader, className, fieldName, publicModifier);
        if (field != null) {
            return field.get(callableObject);
        }
        return null;
    }

    public static Object getFieldValueFromClass(Object object, Class classInstance, String fieldName, boolean publicModifier) throws NoSuchFieldException, SecurityException, ReflectionLookupException, IllegalArgumentException, IllegalAccessException {
        Field field = ReflectionLookupStore.lookupField(classInstance, fieldName, publicModifier);
        if (field != null) {
            return field.get(object);
        }
        return null;
    }

    private static boolean hackFinalField(Field field) {
        field.setAccessible(true);
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (SecurityException securityException) {
            return false;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        catch (IllegalAccessException illegalAccessException) {
            return false;
        }
        return true;
    }

    static void unsafeSetFinalStaticField(Field field, Object newValue) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        unsafeField.setAccessible(true);
        Unsafe unsafe = (Unsafe)unsafeField.get(null);
        long offset = unsafe.staticFieldOffset(field);
        Object staticObject = unsafe.staticFieldBase(field);
        unsafe.getObject(staticObject, offset);
        unsafe.putObject(staticObject, offset, newValue);
    }

    static void unsafeSetFinalField(Object object, Field field, Object newValue) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
        unsafeField.setAccessible(true);
        Unsafe unsafe = (Unsafe)unsafeField.get(null);
        long offset = unsafe.objectFieldOffset(field);
        unsafe.putObject(object, offset, newValue);
    }

    public static Object getFinalStaticField(Field field) throws IllegalArgumentException, IllegalAccessException {
        field.setAccessible(true);
        return field.get(null);
    }

    public static void setFinalStaticField(Field field, Object value) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        if (ReflectionUtils.hackFinalField(field)) {
            field.set(null, value);
        } else {
            ReflectionUtils.unsafeSetFinalStaticField(field, value);
        }
    }

    public static Object getFinalField(Object object, Field field) throws IllegalArgumentException, IllegalAccessException {
        field.setAccessible(true);
        return field.get(object);
    }

    public static void setFinalField(Object object, Field field, Object value) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException {
        if (ReflectionUtils.hackFinalField(field)) {
            field.set(object, value);
        } else {
            ReflectionUtils.unsafeSetFinalField(object, field, value);
        }
    }
}

