/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.metric;

import com.wily.introscope.spec.metric.AgentNameParser;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.TrackedMetaData;
import com.wily.isengard.data.IIsengardCachedData;
import com.wily.isengard.data.IIsengardReadResolve;
import com.wily.util.adt.CanonicalObjectPool;
import com.wily.util.adt.CanonicalObjectPoolWithKey;
import com.wily.util.adt.IObjectFilter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;

public final class AgentName
extends TrackedMetaData
implements Externalizable,
IIsengardReadResolve,
IIsengardCachedData {
    public static final AgentName[] kEmptyAgentNameArray = new AgentName[0];
    private static final long serialVersionUID = -4599803499274215978L;
    private static final CanonicalObjectPoolWithKey sCache = new CanonicalObjectPoolWithKey();
    private AgentNameParser fProcessParser;
    private String fProcessURLWithoutDomain;
    private String fSocketType = "default";
    public static final String CUSTOM_METRIC_PROCESS_VIRTUAL = "Custom Metric Process (Virtual)";
    public static final String CUSTOM_METRIC_HOST_VIRTUAL = "Custom Metric Host (Virtual)";

    public AgentName() {
        super(-1);
    }

    private AgentName(String nameString) throws BadlyFormedNameException {
        this(new AgentNameParser(nameString));
    }

    private AgentName(AgentNameParser parser) {
        super(-1);
        this.fProcessParser = parser;
        this.fProcessURLWithoutDomain = this.fProcessParser.getSuffixStartingWithSegmentN(1);
    }

    public static boolean isVirtual(AgentName agentName) {
        return CUSTOM_METRIC_HOST_VIRTUAL.equals(agentName.getHost()) && CUSTOM_METRIC_PROCESS_VIRTUAL.equals(agentName.getProcess());
    }

    public String createAgentNameForMetricStore() {
        if (AgentName.isVirtual(this)) {
            return this.getProcessURL();
        }
        return "SuperDomain|" + this.getProcessURLWithoutDomain();
    }

    public String getProcessURLWithoutDomain() {
        return this.fProcessURLWithoutDomain;
    }

    public String getProcessURL() {
        String url = this.fProcessParser.getEntireString();
        url = CanonicalObjectPool.getCanonicalString(url);
        return url;
    }

    public String getSegment(int index) {
        return this.fProcessParser.getSegment(index);
    }

    public String getPrefixStringIncludingSegmentN(int n) {
        return this.fProcessParser.getPrefixIncludingSegmentN(n);
    }

    public String getDomain() {
        return this.getSegment(0);
    }

    public String getHost() {
        return this.getSegment(1);
    }

    public String getProcess() {
        return this.getSegment(2);
    }

    public String getAgentName() {
        return this.getSegment(3);
    }

    public AgentNameParser getProcessParser() {
        return this.fProcessParser;
    }

    public void setSocketType(String socketType) {
        this.fSocketType = socketType;
    }

    public String getSocketType() {
        return this.fSocketType;
    }

    public String toString() {
        return this.getProcessURL();
    }

    @Override
    public Object readResolve() throws ObjectStreamException {
        return AgentName.getFromWireData(this.fProcessParser);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.fProcessParser.smartWriteExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fProcessParser = AgentNameParser.smartReadExternalAgentNameParser(in);
    }

    private static AgentName lookupFromCacheNonSync(String url) {
        return (AgentName)sCache.getCanonicalObject(url);
    }

    private static AgentName putIntoCacheNonSync(String url, AgentName agent) {
        return (AgentName)sCache.getCanonicalObject(url, agent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AgentName getFromCache(String processURL, int persistentId) throws BadlyFormedNameException {
        if (processURL == null) {
            processURL = "";
        }
        CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = sCache;
        synchronized (canonicalObjectPoolWithKey) {
            AgentName result = AgentName.lookupFromCacheNonSync(processURL);
            if (result == null) {
                result = AgentName.putIntoCacheNonSync(processURL, new AgentName(processURL));
            }
            if (result.getPersistentID() == -1 && persistentId != -1) {
                result.setPersistentID(persistentId);
            }
            return result;
        }
    }

    private static AgentName getAgentNameFromCache(AgentNameParser processParser, int persistenId) throws BadlyFormedNameException {
        return AgentName.getFromCache(processParser.getEntireString(), persistenId);
    }

    public static AgentName getAgentName(String nameString) throws BadlyFormedNameException {
        return AgentName.getFromCache(nameString);
    }

    public static AgentName getAgentName(String nameString, int persistentId) throws BadlyFormedNameException {
        return AgentName.getFromCache(nameString, persistentId);
    }

    private static AgentName getFromCache(String nameString) throws BadlyFormedNameException {
        return AgentName.getFromCache(nameString, -1);
    }

    public static AgentName getAgentName(String domain, String host, String process, String agentName) throws BadlyFormedNameException {
        return AgentName.getAgentName(domain, host, process, agentName, -1);
    }

    public static AgentName getAgentName(String domain, String host, String process, String agentName, int persistentId) throws BadlyFormedNameException {
        String[] strings = new String[]{domain, host, process, agentName};
        AgentNameParser parser = new AgentNameParser(strings);
        return AgentName.getAgentNameFromCache(parser, persistentId);
    }

    public static AgentName getAgentName(String[] segmentArray) throws BadlyFormedNameException {
        return AgentName.getAgentName(segmentArray, 0, segmentArray.length);
    }

    public static AgentName getAgentName(String[] segmentArray, int startIndex, int count) throws BadlyFormedNameException {
        AgentNameParser parser = new AgentNameParser(segmentArray, startIndex, count);
        return AgentName.getAgentNameFromCache(parser, -1);
    }

    public static AgentName getAgentName(AgentName existingProcess) {
        return existingProcess;
    }

    private static AgentName getAgentName(AgentNameParser parser) throws BadlyFormedNameException {
        return AgentName.getAgentNameFromCache(parser, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AgentName[] getPersistentAgentNames() {
        CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = sCache;
        synchronized (canonicalObjectPoolWithKey) {
            return (AgentName[])sCache.toArray(new IObjectFilter(){

                @Override
                public boolean matches(Object o) {
                    return ((AgentName)o).isPersistent();
                }
            }, new AgentName[0]);
        }
    }

    public static int findIndexOfPivotSeparatorInFullPath(String fullPath, String trailingSeparator) {
        int separatorIndex = fullPath.indexOf("|");
        if (separatorIndex == -1) {
            return -1;
        }
        if ((separatorIndex = fullPath.indexOf("|", separatorIndex + 1)) == -1) {
            return -1;
        }
        if ((separatorIndex = fullPath.indexOf("|", separatorIndex + 1)) == -1) {
            return -1;
        }
        separatorIndex = fullPath.indexOf(trailingSeparator, separatorIndex + 1);
        return separatorIndex;
    }

    private static AgentName getFromWireData(AgentNameParser parser) throws InvalidObjectException {
        try {
            return AgentName.getAgentName(parser);
        }
        catch (BadlyFormedNameException badlyFormedNameException) {
            throw new InvalidObjectException("Bad AgentName name");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DEBUG_clearAllCachedIDs() {
        CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = sCache;
        synchronized (canonicalObjectPoolWithKey) {
            AgentName[] agents = (AgentName[])sCache.toArray(new AgentName[0]);
            int i = 0;
            while (i < agents.length) {
                agents[i].setPersistentID(-1);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void DEBUG_dumpAllCachedIDs() {
        CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = sCache;
        synchronized (canonicalObjectPoolWithKey) {
            AgentName[] agents = (AgentName[])sCache.toArray(new AgentName[0]);
            int i = 0;
            while (i < agents.length) {
                System.out.println(String.valueOf(agents[i].toString()) + " " + agents[i].getPersistentID());
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumberAgentNames() {
        CanonicalObjectPoolWithKey canonicalObjectPoolWithKey = sCache;
        synchronized (canonicalObjectPoolWithKey) {
            return sCache.size();
        }
    }

    public int getProcessURLHashCode() {
        return this.fProcessParser.hashCode();
    }
}

