/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.gatherer.ALongCombiningGatherer;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.wilyassert.Assertion;

public class LongSummingGatherer
extends ALongCombiningGatherer {
    private long fMin;
    private long fMax;
    private long fValue;

    public LongSummingGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        this.reset();
        Assertion.wilyAssert(false);
    }

    @Override
    protected void doAcceptAggregateLongTimeslicedValue(LongTimeslicedValue typedAggregate) {
        this.addToDataPointCount(typedAggregate.getDataPointCount());
        this.fValue += typedAggregate.getValue();
        this.fMin += typedAggregate.getMinimum();
        this.fMax += typedAggregate.getMaximum();
    }

    @Override
    public long getLongValue() {
        return this.fValue;
    }

    @Override
    public long getLongMinimum() {
        return this.fMin;
    }

    @Override
    public long getLongMaximum() {
        return this.fMax;
    }

    @Override
    protected void directSetLongMinimum(long minimum) {
        this.fMin = minimum;
    }

    @Override
    protected void directSetLongMaximum(long maximum) {
        this.fMax = maximum;
    }

    @Override
    protected void doResetCombiningGatherer(long when) {
        this.reset();
    }

    @Override
    protected void doReinitializeCombiningGatherer() {
        this.reset();
    }

    private void reset() {
        this.fMin = 0L;
        this.fMax = 0L;
        this.fValue = 0L;
    }

    public static IMetricDataValue aggregateByTime(IMetricDataValue pvalue1, IMetricDataValue pvalue2) {
        LongTimeslicedValue value1 = (LongTimeslicedValue)pvalue1;
        LongTimeslicedValue value2 = (LongTimeslicedValue)pvalue2;
        if (value1.dataIsAbsent() || value2.dataIsAbsent()) {
            return LongSummingGatherer.absentLong(value1, value2);
        }
        long count = value1.getDataPointCount() + value2.getDataPointCount();
        long min = value1.getMinimum() + value2.getMinimum();
        long max = value1.getMaximum() + value2.getMaximum();
        long val = value1.getValue() + value2.getValue();
        return new LongTimeslicedValue(value1.getType(), value1.getStartTimestampInMillis(), value2.getStopTimestampInMillis(), null, count, false, val, min, max);
    }
}

