/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util;

import com.wily.util.ICloseable;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class CloseableTracker {
    private final Collection<ICloseable> fCloseables = new HashSet<ICloseable>();
    private volatile boolean fTorndown;

    public CloseableTracker(IModuleFeedbackChannel feedbackChannel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCloseable(ICloseable closeable) {
        if (this.fTorndown) {
            closeable.close();
            return false;
        }
        Collection<ICloseable> collection = this.fCloseables;
        synchronized (collection) {
            this.fCloseables.add(closeable);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(Cleanup callback) {
        Collection<ICloseable> collection = this.fCloseables;
        synchronized (collection) {
            Iterator<ICloseable> it = this.fCloseables.iterator();
            while (it.hasNext()) {
                ICloseable e = it.next();
                if (!callback.clean(e)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        ICloseable[] closeableArray = null;
        Collection<ICloseable> collection = this.fCloseables;
        synchronized (collection) {
            closeableArray = this.fCloseables.toArray(new ICloseable[this.fCloseables.size()]);
            this.fCloseables.clear();
        }
        if (closeableArray != null) {
            int i = 0;
            while (i < closeableArray.length) {
                closeableArray[i].close();
                ++i;
            }
        }
    }

    public void teardown() {
        this.fTorndown = true;
        this.closeAll();
    }

    public boolean isTorndown() {
        return this.fTorndown;
    }

    public Object getSynchronizationLock() {
        return this;
    }

    public static interface Cleanup {
        public boolean clean(ICloseable var1);
    }
}

