/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.ControlledErrorLogger;
import com.ca.apm.agent.jmxclient.api.BeanConfigElement;
import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.ca.apm.agent.jmxclient.metrics.MetricValueTransformer;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.org.apache.commons.io.IOUtils;
import com.wily.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class Utils {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private static final ControlledErrorLogger ERROR_LOGGER = Configuration.createErrorLoggerInstance();
    private static final AtomicInteger clientId = new AtomicInteger(1);

    public static ThreadFactory createNewThreadFactoryInstance(String threadGroupName, String threadName) {
        return new DaemonThreadFactory(threadGroupName, threadName);
    }

    public static ThreadFactory createNewThreadFactoryInstance(String threadName) {
        return Utils.createNewThreadFactoryInstance("apm-jmx-client-pool-" + clientId.getAndIncrement(), threadName);
    }

    public static String genKey(String host, int port) {
        return String.valueOf(host) + ":" + port;
    }

    public static String getRootMetricNode(String host, int port) {
        return String.valueOf(host) + "_" + port;
    }

    public static String formatNodeName(String unformatted, String serverKey, String serverName, String host, int port) {
        return unformatted.replaceAll("\\Q{key}\\E", serverKey).replaceAll("\\Q{name}\\E", serverName).replaceAll("\\Q{host}\\E", host).replaceAll("\\Q{port}\\E", String.valueOf(port));
    }

    public static String formatNodeName(String unformatted, String serverName, String host, int port) {
        return Utils.formatNodeName(unformatted, "serverkey", serverName, host, port);
    }

    public static String formatServerProperty(String unformatted, String serverKey) {
        return unformatted.replaceAll("\\Q$key\\E", serverKey);
    }

    public static String[] findHostPort(String url) {
        Pattern p = Pattern.compile("service:jmx:rmi://(.*)/jndi/rmi://([^/]*)/(.*)", 2);
        Matcher m = p.matcher(url);
        if (m.matches()) {
            String hostPortTuple = m.group(2);
            String[] hostPort = hostPortTuple.split(":");
            if (hostPort.length == 1) {
                String[] hostPort2 = new String[]{hostPort[0], String.valueOf(1099)};
                hostPort = hostPort2;
            }
            return hostPort;
        }
        return new String[0];
    }

    private static List<ObjectName> tokenizeMbeanObjectNames(String patterns) {
        ArrayList<ObjectName> filterList = new ArrayList<ObjectName>();
        StringTokenizer itk = new StringTokenizer(patterns, ";");
        String pattern = null;
        while (itk.hasMoreTokens()) {
            pattern = itk.nextToken();
            if (pattern.length() <= 0) continue;
            try {
                filterList.add(new ObjectName(pattern));
            }
            catch (MalformedObjectNameException e) {
                LOGGER.logError("Parse Exception, Invalid filter value: " + pattern);
                LOGGER.logDebugMessage(e.getMessage(), (Throwable)e);
            }
        }
        return filterList;
    }

    private static Set<ObjectName> tokenizeMbeanObjectNames(Set<BeanConfigElement> config) {
        HashSet<ObjectName> filterList = new HashSet<ObjectName>();
        Iterator<BeanConfigElement> iter = config.iterator();
        String pattern = null;
        while (iter.hasNext()) {
            pattern = iter.next().getObjectName();
            if (pattern.length() <= 0) continue;
            try {
                filterList.add(new ObjectName(pattern));
            }
            catch (MalformedObjectNameException e) {
                LOGGER.logError("Parse Exception, Invalid filter value: " + pattern);
                LOGGER.logDebugMessage(e.getMessage(), (Throwable)e);
            }
        }
        return filterList;
    }

    public static List<String> getObjectNameRegex(String whitelist) {
        List<ObjectName> whiteListFilter = Utils.tokenizeMbeanObjectNames(whitelist);
        ArrayList<String> result = new ArrayList<String>();
        for (ObjectName oname : whiteListFilter) {
            String patternString = oname.toString();
            if (!(patternString = patternString.replaceAll("\\*", ".*")).endsWith("\\.*")) {
                patternString = String.valueOf(patternString) + ".*";
            }
            result.add(patternString);
        }
        return result;
    }

    public static QueryExp jmxQueryExp(String whiteListPatterns, String blackListPatterns, Set<ObjectName> blackListedBeans) {
        if (whiteListPatterns.isEmpty()) {
            return null;
        }
        Iterator<ObjectName> wi = Utils.tokenizeMbeanObjectNames(whiteListPatterns).iterator();
        QueryExp exp1 = null;
        if (wi.hasNext()) {
            exp1 = wi.next();
            while (wi.hasNext()) {
                exp1 = Query.or(exp1, wi.next());
            }
        }
        QueryExp exp2 = null;
        ArrayList<Collection<ObjectName>> bc = new ArrayList<Collection<ObjectName>>();
        bc.add(Utils.tokenizeMbeanObjectNames(blackListPatterns));
        bc.add(blackListedBeans);
        for (Collection collection : bc) {
            Iterator bi = collection.iterator();
            if (!bi.hasNext()) continue;
            exp2 = (QueryExp)bi.next();
            while (bi.hasNext()) {
                exp2 = Query.or(exp2, (QueryExp)bi.next());
            }
            exp2 = Query.not(exp2);
        }
        if (exp1 != null) {
            return exp2 == null ? exp1 : Query.and(exp1, exp2);
        }
        return exp2 == null ? null : exp2;
    }

    public static QueryExp jmxQueryExp(Set<BeanConfigElement> config) {
        Iterator<ObjectName> wi = Utils.tokenizeMbeanObjectNames(config).iterator();
        QueryExp exp = null;
        if (wi.hasNext()) {
            exp = wi.next();
            while (wi.hasNext()) {
                exp = Query.or(exp, wi.next());
            }
        }
        return exp;
    }

    public static boolean isNullOrEmpty(String v) {
        return v == null || v.isEmpty();
    }

    public static boolean isNonEmpty(String v) {
        return !Utils.isNullOrEmpty(v);
    }

    public static boolean isNonEmpty(String ... vals) {
        String[] stringArray = vals;
        int n = vals.length;
        int n2 = 0;
        while (n2 < n) {
            String v = stringArray[n2];
            if (Utils.isNullOrEmpty(v)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static <T> Set<T>[] getDifferenceAsPairOfSets(Set<T> nodes1, Set<T> nodes2) {
        if (nodes1.equals(nodes2)) {
            Set[] pair = new Set[]{Collections.emptySet(), Collections.emptySet()};
            return pair;
        }
        HashSet<T> n1 = new HashSet<T>(nodes1);
        HashSet<T> n2 = new HashSet<T>(nodes2);
        n1.removeAll(nodes2);
        n2.removeAll(nodes1);
        Set[] pair = new Set[]{n1, n2};
        return pair;
    }

    public static <T> Set<T>[] getDifferenceAsDisjointSets(Set<T> nodes1, Set<T> nodes2) {
        if (nodes1.equals(nodes2)) {
            Set[] triplet = new Set[]{new HashSet<T>(nodes1), Collections.emptySet(), Collections.emptySet()};
            return triplet;
        }
        HashSet<T> common = new HashSet<T>();
        HashSet<T> removed = new HashSet<T>();
        HashSet<T> neww = new HashSet<T>(nodes2);
        Set<T> n1 = nodes1;
        Set<T> n2 = nodes2;
        if (nodes2.size() < nodes1.size()) {
            n1 = nodes2;
            n2 = nodes1;
        }
        for (T n : n1) {
            if (n2.contains(n)) {
                common.add(n);
                continue;
            }
            removed.add(n);
        }
        neww.removeAll(common);
        Set[] triplet = new Set[]{common, removed, neww};
        return triplet;
    }

    private static int getRequiredPoolSize(Set<JmxNodeInfo> nodes) {
        int f = Configuration.getThreadPoolSizeFactor();
        if (f <= 0) {
            f = 1;
        }
        int n = nodes.size();
        int q = n / f;
        int r = n % f;
        return r == 0 ? q : q + 1;
    }

    public static String reverseDnsLookup(String ipAddr) {
        String host = null;
        try {
            host = Configuration.getAgent().IAgent_getDnsService().getDnsHostNameByIPAddr(ipAddr);
        }
        catch (Exception e) {
            ERROR_LOGGER.logError("Exception in reverseDnsLookup", e);
        }
        return host;
    }

    public static String getIpAddr(String host) {
        InetAddress ipaddr = Utils.getInetAddress(host);
        return ipaddr != null ? ipaddr.getHostAddress() : "";
    }

    private static InetAddress getInetAddress(String host) {
        try {
            return Utils.getAgent().IAgent_getDnsService().getIPAddressByDnsHostName(host);
        }
        catch (Exception e) {
            ERROR_LOGGER.logError("Exception while fetching ipaddress", e);
            return null;
        }
    }

    public static String getValidHostName(String host) {
        if (!Utils.getAgent().IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.remotejmx.hostName.update.enabled", false)) {
            return host;
        }
        boolean allowFQName = Utils.getAgent().IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.remotejmx.hostName.update.fqdn.enabled", false);
        return new HostNameLookupHelper(host, allowFQName).getValidHostName();
    }

    private static String getSimpleName(String hostName) {
        int i = hostName.indexOf(".");
        if (i != -1) {
            return hostName.substring(0, i);
        }
        return hostName;
    }

    public static String loadJsonAsString(String fileName) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream stream = Utils.class.getResourceAsStream(fileName);){
                return IOUtils.toString((InputStream)stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.logDebugMessage(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String loadJsonAsString(File file) {
        try {
            StringBuilder sb = new StringBuilder();
            BufferedReader in = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().startsWith("#")) continue;
                sb.append(line);
            }
            in.close();
            return sb.toString();
        }
        catch (IOException e) {
            LOGGER.logDebugMessage(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String escapeSpecialChars(String metricName) {
        return metricName.replace("|", "\\|").replace(":", "\\:");
    }

    public static IAgent getAgent() {
        return Configuration.getAgent();
    }

    public static List<String> convert(String s) {
        ArrayList<String> convertedValue = new ArrayList<String>();
        String[] rawValues = StringUtils.parseAndTrimList((String)s, (String)",");
        if (rawValues != null) {
            int i = 0;
            while (i < rawValues.length) {
                String rv = rawValues[i];
                if (!StringUtils.isEmpty((String)rv)) {
                    convertedValue.add(rv.trim());
                }
                ++i;
            }
        }
        return convertedValue;
    }

    public static MetricValueTransformer<?, ?> getTransformerInstance(String path) {
        return path.endsWith(".js") ? Utils.getTransformerInstanceJS(path) : Utils.getTransformerInstanceJava(path);
    }

    private static MetricValueTransformer<?, ?> getTransformerInstanceJava(String fqClassName) {
        MetricValueTransformer tf = null;
        try {
            LOGGER.logDebugMessage("Creating transformer instance for class:" + fqClassName);
            Class<?> klass = Class.forName(fqClassName);
            Object o = klass.newInstance();
            if (MetricValueTransformer.class.isInstance(o)) {
                tf = (MetricValueTransformer)o;
            } else {
                LOGGER.logError("Invalid transformer class: " + klass.getName());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOGGER.logException("Error while creating transformer instance for class:" + fqClassName, (Exception)e);
        }
        return tf;
    }

    private static MetricValueTransformer<?, ?> getTransformerInstanceJS(String path) {
        MetricValueTransformer tf = null;
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine engine = mgr.getEngineByName("nashorn");
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (FileReader reader = new FileReader(path);){
                engine.eval(reader);
                Invocable inv = (Invocable)((Object)engine);
                tf = inv.getInterface(MetricValueTransformer.class);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ScriptException e) {
            LOGGER.logException("Error while creating transformer instance from file:" + path, e);
        }
        return tf;
    }

    public static void filterBeans(String attributeName, String attributeValue, Set<ObjectName> beans, String domainName) {
        if (attributeValue.equals("*")) {
            attributeValue = ".*";
        }
        Pattern attributePattern = Pattern.compile(attributeValue);
        Iterator<ObjectName> it = beans.iterator();
        while (it.hasNext()) {
            ObjectName bean = it.next();
            String beanDomainName = Utils.getDomainName(bean.toString());
            if (!domainName.equals(beanDomainName)) {
                it.remove();
                continue;
            }
            Map<String, String> beanSplit = Utils.getAttributeMap(bean.toString());
            String attrVal = beanSplit.get(attributeName);
            if (attrVal == null) {
                LOGGER.logDebugMessage(String.format("Lookup attribute key(%s) is not found in the loaded bean(%s) attributes list:%s", attributeName, beanDomainName, beanSplit));
                it.remove();
                continue;
            }
            Matcher m = attributePattern.matcher(attrVal);
            if (m.find()) continue;
            it.remove();
        }
    }

    public static Map<String, String> getAttributeMap(String queryString) {
        LinkedHashMap<String, String> attributesMap = new LinkedHashMap<String, String>();
        if (queryString.contains(":")) {
            List<String> colonSeparated = Arrays.asList(queryString.split(":"));
            String[] stringArray = colonSeparated.get(1).split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attribute = stringArray[n2];
                if (attribute.contains("=")) {
                    String[] attrSplit = attribute.split("=");
                    attributesMap.put(attrSplit[0], attrSplit[1]);
                }
                ++n2;
            }
        }
        return attributesMap;
    }

    public static boolean matchPattern(Pattern pattern, String query) {
        Matcher m = pattern.matcher(query);
        return m.find();
    }

    public static String getDomainName(String queryStr) {
        if (queryStr.contains(":")) {
            return Arrays.asList(queryStr.split(":")).get(0);
        }
        LOGGER.logError("Query: " + queryStr + " doesn't seem to follow proper format. : is expected");
        return "";
    }

    public static Set<BeanConfigElement> handleRegexInYML(Set<BeanConfigElement> beanConfigElements) {
        HashSet<BeanConfigElement> uniqueConfigElements = new HashSet<BeanConfigElement>();
        for (BeanConfigElement element : beanConfigElements) {
            String objName = element.getObjectName();
            if (objName.contains("|")) {
                try {
                    Set<String> objNames = Utils.getUniqueObjNames(objName);
                    for (String name : objNames) {
                        BeanConfigElement newElement = (BeanConfigElement)element.clone();
                        newElement.setObjectName(name);
                        uniqueConfigElements.add(newElement);
                    }
                }
                catch (Exception e) {
                    LOGGER.logError(e.getMessage());
                }
                continue;
            }
            uniqueConfigElements.add(element);
        }
        return uniqueConfigElements;
    }

    private static Set<String> getUniqueObjNames(String queryStr) {
        int totalPermutations = 1;
        HashSet<String> objNames = new HashSet<String>();
        Map<String, String> attributeMap = Utils.getAttributeMap(queryStr);
        HashMap<String, List<String>> attributeValues = new HashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : attributeMap.entrySet()) {
            List<String> individualValues = Arrays.asList(entry.getValue().split("\\|"));
            totalPermutations *= individualValues.size();
            attributeValues.put(entry.getKey(), individualValues);
        }
        int itr = 0;
        while (itr < totalPermutations) {
            StringBuilder modifiedQueryStr = new StringBuilder();
            modifiedQueryStr.append(Utils.getDomainName(queryStr)).append(":");
            for (Map.Entry<String, String> entry : attributeMap.entrySet()) {
                modifiedQueryStr.append(entry.getKey()).append("=");
                List possibleAttributeValues = (List)attributeValues.get(entry.getKey());
                modifiedQueryStr.append((String)possibleAttributeValues.get(itr % possibleAttributeValues.size()));
                modifiedQueryStr.append(",");
            }
            if (modifiedQueryStr.length() > 0 && modifiedQueryStr.charAt(modifiedQueryStr.length() - 1) == ',') {
                modifiedQueryStr.deleteCharAt(modifiedQueryStr.length() - 1);
            }
            objNames.add(modifiedQueryStr.toString());
            ++itr;
        }
        return objNames;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final ThreadGroup threadGroup;
        private final String namePrefix;

        DaemonThreadFactory(String threadGroupName, String threadName) {
            this.threadGroup = new ThreadGroup(threadGroupName);
            this.namePrefix = threadGroupName.isEmpty() ? threadName : String.format("%s:%s", threadGroupName, threadName);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.threadGroup, r, String.valueOf(this.namePrefix) + "-" + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }
    }

    public static class HostNameLookupHelper {
        private String host;
        private boolean allowFQName;

        public HostNameLookupHelper(String host, boolean fqdn) {
            this.host = host;
            this.allowFQName = fqdn;
        }

        public HostNameLookupHelper(String host) {
            this(host, false);
        }

        public String getValidHostName() {
            InetAddress address = Utils.getInetAddress(this.host);
            if (address == null) {
                return this.host;
            }
            String hostName = this.host;
            String hostIP = address.getHostAddress();
            try {
                if (address.isLoopbackAddress()) {
                    address = InetAddress.getLocalHost();
                    hostIP = address.getHostAddress();
                    hostName = address.getHostName();
                }
                if (hostName.equalsIgnoreCase(hostIP)) {
                    hostName = address.getHostName();
                    if (!hostName.equalsIgnoreCase(hostIP)) {
                        hostName = this.getFQHostNameIfConfigured(hostName, address);
                    }
                } else {
                    hostName = this.getFQHostNameIfConfigured(hostName, address);
                }
            }
            catch (UnknownHostException e) {
                LOGGER.logDebugMessage(e.getMessage(), (Throwable)e);
            }
            return hostName;
        }

        private String getFQHostNameIfConfigured(String hostName, InetAddress address) {
            return this.allowFQName ? address.getCanonicalHostName() : Utils.getSimpleName(hostName);
        }
    }
}

