/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.springboot.actuator;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.BeanConfiguration;
import com.ca.apm.agent.jmxclient.metrics.MetricValueTransformer;
import com.ca.apm.agent.jmxclient.springboot.actuator.MetricValue;
import com.ca.apm.agent.jmxclient.springboot.actuator.StatisticValue;
import com.google.gson.Gson;
import com.wily.introscope.agent.trace.intelligent.Logger;
import java.util.List;
import java.util.Map;

public class MetricsBeanValueTransformer<T>
implements MetricValueTransformer<T, Number> {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private String statisticKey = null;
    private int latestTagContentLength = -1;
    private BeanConfiguration config;

    public MetricsBeanValueTransformer(String statistic, int tagContentLength, BeanConfiguration config) {
        this.statisticKey = statistic;
        this.latestTagContentLength = tagContentLength;
        this.config = config;
    }

    @Override
    public Number transform(T value, Map info) {
        Number result = null;
        try {
            String str = value.toString();
            int tagContentLength = str.substring(str.indexOf("availableTags")).length();
            if (this.latestTagContentLength > -1 && tagContentLength > this.latestTagContentLength) {
                this.latestTagContentLength = tagContentLength;
                this.config.beanCount.set(0);
            }
            MetricValue mResult = (MetricValue)new Gson().fromJson(value.toString(), MetricValue.class);
            for (StatisticValue statisticValue : mResult.getMeasurements()) {
                if (this.statisticKey != null && !this.statisticKey.equals(statisticValue.getStatistic())) continue;
                result = statisticValue.getValue();
                break;
            }
        }
        catch (Exception exception) {}
        return result == null ? (Number)this.retrieveValueFromRawData(value) : (Number)result;
    }

    protected Number retrieveValueFromRawData(T value) {
        Object measurements;
        if (value instanceof Map && (measurements = ((Map)value).get("measurements")) instanceof List && !((List)measurements).isEmpty()) {
            for (Object measurement : (List)measurements) {
                Object result;
                Object statistic;
                if (!(measurement instanceof Map) || !((statistic = ((Map)measurement).get("statistic")) instanceof String) || this.statisticKey != null && !this.statisticKey.equals((String)statistic) || !((result = ((Map)measurement).get("value")) instanceof Number)) continue;
                return (Number)result;
            }
        }
        return null;
    }

    @Override
    public boolean validate(Object value) {
        return value instanceof Map && value.toString().contains("value");
    }

    public String getStatisticType() {
        return this.statisticKey;
    }

    public void setStatisticType(String statisticType) {
        this.statisticKey = statisticType;
    }
}

