/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.classmatcher.IClassMatcher;
import com.wily.diagnos.cmp.methodmatcher.IMethodMatcher;
import com.wily.util.HashCodeUtils;
import com.wily.util.adt.trie.PackagePrefixMatchingTrie;
import com.wily.util.adt.trie.Trie;
import com.wily.util.classfile.ClassFileUtilities;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.NameUtilities;
import com.wily.util.classfile.java.ClassName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ClassModificationFilter {
    private final List fSkipContainerPrefixes;
    private final Set fSkipContainers;
    private final PackagePrefixMatchingTrie fDoNotSkipPackagePrefixes;
    private final List fSkipPackagePrefixes;
    private final Set fSkipPackages;
    private final Set fSkipClasses;
    private final Map fSkipMethodsForClasses;
    private final Map fSkipMethodsForClassesExceptions;
    private final List fSkipMatchingClasses;
    private Set fSkipMethods;
    private final List fForceProcessClassesPostmain;
    private final List fForceProcessClassesPremain;
    private final List fSkipDynamicInstrumentationContainerPrefixes;
    private final Set fSkipDynamicInstrumentationContainers;
    private final List fSkipDynamicInstrumentationPackagePrefixes;
    private final Set fSkipDynamicInstrumentationPackages;
    private final Set fSkipDynamicInstrumentationClasses;
    private final List fSkipIntelligentInstrumentationPackagePrefixes;
    private final List fIncludeIntelligentInstrumentationPackagePrefixes;

    public ClassModificationFilter(List skipClasses, PackagePrefixMatchingTrie doNotSkipPackagePrefixes, List skipPackages, List skipPackagePrefixes, List skipContainers, List skipContainerPrefixes, List skipMethods, Map skipMethodsForClasses, Map skipMethodsForClassesExceptions, List skipMatchingClasses, List forceProcessClassesPostmain, List forceProcessClassesPremain, List skipDynamicInstrumentationContainerPrefixes, List skipDynamicInstrumentationContainers, List skipDynamicInstrumentationPackagePrefixes, List skipDynamicInstrumentationPackages, List skipDynamicInstrumentationClasses, List skipIntelligentInstrumentationPackagePrefixes, List includeIntelligentInstrumentationPackagePrefixes) {
        this.fSkipContainerPrefixes = new ArrayList(skipContainerPrefixes);
        this.fSkipContainers = new HashSet(skipContainers);
        this.fDoNotSkipPackagePrefixes = new PackagePrefixMatchingTrie();
        this.fDoNotSkipPackagePrefixes.merge((Trie)doNotSkipPackagePrefixes);
        this.fSkipPackagePrefixes = new ArrayList(skipPackagePrefixes);
        this.fSkipPackages = new HashSet(skipPackages);
        this.fSkipClasses = new HashSet(skipClasses);
        this.fSkipMethods = new HashSet(skipMethods);
        this.fSkipMethodsForClasses = new HashMap(skipMethodsForClasses);
        this.fSkipMethodsForClassesExceptions = new HashMap(skipMethodsForClassesExceptions);
        this.fSkipMatchingClasses = new ArrayList(skipMatchingClasses);
        this.fForceProcessClassesPostmain = new ArrayList(forceProcessClassesPostmain);
        this.fForceProcessClassesPremain = new ArrayList(forceProcessClassesPremain);
        this.fSkipDynamicInstrumentationContainerPrefixes = new ArrayList(skipDynamicInstrumentationContainerPrefixes);
        this.fSkipDynamicInstrumentationContainers = new HashSet(skipDynamicInstrumentationContainers);
        this.fSkipDynamicInstrumentationPackagePrefixes = new ArrayList(skipDynamicInstrumentationPackagePrefixes);
        this.fSkipDynamicInstrumentationPackages = new HashSet(skipDynamicInstrumentationPackages);
        this.fSkipDynamicInstrumentationClasses = new HashSet(skipDynamicInstrumentationClasses);
        this.fSkipIntelligentInstrumentationPackagePrefixes = new ArrayList(skipIntelligentInstrumentationPackagePrefixes);
        this.fIncludeIntelligentInstrumentationPackagePrefixes = new ArrayList(includeIntelligentInstrumentationPackagePrefixes);
    }

    public List getSkipIntelligentInstrumentationPackagePrefixes() {
        return this.fSkipIntelligentInstrumentationPackagePrefixes;
    }

    public List getIncludeIntelligentInstrumentationPackagePrefixes() {
        return this.fIncludeIntelligentInstrumentationPackagePrefixes;
    }

    public List getSkipDynamicInstrumentationContainerPrefixes() {
        return this.fSkipDynamicInstrumentationContainerPrefixes;
    }

    public Set getSkipDynamicInstrumentationContainers() {
        return this.fSkipDynamicInstrumentationContainers;
    }

    public List getSkipDynamicInstrumentationPackagePrefixes() {
        return this.fSkipDynamicInstrumentationPackagePrefixes;
    }

    public Set getSkipDynamicInstrumentationPackages() {
        return this.fSkipDynamicInstrumentationPackages;
    }

    public Set getSkipDynamicInstrumentationClasses() {
        return this.fSkipDynamicInstrumentationClasses;
    }

    public Set getSkipClasses() {
        return this.fSkipClasses;
    }

    public Set getSkipPackages() {
        return this.fSkipPackages;
    }

    public PackagePrefixMatchingTrie getDoNotSkipPackagePrefixes() {
        return this.fDoNotSkipPackagePrefixes;
    }

    public List getSkipPackagePrefixes() {
        return this.fSkipPackagePrefixes;
    }

    public Set getSkipContainers() {
        return this.fSkipContainers;
    }

    public List getSkipContainerPrefixes() {
        return this.fSkipContainerPrefixes;
    }

    public Map getSkipMethodsForClasses() {
        return this.fSkipMethodsForClasses;
    }

    public Map getSkipMethodsForClassesExceptions() {
        return this.fSkipMethodsForClassesExceptions;
    }

    public Set getSkipMethods() {
        return this.fSkipMethods;
    }

    public List getSkipMatchingClasses() {
        return this.fSkipMatchingClasses;
    }

    List getForceProcessClassesPostmain() {
        return this.fForceProcessClassesPostmain;
    }

    List getForceProcessClassesPremain() {
        return this.fForceProcessClassesPremain;
    }

    public List getAllInstrumentableBootstrapClasses() {
        ArrayList result = new ArrayList();
        result.addAll(this.fForceProcessClassesPostmain);
        result.addAll(this.fForceProcessClassesPremain);
        return result;
    }

    public List getInstrumentableBootstrapClassesPostmain() {
        return this.fForceProcessClassesPostmain;
    }

    public List getInstrumentableBootstrapClassesPremain() {
        return this.fForceProcessClassesPremain;
    }

    public boolean isInstrumentableBootstrapClass(IModeledClass c) {
        String name = c.getClassName().getContainerAndPackageAndNameString();
        return this.fForceProcessClassesPremain.contains(name) || this.fForceProcessClassesPostmain.contains(name);
    }

    private String normalize(String className) {
        return NameUtilities.normalizeClassName((String)className);
    }

    public boolean shouldInstrument(String className) {
        String normalizedString = this.normalize(className);
        boolean result = this.fForceProcessClassesPostmain.contains(normalizedString) || this.fForceProcessClassesPremain.contains(normalizedString);
        return result;
    }

    public boolean shouldSkip(IModeledClass theClass) {
        if (this.shouldNotSkip(theClass.getClassName().getPackageAndNameString())) {
            return false;
        }
        int i = 0;
        while (i < this.fSkipMatchingClasses.size()) {
            IClassMatcher matcher = (IClassMatcher)this.fSkipMatchingClasses.get(i);
            if (matcher.IClassMatcher_matches(theClass)) {
                return true;
            }
            ++i;
        }
        String className = theClass.getClassName().getContainerAndPackageAndNameString();
        return this.shouldSkip(className);
    }

    public boolean shouldNotSkip(String className) {
        if (this.fDoNotSkipPackagePrefixes.matchesStoredPackagePrefixes(className)) {
            return true;
        }
        try {
            if (!this.fSkipMethodsForClassesExceptions.isEmpty() && this.fSkipMethodsForClassesExceptions.containsKey(ClassName.getClassName((String)className))) {
                return true;
            }
        }
        catch (InvalidClassNameException invalidClassNameException) {}
        return false;
    }

    public boolean shouldSkip(String className) {
        String classPackage;
        int packageIndex;
        String prefix;
        if (this.shouldNotSkip(className = this.normalize(className))) {
            return false;
        }
        if (this.fSkipClasses.contains(className) || this.fSkipClasses.contains(ClassFileUtilities.filterForClasses((String)className))) {
            return true;
        }
        int containerIndex = NameUtilities.findContainerEndIndex((String)className);
        if (containerIndex > 0) {
            String containerName = className.substring(0, containerIndex + 1);
            if (this.fSkipContainers.contains(containerName)) {
                return true;
            }
            int i = 0;
            while (i < this.fSkipContainerPrefixes.size()) {
                prefix = (String)this.fSkipContainerPrefixes.get(i);
                if (containerName.startsWith(prefix)) {
                    return true;
                }
                ++i;
            }
        }
        if ((packageIndex = NameUtilities.findPackageEndIndex((String)className)) > 0 && (this.fSkipPackages.contains(classPackage = className.substring(0, packageIndex)) || this.fSkipPackages.contains(ClassFileUtilities.filterForClasses((String)classPackage)))) {
            return true;
        }
        int i = 0;
        while (i < this.fSkipPackagePrefixes.size()) {
            prefix = (String)this.fSkipPackagePrefixes.get(i);
            if (className.startsWith(prefix)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean shouldSkipDynamicInstrumentation(String className) {
        String classPackage;
        int packageIndex;
        String prefix;
        if (this.fSkipDynamicInstrumentationClasses.contains(className = this.normalize(className)) || this.fSkipDynamicInstrumentationClasses.contains(ClassFileUtilities.filterForClasses((String)className))) {
            return true;
        }
        int containerIndex = NameUtilities.findContainerEndIndex((String)className);
        if (containerIndex > 0) {
            String containerName = className.substring(0, containerIndex + 1);
            if (this.fSkipDynamicInstrumentationContainers.contains(containerName)) {
                return true;
            }
            int i = 0;
            while (i < this.fSkipDynamicInstrumentationContainerPrefixes.size()) {
                prefix = (String)this.fSkipDynamicInstrumentationContainerPrefixes.get(i);
                if (containerName.startsWith(prefix)) {
                    return true;
                }
                ++i;
            }
        }
        if ((packageIndex = NameUtilities.findPackageEndIndex((String)className)) > 0 && (this.fSkipDynamicInstrumentationPackages.contains(classPackage = className.substring(0, packageIndex)) || this.fSkipDynamicInstrumentationPackages.contains(ClassFileUtilities.filterForClasses((String)classPackage)))) {
            return true;
        }
        int i = 0;
        while (i < this.fSkipDynamicInstrumentationPackagePrefixes.size()) {
            prefix = (String)this.fSkipDynamicInstrumentationPackagePrefixes.get(i);
            if (className.startsWith(prefix)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean shouldSkipIntelligentInstrumentation(String className) {
        String prefix;
        className = this.normalize(className);
        int i = 0;
        while (i < this.fIncludeIntelligentInstrumentationPackagePrefixes.size()) {
            prefix = (String)this.fIncludeIntelligentInstrumentationPackagePrefixes.get(i);
            if (className.startsWith(prefix)) {
                return false;
            }
            ++i;
        }
        int j = 0;
        while (j < this.fSkipIntelligentInstrumentationPackagePrefixes.size()) {
            prefix = (String)this.fSkipIntelligentInstrumentationPackagePrefixes.get(j);
            if (className.startsWith(prefix)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public boolean shouldSkip(IModeledClass theClass, IModeledMethod theMethod) {
        return this.shouldSkip(theClass, theMethod, false);
    }

    private static boolean findInClassMethodSet(Map classMethodSet, IClassName theClass, IModeledMethod theMethod) {
        for (Map.Entry entry : classMethodSet.entrySet()) {
            IClassName currentName = (IClassName)entry.getKey();
            Set methodSet = (Set)entry.getValue();
            if (!ClassFileUtilities.looselyMatches((IClassName)currentName, (IClassName)theClass) || methodSet == null) continue;
            for (IMethodMatcher matcher : methodSet) {
                if (!matcher.IMethodMatcher_matches(theMethod)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldSkip(IModeledClass theClass, IModeledMethod theMethod, boolean checkClass) {
        IClassName theClassName = theClass.getClassName();
        if (ClassModificationFilter.findInClassMethodSet(this.fSkipMethodsForClassesExceptions, theClassName, theMethod)) {
            return false;
        }
        if (checkClass && this.shouldSkip(theClass)) {
            return true;
        }
        return ClassModificationFilter.findInClassMethodSet(this.fSkipMethodsForClasses, theClassName, theMethod);
    }

    public boolean shouldSkip(IModeledMethod theMethod) {
        boolean result = false;
        Iterator it = this.fSkipMethods.iterator();
        while (it.hasNext() && !result) {
            IMethodMatcher matcher = (IMethodMatcher)it.next();
            if (!matcher.IMethodMatcher_matches(theMethod)) continue;
            result = true;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassModificationFilter) {
            ClassModificationFilter cmf = (ClassModificationFilter)obj;
            return this.fSkipClasses.equals(cmf.fSkipClasses) && this.fDoNotSkipPackagePrefixes.equals((Object)cmf.fDoNotSkipPackagePrefixes) && this.fSkipPackages.equals(cmf.fSkipPackages) && this.fSkipPackagePrefixes.equals(cmf.fSkipPackagePrefixes) && this.fSkipContainers.equals(cmf.fSkipContainers) && this.fSkipContainerPrefixes.equals(cmf.fSkipContainerPrefixes) && this.fSkipMethods.equals(cmf.fSkipMethods) && this.fSkipMethodsForClasses.equals(cmf.fSkipMethodsForClasses) && this.fSkipMatchingClasses.equals(cmf.fSkipMatchingClasses) && this.fForceProcessClassesPostmain.equals(cmf.fSkipMatchingClasses);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipClasses.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fDoNotSkipPackagePrefixes.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipPackages.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipPackagePrefixes.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipContainers.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipContainerPrefixes.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipMethods.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipMethodsForClasses.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fSkipMatchingClasses.hashCode());
        result = HashCodeUtils.accumulateHashCode((int)result, (int)this.fForceProcessClassesPostmain.hashCode());
        return result;
    }
}

