/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.DirectivesDirectoryException;
import com.wily.diagnos.cmp.directives.DirectivesException;
import com.wily.diagnos.cmp.directives.DirectivesFile;
import com.wily.diagnos.cmp.directives.DirectivesListFile;
import com.wily.diagnos.cmp.directives.IDirectiveCollection;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.parser.DGParserException;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.personality.ICompilerPersonality;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.resource.IResourceReader;
import com.wily.util.resource.InvalidResourceException;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.validate.ValidationException;
import com.wily.wilyassert.Assertion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class DirectivesFileList
extends ArrayList {
    private static final String kDoesNotExistError = "The specified directory does not exist.";
    private static final String kNotADirectoryError = "The specified entry is not a directory.";
    private static final String kDirectivesListFileSuffix = ".pbl";
    private static final String kDirectivesFileSuffix = ".pbd";
    private final IModuleFeedbackChannel fFeedback;
    private final ICompilerLog fLog;
    private final IStringLocalizer fLocalizer;
    private final ICompilerPersonality fPersonality;

    public DirectivesFileList(IModuleFeedbackChannel feedback, ICompilerLog log, IStringLocalizer localizer, ICompilerPersonality personality) {
        this.fLog = log;
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fPersonality = personality;
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    private ICompilerLog getCompilerLog() {
        return this.fLog;
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    private ICompilerPersonality getPersonality() {
        return this.fPersonality;
    }

    public void add(String[] names) throws DGParserException, DirectivesException, IOException {
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.add(names[i]);
                ++i;
            }
        }
    }

    public void add(IResourceReader resourceReader, String[] names) throws DGParserException, DirectivesException, InvalidResourceException, IOException {
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.add(resourceReader, names[i]);
                ++i;
            }
        }
    }

    public void add(String name) throws DGParserException, DirectivesException, IOException {
        if (name != null) {
            if (name.endsWith(kDirectivesListFileSuffix)) {
                DirectivesListFile listFile = new DirectivesListFile(this.getModuleFeedback(), this.getCompilerLog(), this.getStringLocalizer(), this.getPersonality(), name);
                this.add(listFile);
            } else if (name.endsWith(kDirectivesFileSuffix)) {
                DirectivesFile file = new DirectivesFile(this.getPersonality(), name);
                this.add(file);
            } else {
                File dir = new File(name);
                if (!dir.exists()) {
                    throw new DirectivesDirectoryException(kDoesNotExistError, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_Directory_Does_Not_Exist_Error", dir.getAbsolutePath()));
                }
                if (!dir.isDirectory()) {
                    throw new DirectivesDirectoryException(kNotADirectoryError, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_Directory_Not_A_Directory_Error", dir.getAbsolutePath()));
                }
                String[] fileList = dir.list();
                if (fileList != null) {
                    int j = 0;
                    while (j < fileList.length) {
                        if (fileList[j].endsWith(kDirectivesFileSuffix)) {
                            File fileInDir = new File(dir, fileList[j]);
                            DirectivesFile directivesFile = new DirectivesFile(this.getPersonality(), fileInDir);
                            this.add(directivesFile);
                        }
                        ++j;
                    }
                } else {
                    this.fFeedback.info("Couldn't read directives from directory: " + dir.getAbsolutePath());
                }
            }
        }
    }

    public void add(IResourceReader resourceReader, String name) throws DGParserException, DirectivesException, InvalidResourceException, IOException {
        if (name != null) {
            if (name.endsWith(kDirectivesListFileSuffix)) {
                DirectivesListFile listFile = new DirectivesListFile(this.getModuleFeedback(), this.getCompilerLog(), this.getStringLocalizer(), this.getPersonality(), resourceReader, name);
                this.add(listFile);
            } else if (name.endsWith(kDirectivesFileSuffix)) {
                DirectivesFile file = new DirectivesFile(this.getPersonality(), resourceReader, name);
                this.add(file);
            } else if (resourceReader.IResourceReader_supportsResourceLists(name)) {
                IResourceReader listReader = resourceReader.IResourceReader_getResourceReader(name);
                String[] resourceList = resourceReader.IResourceReader_getResourceList(name);
                if (resourceList != null) {
                    int j = 0;
                    while (j < resourceList.length) {
                        if (resourceList[j].endsWith(kDirectivesFileSuffix)) {
                            DirectivesFile directivesFile = new DirectivesFile(this.getPersonality(), listReader, resourceList[j]);
                            this.add(directivesFile);
                        }
                        ++j;
                    }
                }
            } else {
                throw new DirectivesDirectoryException(kNotADirectoryError, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Directives_Directory_Not_A_Directory_Error", resourceReader.IResourceReader_getResourceLocation(name)));
            }
        }
    }

    public void applyToSettings(CompilerSettingsBuilder builder, ICompilerLog log) throws ValidationException {
        Assertion.wilyAssert((log != null ? 1 : 0) != 0);
        for (Object obj : this) {
            if (obj instanceof IDirectiveCollection) {
                IDirectiveCollection file = (IDirectiveCollection)obj;
                builder.applySettings(file, log);
                continue;
            }
            if (!(obj instanceof DirectivesListFile)) continue;
            DirectivesListFile listFile = (DirectivesListFile)obj;
            builder.applySettings(listFile, log);
        }
    }
}

