/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives;

import com.wily.diagnos.cmp.directives.ADirective;
import com.wily.diagnos.cmp.directives.FlagName;
import com.wily.diagnos.cmp.directives.builder.CompilerSettingsBuilder;
import com.wily.diagnos.cmp.directives.builder.TracerGroupBuilder;
import com.wily.diagnos.cmp.transform.builder.SubscribeToOneMethodTransformationBuilder;
import com.wily.util.classfile.IMethodName;
import com.wily.util.validate.ValidationException;

public class SubscribeToOneMethodIfFlaggedDirective
extends ADirective {
    private final FlagName fFlagName;
    private final IMethodName fMethodName;
    private final String fSubscriberPluginName;

    public SubscribeToOneMethodIfFlaggedDirective(String source, int lineNumber, FlagName flagName, IMethodName methodName, String subscriberPluginName) {
        super(source, lineNumber);
        this.fFlagName = flagName;
        this.fMethodName = methodName;
        this.fSubscriberPluginName = subscriberPluginName;
    }

    public FlagName getFlagName() {
        return this.fFlagName;
    }

    public IMethodName getMethodName() {
        return this.fMethodName;
    }

    public String getSubscriberPluginName() {
        return this.fSubscriberPluginName;
    }

    @Override
    protected void applyToSettings(CompilerSettingsBuilder builder) throws ValidationException {
        TracerGroupBuilder tracerGroupBuilder = builder.getTracerGroupBuilder(this.getFlagName());
        builder.addTransformation(new SubscribeToOneMethodTransformationBuilder(tracerGroupBuilder, this.getMethodName(), this.getSubscriberPluginName()));
        tracerGroupBuilder.setSource(this.getSource());
    }
}

