/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java;

import com.wily.diagnos.cmp.DGCompilationFailedException;
import com.wily.diagnos.cmp.batch.CompilerEnvironment;
import com.wily.diagnos.cmp.batch.DGFileSettings;
import com.wily.diagnos.cmp.batch.EmptyMethodCompiler;
import com.wily.diagnos.cmp.batch.IBatchCompiler;
import com.wily.diagnos.cmp.batch.IClassCompiler;
import com.wily.diagnos.cmp.batch.IMethodCompiler;
import com.wily.diagnos.cmp.classfile.DGClassException;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.ui.ICompilerUI;
import com.wily.diagnos.personality.ICompilerPersonality;
import com.wily.diagnos.personality.java.compiler.DGClassCompiler;
import com.wily.diagnos.personality.java.compiler.DGFolderCompiler;
import com.wily.diagnos.personality.java.compiler.DGStreamBatchCompiler;
import com.wily.diagnos.personality.java.compiler.DGStreamSingleCompiler;
import com.wily.diagnos.personality.java.compiler.DGZipCompiler;
import com.wily.util.classfile.IClassSchemaPolicy;
import com.wily.util.classfile.java.JavaClassSchemaPolicy;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;

public class JavaPersonality
implements ICompilerPersonality {
    private static final ICompilerPersonality sSingleton = new JavaPersonality();
    private static final String kInternalErrorMessage = "Internal error. Failed to create compiler.";

    private JavaPersonality() {
    }

    public static synchronized ICompilerPersonality getJavaPersonality() {
        return sSingleton;
    }

    @Override
    public IClassSchemaPolicy getClassSchemaPolicy() {
        return JavaClassSchemaPolicy.getJavaClassSchemaPolicy();
    }

    @Override
    public IBatchCompiler newBatchCompiler(CompilerEnvironment env, DGCompilerSettings settings, DGFileSettings fileSettings, ICompilerUI ui, ICompilerLog log, IModuleFeedbackChannel feedback, IStringLocalizer localizer) throws IOException, DGCompilationFailedException {
        Assertion.wilyAssert((log != null ? 1 : 0) != 0);
        DGStreamBatchCompiler result = null;
        if (env.processingJarFile()) {
            File srcJar = new File(env.getSourceJar());
            File dstJar = new File(env.getInstrumentedDestinationJar());
            result = new DGZipCompiler(settings, fileSettings, ui, log, srcJar, dstJar);
        } else if (env.processingClassFile()) {
            File srcClass = new File(env.getSourceClass());
            File dstClass = new File(env.getInstrumentedDestinationClass());
            result = new DGClassCompiler(settings, fileSettings, ui, log, srcClass, dstClass);
        } else if (env.processingDirectory()) {
            File srcFolder = new File(env.getSourceDirectory());
            String dst = env.getInstrumentedDestinationDirectory();
            File dstFolder = new File(dst);
            result = new DGFolderCompiler(settings, fileSettings, ui, log, srcFolder, dstFolder);
        }
        if (result == null) {
            throw new IOException(kInternalErrorMessage);
        }
        return result;
    }

    @Override
    public IClassCompiler newClassCompiler(DGCompilerSettings settings, ICompilerLog log) {
        return new JavaClassCompiler(settings, log);
    }

    @Override
    public IMethodCompiler newMethodCompiler(DGCompilerSettings settings, ICompilerLog log, IModuleFeedbackChannel feedback, IStringLocalizer localizer, Object callbackContext) {
        Assertion.unimplemented((String)"method level compilation not supported");
        return new EmptyMethodCompiler(settings, log);
    }

    private static final class JavaClassCompiler
    implements IClassCompiler {
        private final DGCompilerSettings fSettings;
        private final ICompilerLog fLog;

        public JavaClassCompiler(DGCompilerSettings settings, ICompilerLog log) {
            this.fSettings = settings;
            this.fLog = log;
        }

        public DGCompilerSettings getSettings() {
            return this.fSettings;
        }

        public ICompilerLog getLog() {
            return this.fLog;
        }

        @Override
        public byte[] compileOneClass(String className, ClassLoader loader, byte[] classBytes, boolean isRedefine, Class<?> classRedefined) throws DGClassException, IOException {
            ByteArrayInputStream input = new ByteArrayInputStream(classBytes);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            DGStreamSingleCompiler compiler = new DGStreamSingleCompiler(this.getSettings(), this.getLog(), input, output, loader, isRedefine, classRedefined);
            compiler.compileOneClass();
            return output.toByteArray();
        }
    }
}

