/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes.stackmapframe;

import com.wily.diagnos.cmp.classfile.DGClassModificationException;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.util.classfile.java.ClassFileFieldDescriptor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class DGVerificationTypeInfo {
    public static final byte kITEMTop = 0;
    public static final byte kITEMInteger = 1;
    public static final byte kITEMFloat = 2;
    public static final byte kITEMDouble = 3;
    public static final byte kITEMLong = 4;
    public static final byte kITEMNull = 5;
    public static final byte kITEMUninitializedThis = 6;
    public static final byte kITEMObject = 7;
    public static final byte kITEMUnitinialized = 8;

    public DGVerificationTypeInfo(DataInputStream data) {
    }

    public String toString() {
        return "TypeInfo";
    }

    public abstract void write(DataOutputStream var1) throws IOException;

    public abstract int size();

    public static byte getTypeInfo(ClassFileFieldDescriptor argType) {
        if (argType.isAnyReference()) {
            return 7;
        }
        if (argType.isChar() || argType.isSInt8() || argType.isBoolean() || argType.isSInt16() || argType.isSInt32()) {
            return 1;
        }
        if (argType.isFloat()) {
            return 2;
        }
        if (argType.isDouble()) {
            return 3;
        }
        if (argType.isSInt64()) {
            return 4;
        }
        if (argType.isAnyReference()) {
            return 7;
        }
        return 0;
    }

    public static int getTypeArg(ClassFileFieldDescriptor argType, DGConstantPool cp) {
        int cpi = 0;
        if (argType.isAnyReference()) {
            if (argType.isNonArrayReference()) {
                String descriptor = argType.toString();
                String className = descriptor.substring(1, descriptor.length() - 1);
                try {
                    cpi = cp.addClassReferenceIfNecessary(className);
                }
                catch (DGClassModificationException dGClassModificationException) {
                    cpi = 0;
                }
            } else {
                String descriptor;
                String className = descriptor = argType.toString();
                try {
                    cpi = cp.addClassReferenceIfNecessary(className);
                }
                catch (DGClassModificationException dGClassModificationException) {
                    cpi = 0;
                }
            }
        }
        return cpi;
    }

    public abstract int getNumSlotsUsed();
}

