/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.MetricNotFoundException;
import com.wily.util.IConfigurationListener;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.properties.hot.PositiveLongConfigurationProperty;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class BTThreadLocalAdministrator {
    private static IAgent fAgent;
    private static final Module kModule;
    public static final String kSustainabilityBaseMetricName = "Agent Stats|Sustainability|Browser Agent Business Transaction";
    public static final char kBrowserAgentCommaChar = ',';
    private static String jarLocation;
    private static final String SNIPPET_FILE_EXT_NAME = "basnippet";
    private static final String APP_ID_KEY_PATTERN = "[a-zA-Z0-9]+";
    private static volatile boolean autoInjectionEnabled;
    private static boolean sustainabilityMetricsOn;
    private static int throttleResponseLimit;
    private static volatile boolean headFilterPresenceCheckEnabled;
    private static volatile boolean tailFilterPresenceCheckEnabled;
    private static long snippetMaxSearchingLength;
    private static volatile int maxSearchCounter;
    private static volatile HashSet maxSearchReachedUrls;
    private static int searchingMethodHierarchyMaxDepth;
    private static boolean encodingEnabled;
    private static int autoskipInstrumentClassDepth;
    private static boolean responseDecorationEnabled;
    private static int responseCookieExpirationTime;
    private static String responseDecorationIncludeURLsRegex;
    private static Pattern responseDecorationIncludeURLsRegexPattern;
    private static boolean apmDataResponseDecorationEnabled;
    private static String dxcServerHost;
    private static int dxcServerPort;
    private static final int MAX_PORT_NUMBER = 65535;
    private static String dxcServerPortInPreviousProfile;
    private static boolean dxcServerSSLEnabled;
    private static final String PROPERTYNAME_CORGUIDENABLED = "introscope.agent.browseragent.corguid.enabled";
    private static boolean corguidEnabled;
    private static final String PROPERTYNAME_SNIPPETSTRING = "introscope.agent.browseragent.snippetString";
    private static final int MINIMUM_SNIPPETSTRING_LENGTH = 16;
    private static Map snippetPropertiesMap;
    private static boolean initializeSnippetList;
    private static String snippetString;
    private static final String dxcServerHostReplacementPattern = "{host}";
    private static final String dxcServerPortReplacementPattern = "{port}";
    private static final String dxcServerSSLEnabledPattern = "{protocol}";
    private static final String extensionJarTracerName = "BRTM Tracer";
    private static final String appGroupPrefix = "introscope.agent.browseragent.autoInjection";
    private static volatile String appGroupKeys;
    private static final String snippetLocationSuffix = "snippetLocation";
    private static final String includeURLsRegexSuffix = "includeURLsRegex";
    private static final String propSeparator = ".";
    private static List snippetLocationList;
    private static List snippetCodeList;
    private static List includeURLsRegexList;
    private static List compiledPatternList;
    private static List snippetCodeWithCorrelationList;
    private static IConfigurationListener configListener;
    private static IConfigurationListener responseDecorationConfigListener;
    private static String excludeResponseContentPatterns;
    private static String[] excludeResponseContentPatternsList;
    public static boolean reInitialize;
    private static List browserSupportList;
    private static String BROWSER_LIST_PROPERTY;
    private static final String SCRIPT_TAG_START = "<script";
    private static final String SNIPPET_CORRELATION_STRING = "<script x-apm-ba-response-bt=\"<correlation>\" ";
    private static String COOKIE_CONTENTTYPE_PROPERTY;
    private static volatile String cookieContentType;
    private static volatile String[] cookieContentTypeArray;
    private static String AUTOINJECTION_DEEP_CHECK_PROPERTY;
    private static boolean autoInjectionDeepCheck;
    private static volatile boolean enableAutoInjectionDeepCheckLogWarned;
    private static final String oldResponseCookieEnabled = "introscope.agent.browseragent.responseCookieEnabled";
    private static final String oldResponseCookieExpirationTime = "introscope.agent.browseragent.responseCookie.expirationTime";
    private static final String oldResponseCookieIncludeURLsRegex = "introscope.agent.browseragent.responseCookie.includeURLsRegex";
    private static final String oldCookieAPMDataEnabledName = "introscope.agent.browseragent.responseCookie.apmData.enabled";
    private ThreadLocal stackData = new ThreadLocal(){

        public Object initialValue() {
            return new HashMap();
        }
    };

    static {
        kModule = new Module("BrowserAgent");
        jarLocation = null;
        autoInjectionEnabled = false;
        sustainabilityMetricsOn = true;
        throttleResponseLimit = 1000;
        headFilterPresenceCheckEnabled = true;
        tailFilterPresenceCheckEnabled = true;
        snippetMaxSearchingLength = 32768L;
        maxSearchCounter = 0;
        maxSearchReachedUrls = new HashSet();
        searchingMethodHierarchyMaxDepth = 3;
        encodingEnabled = false;
        autoskipInstrumentClassDepth = 1;
        responseDecorationEnabled = false;
        responseCookieExpirationTime = 3;
        responseDecorationIncludeURLsRegex = null;
        responseDecorationIncludeURLsRegexPattern = null;
        apmDataResponseDecorationEnabled = true;
        dxcServerHost = "localhost";
        dxcServerPort = 80;
        dxcServerPortInPreviousProfile = "";
        dxcServerSSLEnabled = false;
        corguidEnabled = false;
        snippetPropertiesMap = new HashMap();
        initializeSnippetList = false;
        snippetString = null;
        appGroupKeys = null;
        snippetLocationList = new ArrayList();
        snippetCodeList = new ArrayList();
        includeURLsRegexList = new ArrayList();
        compiledPatternList = new ArrayList();
        snippetCodeWithCorrelationList = new ArrayList();
        excludeResponseContentPatterns = null;
        excludeResponseContentPatternsList = null;
        reInitialize = true;
        browserSupportList = new ArrayList();
        BROWSER_LIST_PROPERTY = "introscope.agent.browseragent.browserlist";
        COOKIE_CONTENTTYPE_PROPERTY = "introscope.agent.browseragent.response.decoration.cookie.contenttype";
        cookieContentType = "text/html";
        cookieContentTypeArray = null;
        AUTOINJECTION_DEEP_CHECK_PROPERTY = "introscope.agent.browseragent.autoInjection.deep.check";
        autoInjectionDeepCheck = false;
        enableAutoInjectionDeepCheckLogWarned = false;
    }

    public static boolean isReInitialize() {
        return reInitialize;
    }

    public static void setReInitialize(boolean value) {
        reInitialize = value;
    }

    private BTThreadLocalAdministrator() {
        try {
            fAgent = AgentShim.getAgent();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            return;
        }
        boolean isUsingOldConfig = fAgent.IAgent_getComponentTracer().isAgentOldMode();
        if (!isUsingOldConfig) {
            this.initializeBAProperties();
        }
    }

    public static BTThreadLocalAdministrator getInstance() {
        return BTThreadLocalAdministratorInstance.kInstance;
    }

    public Object get(String key) {
        HashMap dataInstance = (HashMap)this.stackData.get();
        return dataInstance.get(key);
    }

    public String getString(String key) {
        Object value = this.get(key);
        return value instanceof String ? (String)value : null;
    }

    public void insert(String key, Object value) {
        if (key != null && value != null) {
            HashMap dataInstance = (HashMap)this.stackData.get();
            dataInstance.put(key, value);
        }
    }

    public void remove(String key) {
        if (key != null) {
            HashMap dataInstance = (HashMap)this.stackData.get();
            dataInstance.remove(key);
        }
    }

    public void flush() {
        HashMap dataInstance = (HashMap)this.stackData.get();
        dataInstance.clear();
    }

    public boolean isSustainabilityMetricEnabled() {
        return sustainabilityMetricsOn;
    }

    public String[] getExcludeResponseContentPatterns() {
        if (excludeResponseContentPatternsList != null && excludeResponseContentPatternsList.length > 0) {
            return excludeResponseContentPatternsList;
        }
        if (excludeResponseContentPatterns == null) {
            return null;
        }
        excludeResponseContentPatternsList = excludeResponseContentPatterns.split(String.valueOf(','));
        return excludeResponseContentPatternsList;
    }

    public int getThrottleLimit() {
        return throttleResponseLimit;
    }

    public int getSearchingMethodHierarchyMaxDepth() {
        return searchingMethodHierarchyMaxDepth;
    }

    public long getMaxResponseContentLengthForSearching() {
        return snippetMaxSearchingLength;
    }

    public boolean shouldCheckForHeadFilterPresence() {
        return headFilterPresenceCheckEnabled;
    }

    public void setHeadFilterPresenceCheckEnabled(boolean status) {
        headFilterPresenceCheckEnabled = status;
    }

    public boolean shouldCheckForTailFilterPresence() {
        return tailFilterPresenceCheckEnabled;
    }

    public void setTailFilterPresenceCheckEnabled(boolean status) {
        tailFilterPresenceCheckEnabled = status;
    }

    public void increaseMaxSearchCountAndRecordUrl(String url) {
        ++maxSearchCounter;
        maxSearchReachedUrls.add(url);
    }

    public void resetMaxSearchCountAndUrl() {
        maxSearchCounter = 0;
        maxSearchReachedUrls.clear();
    }

    public int getMaxSearchCount() {
        return maxSearchCounter;
    }

    public String getMaxSearchUrls() {
        return maxSearchReachedUrls.toString();
    }

    public boolean isEncodingSupport() {
        return encodingEnabled;
    }

    public int getAutoskipInstrumentClassDepth() {
        return autoskipInstrumentClassDepth;
    }

    private static void logErrorMessages(String message) {
        fAgent.IAgent_getModuleFeedback().error(kModule, message);
    }

    private static void logInfoMessages(String message) {
        if (fAgent.IAgent_getModuleFeedback().isInfoEnabled(kModule)) {
            fAgent.IAgent_getModuleFeedback().info(kModule, message);
        }
    }

    private static void logWarnMessages(String message) {
        if (fAgent.IAgent_getModuleFeedback().isWarningEnabled(kModule)) {
            fAgent.IAgent_getModuleFeedback().warn(kModule, message);
        }
    }

    private static void logDebugMessages(String message) {
        if (fAgent.IAgent_getModuleFeedback().isDebugEnabled(kModule)) {
            fAgent.IAgent_getModuleFeedback().debug(kModule, message);
        }
    }

    private static void logTraceMessages(String message) {
        if (fAgent.IAgent_getModuleFeedback().isTraceEnabled(kModule)) {
            fAgent.IAgent_getModuleFeedback().trace(kModule, message);
        }
    }

    private void initializeBAProperties() {
        excludeResponseContentPatterns = fAgent.IAgent_getIndexedProperties().getProperty("introscope.agent.browseragent.autoInjection.excludeResponseContentPatterns", null);
        this.setBrowserSupportList();
        this.setBAExtJarLocation();
        fAgent.IAgent_getConfigurationManager().add(new AuotInjectionEnabledProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new AutoInjectionSnippetThrottleResponseLimitProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new HeadFilterPresenceCheckProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new TailFilterPresenceCheckProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new MaxResponseContentLengthForSearchingProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new SearchingMethodHierarchyMaxDepthProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new EncodingSupportEnabledProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new AutoskipInstrumentclassDepthProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new SustainabilityMetricsProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new CorguidEnabledProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new CookieContentTypeProperty(fAgent), true);
        fAgent.IAgent_getConfigurationManager().add(new AutoInjectionDeepCheckProperty(fAgent), true);
        this.setResponseDecorationProperties();
    }

    private void setResponseDecorationProperties() {
        responseDecorationConfigListener = new IConfigurationListener(){

            @Override
            public void onChange(IndexedProperties props) {
                this.checkResponseDecorationEnabled(props);
                this.checkAPMDataResponseDecorationEnabled(props);
                this.checkResponseDecorationCookieExpireTime(props);
                this.checkResponseDecorationIncludeURLRegex(props);
            }

            private void checkResponseDecorationIncludeURLRegex(IndexedProperties props) {
                boolean changedFromOldProperty = false;
                String newValue = null;
                if (props.getProperty("introscope.agent.browseragent.response.decoration.includeURLsRegex") != null) {
                    newValue = props.getTrimmedProperty("introscope.agent.browseragent.response.decoration.includeURLsRegex");
                } else if (props.getProperty(BTThreadLocalAdministrator.oldResponseCookieIncludeURLsRegex) != null) {
                    newValue = props.getTrimmedProperty(BTThreadLocalAdministrator.oldResponseCookieIncludeURLsRegex);
                    changedFromOldProperty = true;
                }
                if (newValue != null && !newValue.equals(responseDecorationIncludeURLsRegex)) {
                    responseDecorationIncludeURLsRegex = newValue;
                    StringBuilder sbuf = new StringBuilder();
                    Formatter fmt = new Formatter(sbuf);
                    String propertyLogFormat = "The %3$s property is set to %2$s.";
                    if (responseDecorationIncludeURLsRegex.trim().length() > 0) {
                        responseDecorationIncludeURLsRegexPattern = BTThreadLocalAdministrator.this.getRegexPattern(responseDecorationIncludeURLsRegex);
                        if (changedFromOldProperty) {
                            propertyLogFormat = "The deprecated %1$s property is set to %2$s and is being processed as %3$s = %2$s.";
                        }
                        if (responseDecorationIncludeURLsRegexPattern == null) {
                            responseDecorationIncludeURLsRegexPattern = null;
                            propertyLogFormat = changedFromOldProperty ? "The deprecated %1$s property is not in the correct format. Please follow the user documentation and use %3$s property." : "The %3$s property is not in the correct format. Please follow the user documentation.";
                        }
                    } else {
                        responseDecorationIncludeURLsRegex = null;
                        responseDecorationIncludeURLsRegexPattern = null;
                        propertyLogFormat = changedFromOldProperty ? "The deprecated %1$s property is set to empty and is being processed as %3$s" : "The %3$s property is set to empty.";
                    }
                    fmt.format(propertyLogFormat, BTThreadLocalAdministrator.oldResponseCookieIncludeURLsRegex, responseDecorationIncludeURLsRegex, "introscope.agent.browseragent.response.decoration.includeURLsRegex");
                    BTThreadLocalAdministrator.logInfoMessages(sbuf.toString());
                    if (sustainabilityMetricsOn) {
                        fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.includeURLsRegex").IStringEveryEventDataAccumulator_addString(responseDecorationIncludeURLsRegex == null ? "" : responseDecorationIncludeURLsRegex);
                    }
                }
            }

            private void checkResponseDecorationCookieExpireTime(IndexedProperties props) {
                boolean changedFromOldProperty = false;
                boolean contained = false;
                int newExpireTime = -1;
                if (props.getProperty("introscope.agent.browseragent.response.decoration.cookie.expirationTime") != null) {
                    newExpireTime = props.getIntProperty("introscope.agent.browseragent.response.decoration.cookie.expirationTime");
                    contained = true;
                } else if (props.getProperty(BTThreadLocalAdministrator.oldResponseCookieExpirationTime) != null) {
                    newExpireTime = props.getIntProperty(BTThreadLocalAdministrator.oldResponseCookieExpirationTime);
                    changedFromOldProperty = true;
                    contained = true;
                }
                if (contained && newExpireTime != responseCookieExpirationTime) {
                    StringBuffer sbuf = new StringBuffer();
                    Formatter fmt = new Formatter(sbuf);
                    String propertyLogFormat = "The %3$s property is set to %2$d.";
                    if (newExpireTime > 0) {
                        responseCookieExpirationTime = newExpireTime;
                        if (changedFromOldProperty) {
                            propertyLogFormat = "The deprecated %1$s property is set to %2$d and is being processed as %3$s = %2$d.";
                        }
                    } else {
                        responseCookieExpirationTime = 3;
                        propertyLogFormat = changedFromOldProperty ? "The deprecated %1$s property cannot be set to a negative value, this property will be set to the default value. Please follow the user documentation and use %3$s property." : "The %3$s property cannot be set to a negative value, this property will be set to the default value. Please follow the user documentation.";
                    }
                    fmt.format(propertyLogFormat, BTThreadLocalAdministrator.oldResponseCookieExpirationTime, responseCookieExpirationTime, "introscope.agent.browseragent.response.decoration.cookie.expirationTime");
                    BTThreadLocalAdministrator.logInfoMessages(sbuf.toString());
                    if (sustainabilityMetricsOn) {
                        fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.cookie.expirationTime").IIntegerCounterDataAccumulator_setValue(responseCookieExpirationTime);
                    }
                }
            }

            private void checkAPMDataResponseDecorationEnabled(IndexedProperties props) {
                boolean changedFromOldProperty = false;
                String newAPMDataResponseDecorationEnabled = null;
                if (props.getProperty("introscope.agent.browseragent.response.decoration.apmData.enabled") != null) {
                    newAPMDataResponseDecorationEnabled = props.getTrimmedProperty("introscope.agent.browseragent.response.decoration.apmData.enabled");
                } else if (props.getProperty(BTThreadLocalAdministrator.oldCookieAPMDataEnabledName) != null) {
                    newAPMDataResponseDecorationEnabled = props.getTrimmedProperty(BTThreadLocalAdministrator.oldCookieAPMDataEnabledName);
                    changedFromOldProperty = true;
                }
                if (newAPMDataResponseDecorationEnabled != null && !newAPMDataResponseDecorationEnabled.equalsIgnoreCase(String.valueOf(apmDataResponseDecorationEnabled)) && (newAPMDataResponseDecorationEnabled.equalsIgnoreCase("true") || newAPMDataResponseDecorationEnabled.equalsIgnoreCase("false"))) {
                    apmDataResponseDecorationEnabled = Boolean.valueOf(newAPMDataResponseDecorationEnabled);
                    if (apmDataResponseDecorationEnabled) {
                        if (sustainabilityMetricsOn) {
                            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.apmData.enabled").IIntegerCounterDataAccumulator_setValue(1);
                        }
                        BTThreadLocalAdministrator.logInfoMessages("APM Data Response Decoration is enabled");
                    } else {
                        if (sustainabilityMetricsOn) {
                            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.apmData.enabled").IIntegerCounterDataAccumulator_setValue(0);
                        }
                        BTThreadLocalAdministrator.logInfoMessages("APM Data Response Decoration is disabled");
                    }
                    if (changedFromOldProperty) {
                        StringBuffer sbuf = new StringBuffer();
                        Formatter fmt = new Formatter(sbuf);
                        String propertyLogFormat = "The deprecated %1$s property is set to %2$b and is being processed as %3$s = %2$b.";
                        fmt.format(propertyLogFormat, BTThreadLocalAdministrator.oldCookieAPMDataEnabledName, apmDataResponseDecorationEnabled, "introscope.agent.browseragent.response.decoration.apmData.enabled");
                        BTThreadLocalAdministrator.logInfoMessages(sbuf.toString());
                    }
                }
            }

            private void checkResponseDecorationEnabled(IndexedProperties props) {
                boolean changedFromOldProperty = false;
                String newResponseDecorationEnabled = null;
                if (props.getProperty("introscope.agent.browseragent.response.decoration.enabled") != null) {
                    newResponseDecorationEnabled = props.getTrimmedProperty("introscope.agent.browseragent.response.decoration.enabled");
                } else if (props.getProperty(BTThreadLocalAdministrator.oldResponseCookieEnabled) != null) {
                    newResponseDecorationEnabled = props.getTrimmedProperty(BTThreadLocalAdministrator.oldResponseCookieEnabled);
                    changedFromOldProperty = true;
                }
                if (newResponseDecorationEnabled != null && !newResponseDecorationEnabled.equalsIgnoreCase(String.valueOf(responseDecorationEnabled)) && (newResponseDecorationEnabled.equalsIgnoreCase("true") || newResponseDecorationEnabled.equalsIgnoreCase("false"))) {
                    reInitialize = true;
                    responseDecorationEnabled = Boolean.valueOf(newResponseDecorationEnabled);
                    if (responseDecorationEnabled) {
                        if (sustainabilityMetricsOn) {
                            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.enabled").IIntegerCounterDataAccumulator_setValue(1);
                        }
                        BTThreadLocalAdministrator.logInfoMessages("Response Decoration is enabled");
                    } else {
                        if (sustainabilityMetricsOn) {
                            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.enabled").IIntegerCounterDataAccumulator_setValue(0);
                        }
                        BTThreadLocalAdministrator.logInfoMessages("Response Decoration is disabled");
                    }
                    if (changedFromOldProperty) {
                        StringBuffer sbuf = new StringBuffer();
                        Formatter fmt = new Formatter(sbuf);
                        String propertyLogFormat = "The deprecated %1$s property is set to %2$b and is being processed as %3$s = %2$b.";
                        fmt.format(propertyLogFormat, BTThreadLocalAdministrator.oldResponseCookieEnabled, responseDecorationEnabled, "introscope.agent.browseragent.response.decoration.enabled");
                        BTThreadLocalAdministrator.logInfoMessages(sbuf.toString());
                    }
                }
            }
        };
        fAgent.addConfigurationListener(responseDecorationConfigListener);
    }

    private void setBrowserSupportList() {
        String browsers = fAgent.IAgent_getConfigurationManager().getProperty(BROWSER_LIST_PROPERTY);
        if (browsers == null) {
            browserSupportList.add("Unsupported|opera");
            browserSupportList.add("Unsupported|opr");
            browserSupportList.add("Edge|edge|edge/|12");
            browserSupportList.add("IE|msie|msie |9");
            browserSupportList.add("IE|trident|rv:|9");
            browserSupportList.add("Chrome|chrome|chrome/|30");
            browserSupportList.add("Chrome|crios|crios/|30");
            browserSupportList.add("Chrome|crmo|crmo/|30");
            browserSupportList.add("Firefox|firefox|firefox/|30");
            browserSupportList.add("Firefox|iceweasel|iceweasel/|30");
            browserSupportList.add("Safari|safari|version/|9");
        } else {
            String[] items;
            String[] stringArray = items = browsers.split(",");
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                browserSupportList.add(item.trim());
                ++n2;
            }
        }
    }

    public List getBrowserSupportList() {
        return browserSupportList;
    }

    public void stopReportSustainabilityMetrics() {
        try {
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.enabled");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.includeURLsRegex");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.throttleResponseLimit");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.cookie.expirationTime");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.responseCount");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.snippet.maxSearchingReached.count");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.unsupportedBrowsers.count");
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:" + COOKIE_CONTENTTYPE_PROPERTY);
            fAgent.IAgent_getDataAccumulatorFactory().removeMetric("Agent Stats|Sustainability|Browser Agent Business Transaction:" + AUTOINJECTION_DEEP_CHECK_PROPERTY);
        }
        catch (BadlyFormedNameException e) {
            BTThreadLocalAdministrator.logTraceMessages("BadlyFormedNameException:" + e.getMessage());
        }
        catch (MetricNotFoundException e) {
            BTThreadLocalAdministrator.logTraceMessages("MetricNotFoundException:" + e.getMessage());
        }
    }

    public void startReportingSustainabilityMetrics() {
        if (autoInjectionEnabled) {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled").IIntegerCounterDataAccumulator_setValue(1);
        } else {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled").IIntegerCounterDataAccumulator_setValue(0);
        }
        if (responseDecorationEnabled) {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.enabled").IIntegerCounterDataAccumulator_setValue(1);
        } else {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.enabled").IIntegerCounterDataAccumulator_setValue(0);
        }
        fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.includeURLsRegex").IStringEveryEventDataAccumulator_addString(responseDecorationIncludeURLsRegex == null ? "" : responseDecorationIncludeURLsRegex);
        fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID").IStringEveryEventDataAccumulator_addString(appGroupKeys == null ? "" : appGroupKeys);
        fAgent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength").ILongCounterDataAccumulator_setValue(snippetMaxSearchingLength);
        fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.throttleResponseLimit").IIntegerCounterDataAccumulator_setValue(throttleResponseLimit);
        fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.response.decoration.cookie.expirationTime").IIntegerCounterDataAccumulator_setValue(responseCookieExpirationTime);
        if (encodingEnabled) {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled").IIntegerCounterDataAccumulator_setValue(1);
        } else {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled").IIntegerCounterDataAccumulator_setValue(0);
        }
        fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:" + COOKIE_CONTENTTYPE_PROPERTY).IStringEveryEventDataAccumulator_addString(cookieContentType == null ? "" : cookieContentType);
        if (autoInjectionDeepCheck) {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:" + AUTOINJECTION_DEEP_CHECK_PROPERTY).IIntegerCounterDataAccumulator_setValue(1);
        } else {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:" + AUTOINJECTION_DEEP_CHECK_PROPERTY).IIntegerCounterDataAccumulator_setValue(0);
        }
    }

    private Pattern getRegexPattern(String regex) {
        Pattern pattern = null;
        if (regex != null) {
            try {
                pattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                BTThreadLocalAdministrator.logWarnMessages("Regex pattern: " + regex + " is illegal.");
            }
        }
        BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("getRegexPattern(String regex)::pattern: ").append(pattern).toString());
        return pattern;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static synchronized String getSnippetCode(String filePath) {
        String snippetCode = null;
        try {
            if (filePath != null && filePath.length() > 0) {
                File file = new File(filePath);
                if (!file.isAbsolute()) {
                    if (jarLocation != null && jarLocation.length() > 0) {
                        String jarPath = jarLocation.substring(0, jarLocation.lastIndexOf(File.separator));
                        file = new File(String.valueOf(jarPath) + File.separator + filePath);
                        filePath = file.getAbsolutePath();
                    } else {
                        BTThreadLocalAdministrator.logWarnMessages("Can not get the snippet file location because of the missing browser agent extension jar");
                    }
                }
                if (file != null && file.length() > 0L) {
                    String line;
                    if (!file.canRead()) {
                        BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this snippet file is not readable.");
                        return null;
                    }
                    String ext = BTThreadLocalAdministrator.getExtension(file);
                    if (ext == null || !ext.equalsIgnoreCase(SNIPPET_FILE_EXT_NAME)) {
                        BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this snippet file does not have correct extension.");
                        return null;
                    }
                    BufferedReader input = new BufferedReader(new FileReader(file));
                    StringBuilder buf = new StringBuilder();
                    while ((line = input.readLine()) != null) {
                        buf.append(line);
                        buf.append('\n');
                    }
                    snippetCode = buf.toString().trim();
                    if (snippetCode.length() < 1) {
                        BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", the snippet file is empty.");
                        return null;
                    }
                    BTThreadLocalAdministrator.logInfoMessages("Found the snippet file in " + filePath);
                    return BTThreadLocalAdministrator.getReplacedSnippetCode(snippetCode);
                }
                BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this snippet file is empty or not readable.");
                return null;
            }
            BTThreadLocalAdministrator.logErrorMessages("The snippet file path is empty.");
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this snippet file is not found.");
            return null;
        }
        catch (IOException iOException) {
            BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this snippet file could not be initialized.");
            return null;
        }
        catch (SecurityException securityException) {
            BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", security denied access.");
            return null;
        }
        catch (Exception exception) {
            BTThreadLocalAdministrator.logErrorMessages(String.valueOf(filePath) + ", this snippet file could not be initialized.");
            return null;
        }
    }

    private static String getReplacedSnippetCode(String snippetCode) {
        snippetCode = String.valueOf(dxcServerSSLEnabled).equalsIgnoreCase("false") ? snippetCode.replace(dxcServerSSLEnabledPattern, "http") : snippetCode.replace(dxcServerSSLEnabledPattern, "https");
        snippetCode = snippetCode.replace(dxcServerHostReplacementPattern, dxcServerHost);
        snippetCode = snippetCode.replace(dxcServerPortReplacementPattern, String.valueOf(dxcServerPort));
        return snippetCode;
    }

    private static String getExtension(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return name.substring(index + 1);
    }

    private void removeSnippetProperties() {
        if (configListener != null) {
            fAgent.removeConfigurationListener(configListener);
            configListener = null;
        }
        appGroupKeys = null;
        snippetString = null;
        snippetPropertiesMap = new HashMap();
        initializeSnippetList = false;
        snippetLocationList = new ArrayList();
        snippetCodeList = new ArrayList();
        includeURLsRegexList = new ArrayList();
        compiledPatternList = new ArrayList();
        snippetCodeWithCorrelationList = new ArrayList();
    }

    private void initializeSnippetProperties() {
        if (configListener == null) {
            configListener = new IConfigurationListener(){

                @Override
                public void onChange(IndexedProperties props) {
                    if (autoInjectionEnabled) {
                        BTThreadLocalAdministrator.this.findSnippetProperties(props);
                        if (initializeSnippetList) {
                            BTThreadLocalAdministrator.this.initializeLists();
                            initializeSnippetList = false;
                        }
                    }
                }
            };
            fAgent.addConfigurationListener(configListener);
        }
    }

    private boolean setDXCServerSSLEnabled(IndexedProperties props) {
        String isSSLEnabled = props.getTrimmedProperty("introscope.agent.browseragent.ssl.enable");
        if (isSSLEnabled != null && isSSLEnabled.length() > 0 && Boolean.valueOf(isSSLEnabled) | Boolean.valueOf(isSSLEnabled) == false) {
            return Boolean.valueOf(isSSLEnabled);
        }
        return false;
    }

    private String setDXCServerHost(IndexedProperties props) {
        String host = props.getTrimmedProperty("introscope.agent.browseragent.dxchost");
        if (host != null && host.length() > 0) {
            return host;
        }
        return "localhost";
    }

    private int setDXCServerPort(IndexedProperties props) {
        String port = props.getTrimmedProperty("introscope.agent.browseragent.dxcport");
        int portValue = dxcServerPort;
        if (port != null && !String.valueOf(dxcServerPort).equals(port) && !dxcServerPortInPreviousProfile.equals(port)) {
            dxcServerPortInPreviousProfile = port;
            try {
                portValue = Integer.parseInt(port);
            }
            catch (NumberFormatException numberFormatException) {
                portValue = 0;
            }
            if (portValue <= 0 || portValue > 65535) {
                portValue = 80;
                StringBuilder sb = new StringBuilder();
                sb.append("introscope.agent.browseragent.dxcport").append(" must be set between 0 and ").append(65535).append(". This property will be set to the default value ").append(80);
                BTThreadLocalAdministrator.logWarnMessages(sb.toString());
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append("introscope.agent.browseragent.dxcport").append(" is set to ").append(portValue);
                BTThreadLocalAdministrator.logInfoMessages(sb.toString());
            }
        }
        return portValue;
    }

    private void initializeLists() {
        BTThreadLocalAdministrator.resetLists();
        String groupKeys = appGroupKeys;
        if (groupKeys != null && groupKeys.length() > 0) {
            String[] strtok = groupKeys.split(",");
            int i = 0;
            while (i < strtok.length) {
                Object appGroupIncludeURLsRegexfromProps;
                String key = strtok[i].trim();
                String prefixWithKey = "introscope.agent.browseragent.autoInjection." + key;
                String appGroupSnippetLocationProp = String.valueOf(prefixWithKey) + propSeparator + snippetLocationSuffix;
                String appGroupIncludeURLsRegexProp = String.valueOf(prefixWithKey) + propSeparator + includeURLsRegexSuffix;
                String appGroupSnippetLocation = null;
                String appGroupIncludeURLsRegex = null;
                Object appGroupSnippetLocationfromProps = snippetPropertiesMap.get(appGroupSnippetLocationProp);
                if (appGroupSnippetLocationfromProps instanceof String) {
                    appGroupSnippetLocation = (String)appGroupSnippetLocationfromProps;
                }
                if ((appGroupIncludeURLsRegexfromProps = snippetPropertiesMap.get(appGroupIncludeURLsRegexProp)) instanceof String) {
                    appGroupIncludeURLsRegex = (String)appGroupIncludeURLsRegexfromProps;
                }
                includeURLsRegexList.add(i, appGroupIncludeURLsRegex);
                snippetLocationList.add(i, appGroupSnippetLocation);
                if (appGroupIncludeURLsRegex == null) {
                    BTThreadLocalAdministrator.logWarnMessages("Value for the property " + appGroupIncludeURLsRegexProp + " is not provided or invalid");
                    compiledPatternList.add(i, null);
                } else {
                    try {
                        Pattern compiledPattern = Pattern.compile(appGroupIncludeURLsRegex);
                        compiledPatternList.add(i, compiledPattern);
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        BTThreadLocalAdministrator.logErrorMessages("PatternSyntaxException is thrown for " + appGroupIncludeURLsRegexProp + ", check your syntax. Pattern will be ignored");
                        compiledPatternList.add(i, null);
                    }
                }
                if (snippetString != null) {
                    snippetCodeList.add(i, snippetString);
                    snippetCodeWithCorrelationList.add(i, BTThreadLocalAdministrator.getSnippetCodeWithCorrelationReplacement(snippetString));
                } else if (appGroupSnippetLocation == null) {
                    BTThreadLocalAdministrator.logWarnMessages("Value for the property " + appGroupSnippetLocationProp + " is not provided or invalid");
                    snippetCodeList.add(i, null);
                    snippetCodeWithCorrelationList.add(i, null);
                } else {
                    String snippetCode = BTThreadLocalAdministrator.getSnippetCode(appGroupSnippetLocation);
                    if (snippetCode == null) {
                        BTThreadLocalAdministrator.logWarnMessages("Value for the property " + appGroupSnippetLocationProp + " is not provided or invalid");
                        snippetCodeList.add(i, null);
                        snippetCodeWithCorrelationList.add(i, null);
                    } else {
                        snippetCodeList.add(i, snippetCode);
                        snippetCodeWithCorrelationList.add(i, BTThreadLocalAdministrator.getSnippetCodeWithCorrelationReplacement(snippetCode));
                    }
                }
                ++i;
            }
        }
    }

    private static boolean onlyContainsLetterAndNumber(String key) {
        Pattern p = Pattern.compile(APP_ID_KEY_PATTERN);
        if (p.matcher(key).matches()) {
            return true;
        }
        BTThreadLocalAdministrator.logWarnMessages(String.valueOf(key) + " is invalid for " + "introscope.agent.browseragent.autoInjection.appID" + ", the value only allows numbers and letters");
        return false;
    }

    private static void resetLists() {
        snippetLocationList = new ArrayList();
        snippetCodeList = new ArrayList();
        includeURLsRegexList = new ArrayList();
        compiledPatternList = new ArrayList();
        snippetCodeWithCorrelationList = new ArrayList();
    }

    private void setBAExtJarLocation() {
        IPlugin[] plugins;
        IPlugin[] iPluginArray = plugins = fAgent.IAgent_getExtensionAdministrator().getAgentPluginsByType("tracer");
        int n = plugins.length;
        int n2 = 0;
        while (n2 < n) {
            IPlugin plugin = iPluginArray[n2];
            if (extensionJarTracerName.equalsIgnoreCase(plugin.IPlugin_getName())) {
                jarLocation = plugin.IPlugin_getOwningExtension().IExtension_getSource();
                break;
            }
            ++n2;
        }
        if (jarLocation == null) {
            BTThreadLocalAdministrator.logInfoMessages("Can not find the browser agent extension jar.");
        } else {
            BTThreadLocalAdministrator.logInfoMessages("Found the browser agent extension jar in " + jarLocation);
        }
    }

    public String getBAExtJarLocation() {
        return jarLocation;
    }

    public boolean isAutoInjectionEnabled() {
        return autoInjectionEnabled;
    }

    public Boolean isResponseDecorationEnabled() {
        return responseDecorationEnabled;
    }

    public Boolean isResponseDecorationAPMDataEnabled() {
        if (apmDataResponseDecorationEnabled && responseDecorationEnabled) {
            return true;
        }
        return false;
    }

    public List getSnippetCodeList() {
        return snippetCodeList;
    }

    public List getSnippetCodeWithCorrelationList() {
        return snippetCodeWithCorrelationList;
    }

    public List getCompiledPatternList() {
        return compiledPatternList;
    }

    public Pattern getResponseDecorationIncludeURLsRegexPattern() {
        return responseDecorationIncludeURLsRegexPattern;
    }

    public static int getResponseCookieExpirationTime() {
        return responseCookieExpirationTime;
    }

    private static String getSnippetCodeWithCorrelationReplacement(String source) {
        if (source != null) {
            source = source.replaceAll(SCRIPT_TAG_START, SNIPPET_CORRELATION_STRING);
        }
        return source;
    }

    public String[] getCookieContentTypeArray() {
        return cookieContentTypeArray;
    }

    public boolean isCorguidEnabled() {
        return corguidEnabled;
    }

    public boolean isAutoInjectionDeepCheckEnabled() {
        return autoInjectionDeepCheck;
    }

    public void enableAutoInjectionDeepCheckEnabledProperty() {
        if (!enableAutoInjectionDeepCheckLogWarned && !autoInjectionDeepCheck) {
            BTThreadLocalAdministrator.logWarnMessages(new StringBuffer().append("Please enable the ").append(AUTOINJECTION_DEEP_CHECK_PROPERTY).append(" property if the auto snippet injection is not working.").toString());
            enableAutoInjectionDeepCheckLogWarned = true;
        }
    }

    private void findSnippetProperties(IndexedProperties props) {
        HashMap<String, Object> localPropertiesMap = new HashMap<String, Object>();
        String localDxcServerHost = this.setDXCServerHost(props);
        int localDxcServerPort = this.setDXCServerPort(props);
        boolean localDxcServerSSLEnabled = this.setDXCServerSSLEnabled(props);
        String localSnippetString = this.getSnippetStringProperty(props);
        String localAppGroupKeys = props.getTrimmedProperty("introscope.agent.browseragent.autoInjection.appID");
        if (localAppGroupKeys != null && localAppGroupKeys.length() == 0) {
            localAppGroupKeys = null;
        }
        localPropertiesMap.put("introscope.agent.browseragent.dxchost", localDxcServerHost);
        localPropertiesMap.put("introscope.agent.browseragent.dxcport", localDxcServerPort);
        localPropertiesMap.put("introscope.agent.browseragent.ssl.enable", localDxcServerSSLEnabled);
        localPropertiesMap.put(PROPERTYNAME_SNIPPETSTRING, localSnippetString);
        localPropertiesMap.put("introscope.agent.browseragent.autoInjection.appID", localAppGroupKeys);
        if (localAppGroupKeys == null) {
            BTThreadLocalAdministrator.logWarnMessages("introscope.agent.browseragent.autoInjection.appID is not provided");
        } else {
            String[] strtok = localAppGroupKeys.split(",");
            int i = 0;
            while (i < strtok.length) {
                String key = strtok[i].trim();
                String prefixWithKey = "introscope.agent.browseragent.autoInjection." + key;
                String appGroupSnippetLocationProp = String.valueOf(prefixWithKey) + propSeparator + snippetLocationSuffix;
                String appGroupIncludeURLsRegexProp = String.valueOf(prefixWithKey) + propSeparator + includeURLsRegexSuffix;
                String appGroupSnippetLocation = null;
                String appGroupIncludeURLsRegex = null;
                if (BTThreadLocalAdministrator.onlyContainsLetterAndNumber(key)) {
                    appGroupSnippetLocation = props.getTrimmedProperty(appGroupSnippetLocationProp);
                    appGroupIncludeURLsRegex = props.getTrimmedProperty(appGroupIncludeURLsRegexProp);
                }
                if (appGroupSnippetLocation != null && appGroupSnippetLocation.length() == 0) {
                    appGroupSnippetLocation = null;
                }
                if (appGroupIncludeURLsRegex != null && appGroupIncludeURLsRegex.length() == 0) {
                    appGroupIncludeURLsRegex = null;
                }
                localPropertiesMap.put(appGroupSnippetLocationProp, appGroupSnippetLocation);
                localPropertiesMap.put(appGroupIncludeURLsRegexProp, appGroupIncludeURLsRegex);
                ++i;
            }
        }
        if (!snippetPropertiesMap.equals(localPropertiesMap)) {
            dxcServerHost = localDxcServerHost;
            dxcServerPort = localDxcServerPort;
            dxcServerSSLEnabled = localDxcServerSSLEnabled;
            snippetString = localSnippetString;
            appGroupKeys = localAppGroupKeys;
            snippetPropertiesMap = localPropertiesMap;
            initializeSnippetList = true;
        }
        if (sustainabilityMetricsOn) {
            fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.appID").IStringEveryEventDataAccumulator_addString(appGroupKeys == null ? "" : appGroupKeys);
        }
    }

    private String getSnippetStringProperty(IndexedProperties props) {
        String snippet = fAgent.IAgent_getIndexedProperties().getTrimmedProperty(PROPERTYNAME_SNIPPETSTRING);
        if (snippet != null && snippet.length() > 16) {
            if (!snippet.equals(snippetString)) {
                BTThreadLocalAdministrator.logInfoMessages("Value for the property introscope.agent.browseragent.snippetString is set to " + snippet);
            }
            return snippet;
        }
        return null;
    }

    /* synthetic */ BTThreadLocalAdministrator(BTThreadLocalAdministrator bTThreadLocalAdministrator) {
        this();
    }

    final class AuotInjectionEnabledProperty
    extends BooleanConfigurationProperty {
        private AuotInjectionEnabledProperty(IAgent agent) {
            super("introscope.agent.browseragent.autoInjectionEnabled", Boolean.FALSE, "Enables/Disables Auto Snippet Injection for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            reInitialize = true;
            autoInjectionEnabled = (Boolean)newValue;
            if (autoInjectionEnabled) {
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled").IIntegerCounterDataAccumulator_setValue(1);
                }
                BTThreadLocalAdministrator.this.initializeSnippetProperties();
                BTThreadLocalAdministrator.logDebugMessages("Auto Snippet Injection is enabled");
            } else {
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjectionEnabled").IIntegerCounterDataAccumulator_setValue(0);
                }
                BTThreadLocalAdministrator.this.removeSnippetProperties();
                BTThreadLocalAdministrator.logDebugMessages("Auto Snippet Injection is disabled");
            }
        }
    }

    static final class AutoInjectionDeepCheckProperty
    extends BooleanConfigurationProperty {
        private AutoInjectionDeepCheckProperty(IAgent agent) {
            super(AUTOINJECTION_DEEP_CHECK_PROPERTY, Boolean.FALSE, "Enables/Disables Auto Snippet Injection Deep Location Check for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            autoInjectionDeepCheck = (Boolean)newValue;
            if (autoInjectionDeepCheck) {
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:" + AUTOINJECTION_DEEP_CHECK_PROPERTY).IIntegerCounterDataAccumulator_setValue(1);
                }
                BTThreadLocalAdministrator.logInfoMessages("Auto Snippet Injection Deep Location Check is enabled");
            } else {
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:" + AUTOINJECTION_DEEP_CHECK_PROPERTY).IIntegerCounterDataAccumulator_setValue(0);
                }
                BTThreadLocalAdministrator.logInfoMessages("Auto Snippet Injection Location Check is disabled");
            }
        }
    }

    static final class AutoInjectionSnippetThrottleResponseLimitProperty
    extends PositiveIntegerConfigurationProperty {
        private AutoInjectionSnippetThrottleResponseLimitProperty(IAgent agent) {
            super("introscope.agent.browseragent.autoInjection.throttleResponseLimit", 1000, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            throttleResponseLimit = (Integer)newValue;
            reInitialize = true;
            if (throttleResponseLimit >= 0) {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.autoInjection.throttleResponseLimit").append(" is set to ").append(throttleResponseLimit).toString());
            } else {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.autoInjection.throttleResponseLimit").append(" cannot be set to a negative value ").append(throttleResponseLimit).append(", this property will be set to the default value ").append(1000).toString());
                throttleResponseLimit = 1000;
            }
            if (sustainabilityMetricsOn) {
                fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.throttleResponseLimit").IIntegerCounterDataAccumulator_setValue(throttleResponseLimit);
            }
        }
    }

    static final class AutoskipInstrumentclassDepthProperty
    extends PositiveIntegerConfigurationProperty {
        private AutoskipInstrumentclassDepthProperty(IAgent agent) {
            super("introscope.agent.browseragent.instrumentclass.autoskip.depth", 1, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            autoskipInstrumentClassDepth = (Integer)newValue;
            BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.instrumentclass.autoskip.depth").append(" is set to ").append(autoskipInstrumentClassDepth).toString());
        }
    }

    private static final class BTThreadLocalAdministratorInstance {
        public static final BTThreadLocalAdministrator kInstance = new BTThreadLocalAdministrator(null);

        private BTThreadLocalAdministratorInstance() {
        }
    }

    static final class CookieContentTypeProperty
    extends ConfigurationProperty {
        private CookieContentTypeProperty(IAgent agent) {
            super(COOKIE_CONTENTTYPE_PROPERTY, cookieContentType, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            cookieContentType = ((String)newValue).trim();
            BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append(COOKIE_CONTENTTYPE_PROPERTY).append(" is set to ").append(cookieContentType).toString());
            if (cookieContentType != null && ".*".equalsIgnoreCase(cookieContentType)) {
                cookieContentTypeArray = null;
            } else {
                cookieContentTypeArray = cookieContentType.split(",");
            }
            if (sustainabilityMetricsOn) {
                fAgent.IAgent_getDataAccumulatorFactory().safeGetStringEveryEventDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:" + COOKIE_CONTENTTYPE_PROPERTY).IStringEveryEventDataAccumulator_addString(cookieContentType == null ? "" : cookieContentType);
            }
        }
    }

    static final class CorguidEnabledProperty
    extends BooleanConfigurationProperty {
        private CorguidEnabledProperty(IAgent agent) {
            super(BTThreadLocalAdministrator.PROPERTYNAME_CORGUIDENABLED, Boolean.FALSE, "Enables/Disables sending corguid for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            corguidEnabled = (Boolean)newValue;
        }
    }

    static final class EncodingSupportEnabledProperty
    extends BooleanConfigurationProperty {
        private EncodingSupportEnabledProperty(IAgent agent) {
            super("introscope.agent.browseragent.contentencoding.enabled", Boolean.FALSE, "Enables/Disables encoding support property for browser agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            encodingEnabled = (Boolean)newValue;
            if (encodingEnabled) {
                BTThreadLocalAdministrator.logDebugMessages("Content encoding support is enabled");
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled").IIntegerCounterDataAccumulator_setValue(1);
                }
            } else {
                BTThreadLocalAdministrator.logDebugMessages("Content encoding support is disabled");
                if (sustainabilityMetricsOn) {
                    fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.contentencoding.enabled").IIntegerCounterDataAccumulator_setValue(0);
                }
            }
        }
    }

    static final class HeadFilterPresenceCheckProperty
    extends BooleanConfigurationProperty {
        private HeadFilterPresenceCheckProperty(IAgent agent) {
            super("introscope.agent.browseragent.checkHeadFilterPresence.enabled", Boolean.TRUE, "Enables/Disables head filter presence check for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            headFilterPresenceCheckEnabled = (Boolean)newValue;
            if (headFilterPresenceCheckEnabled) {
                BTThreadLocalAdministrator.logDebugMessages("Head filter presence check is enabled");
            } else {
                BTThreadLocalAdministrator.logDebugMessages("Head filter presence check is disabled");
            }
        }
    }

    static final class MaxResponseContentLengthForSearchingProperty
    extends PositiveLongConfigurationProperty {
        private MaxResponseContentLengthForSearchingProperty(IAgent agent) {
            super("introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength", 32768L, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            snippetMaxSearchingLength = (Long)newValue;
            if (snippetMaxSearchingLength >= 0L) {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength").append(" is set to ").append(snippetMaxSearchingLength).toString());
            } else {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength").append(" cannot be set to a negative value ").append(snippetMaxSearchingLength).append(", this property will be set to the default value ").append(32768L).toString());
                snippetMaxSearchingLength = 32768L;
            }
            if (sustainabilityMetricsOn) {
                fAgent.IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.autoInjection.snippet.maxSearchingLength").ILongCounterDataAccumulator_setValue(snippetMaxSearchingLength);
            }
        }
    }

    static final class SearchingMethodHierarchyMaxDepthProperty
    extends PositiveIntegerConfigurationProperty {
        private SearchingMethodHierarchyMaxDepthProperty(IAgent agent) {
            super("introscope.agent.browseragent.searchingmethodhierarchy.max.depth", 3, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            searchingMethodHierarchyMaxDepth = (Integer)newValue;
            if (searchingMethodHierarchyMaxDepth >= 0) {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.searchingmethodhierarchy.max.depth").append(" is set to ").append(searchingMethodHierarchyMaxDepth).toString());
            } else {
                BTThreadLocalAdministrator.logDebugMessages(new StringBuffer().append("introscope.agent.browseragent.searchingmethodhierarchy.max.depth").append(" cannot be set to a negative value ").append(searchingMethodHierarchyMaxDepth).append(", this property will be set to the default value ").append(3).toString());
                searchingMethodHierarchyMaxDepth = 3;
            }
        }
    }

    final class SustainabilityMetricsProperty
    extends BooleanConfigurationProperty {
        private SustainabilityMetricsProperty(IAgent agent) {
            super("introscope.agent.browseragent.sustainabilityMetrics.enabled", Boolean.TRUE, "Enables/Disables Sustainability Metrics for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            sustainabilityMetricsOn = (Boolean)newValue;
            reInitialize = true;
            if (sustainabilityMetricsOn) {
                BTThreadLocalAdministrator.this.startReportingSustainabilityMetrics();
                fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.sustainabilityMetrics.enabled").IIntegerCounterDataAccumulator_setValue(1);
                BTThreadLocalAdministrator.logDebugMessages("Sustainability Metrics is enabled");
            } else {
                BTThreadLocalAdministrator.this.stopReportSustainabilityMetrics();
                fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Browser Agent Business Transaction:introscope.agent.browseragent.sustainabilityMetrics.enabled").IIntegerCounterDataAccumulator_setValue(0);
                BTThreadLocalAdministrator.logDebugMessages("Sustainability Metrics is disabled");
            }
        }
    }

    static final class TailFilterPresenceCheckProperty
    extends BooleanConfigurationProperty {
        private TailFilterPresenceCheckProperty(IAgent agent) {
            super("introscope.agent.browseragent.checkTailFilterPresence.enabled", Boolean.TRUE, "Enables/Disables tail filter presence check for Browser Agent", true, false, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            tailFilterPresenceCheckEnabled = (Boolean)newValue;
            if (tailFilterPresenceCheckEnabled) {
                BTThreadLocalAdministrator.logDebugMessages("Tail filter presence check is enabled");
            } else {
                BTThreadLocalAdministrator.logDebugMessages("Tail filter Presence check is disabled");
            }
        }
    }
}

