/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io.clamp;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.clamp.ASocketClampManager;
import com.wily.introscope.agent.trace.io.clamp.TracedSockets;
import com.wily.util.properties.AttributeListing;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;

public class DatagramClampManager
extends ASocketClampManager {
    public DatagramClampManager(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected void decideOnClamp(InvocationData data) {
        boolean traced = false;
        try {
            Object object = data.getInvocationObject();
            if (object instanceof DatagramChannel) {
                DatagramChannel channel = (DatagramChannel)object;
                InetSocketAddress remoteAddress = (InetSocketAddress)channel.socket().getRemoteSocketAddress();
                traced = TracedSockets.isTraced(remoteAddress);
            }
            if (!traced) {
                data.setSocketClamp(!traced);
            }
        }
        catch (ClassCastException classCastException) {
            this.getModuleFeedback().error(ASocketClampManager.kIncorrectTracerMappingErrorMsg);
        }
        catch (Exception e) {
            this.getModuleFeedback().error(e);
        }
    }
}

