/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument.attach.transformers;

import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.introscope.api.instrument.JavaAgent;
import java.io.File;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Field;
import java.security.ProtectionDomain;
import java.util.Arrays;

public class JBossTransformer
implements ClassFileTransformer {
    public static boolean isJBoss() {
        if (System.getProperty("jboss.modules.system.pkgs") != null) {
            return true;
        }
        String jbossHome = System.getenv("JBOSS_HOME");
        return jbossHome != null && new File(String.valueOf(jbossHome) + File.separator + "jboss-modules.jar").exists();
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        String targetClassName = "org/jboss/modules/Module";
        if (className.equals(targetClassName) && classBeingRedefined != null) {
            String[] oldValue;
            Field systemPkg;
            block6: {
                systemPkg = classBeingRedefined.getDeclaredField("systemPackages");
                oldValue = (String[])ReflectionUtils.getFinalStaticField(systemPkg);
                if (!Arrays.asList(oldValue).contains("com.wily.")) break block6;
                return null;
            }
            try {
                String[] newValue = new String[oldValue.length + 2];
                System.arraycopy(oldValue, 0, newValue, 0, oldValue.length);
                newValue[newValue.length - 1] = "com.wily.";
                newValue[newValue.length - 2] = "com.sun.naming.internal.";
                ReflectionUtils.setFinalStaticField(systemPkg, newValue);
                Field systemPath = classBeingRedefined.getDeclaredField("systemPaths");
                oldValue = (String[])ReflectionUtils.getFinalStaticField(systemPath);
                newValue = new String[oldValue.length + 2];
                System.arraycopy(oldValue, 0, newValue, 0, oldValue.length);
                newValue[newValue.length - 1] = "com/wily/";
                newValue[newValue.length - 2] = "com/sun/naming/internal/";
                ReflectionUtils.setFinalStaticField(systemPath, newValue);
                JavaAgent.bootstrapRetransformLatch.countDown();
            }
            catch (SecurityException securityException) {
                System.out.println("Failed to access JBoss Modules system Packages");
            }
            catch (NoSuchFieldException noSuchFieldException) {
                System.out.println("Failed to find JBoss Modules system Packages");
            }
            catch (Exception exception) {
                System.out.println("Failed to modify JBoss Modules system Packages");
            }
        }
        return null;
    }
}

