/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.message;

import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.PostOfficeSpecifier;
import com.wily.isengard.postofficehub.link.v1.IsengardObjectInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class AMessage
implements Externalizable {
    private static final Address sUnknownAddress = new Address(new PostOfficeSpecifier("Unknown", "Unknown"), -1);
    private static final int kLatencyMask = 1;
    private static final int kHubShouldDirectDeliver = 2;
    private static final int kDeliverEvenIfClosed = 4;
    private static final int kTraceMessage = 8;
    private Address fSourceAddress = sUnknownAddress;
    private short fFlags = 0;
    private short fSequenceNumber;
    private transient String fRemoteHost = "{Unknown}";

    public final Address getSourceAddress() {
        return this.fSourceAddress;
    }

    public final void setSourceAddress(Address source) {
        this.fSourceAddress = source;
    }

    public final void setLowLatency() {
        this.fFlags = (short)(this.fFlags | 1);
    }

    public final boolean getLowLatency() {
        return (this.fFlags & 1) != 0;
    }

    public final void setShouldTrace() {
        this.fFlags = (short)(this.fFlags | 8);
    }

    public final boolean getShouldTrace() {
        return (this.fFlags & 8) != 0;
    }

    public final boolean getHubShouldDirectDeliver() {
        return (this.fFlags & 2) != 0;
    }

    public final void setHubShouldDirectDeliver(boolean directDeliver) {
        this.fFlags = directDeliver ? (short)(this.fFlags | 2) : (short)(this.fFlags & 0xFFFFFFFD);
    }

    public final void setDeliverIfClosed(boolean deliverIfClosed) {
        this.fFlags = deliverIfClosed ? (short)(this.fFlags | 4) : (short)(this.fFlags & 0xFFFFFFFB);
    }

    public final boolean isDeliverIfClosed() {
        return (this.fFlags & 4) != 0;
    }

    public void setRemoteHost(String remoteHost) {
        this.fRemoteHost = remoteHost;
    }

    public String getRemoteHost() {
        return this.fRemoteHost;
    }

    public void setSequenceNumber(short sequenceNumber) {
        this.fSequenceNumber = sequenceNumber;
    }

    public short getSequenceNumber() {
        return this.fSequenceNumber;
    }

    public String toString() {
        return " UnknownMessageType: {" + this.getClass().getName() + "}";
    }

    public String toString(Address destination) {
        return "[" + this.fSourceAddress + " -> " + destination + "] " + this.toString();
    }

    protected final void writeAMessage(ObjectOutput out) throws IOException {
        this.fSourceAddress.writeExternal(out);
        out.writeShort(this.fFlags);
        out.writeShort(this.fSequenceNumber);
    }

    protected final void readAMessage(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fSourceAddress = new Address();
        this.fSourceAddress.readExternal(in);
        if (in instanceof IsengardObjectInputStream) {
            ((IsengardObjectInputStream)in).setLastMessageSourceAddress(this.fSourceAddress);
        }
        this.fFlags = in.readShort();
        this.fSequenceNumber = in.readShort();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeAMessage(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readAMessage(in);
    }
}

