/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.launch.core;

import com.wily.introscope.agent.launch.core.AgentArgsValidator;
import com.wily.introscope.agent.launch.core.AgentProfileHandler;
import com.wily.introscope.agent.launch.core.BootstrapAgentInstallDirValidator;
import com.wily.introscope.agent.launch.core.BootstrapAgentLogger;
import com.wily.introscope.agent.launch.core.BootstrapAgentValidationException;
import com.wily.introscope.agent.launch.core.Logger;
import com.wily.introscope.agent.launch.util.AgentArgumentSplitter;
import com.wily.introscope.agent.launch.util.AgentArtifact;
import com.wily.introscope.agent.launch.util.BootstrapAgentConstants;
import com.wily.introscope.agent.launch.util.BootstrapAgentUtil;
import com.wily.introscope.agent.launch.util.PolicyFileReader;
import com.wily.introscope.agent.launch.util.ReleaseFileReader;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.HashMap;
import java.util.Map;

public class BootstrapAdministrator
implements BootstrapAgentConstants {
    public static final Logger LOGGER = BootstrapAgentLogger.getLogger();

    public static void bootstrap(String args, Instrumentation instrumentation, String methodName) {
        BootstrapPolicyBuilder policyBuilder = new BootstrapPolicyBuilder(args, instrumentation);
        try {
            Map<String, String> params = policyBuilder.build();
            if (params.get("core.agent.jar.location") == null) {
                LOGGER.info("Can not launch Java Agent because Agent artifact is not found" + params);
                return;
            }
            Class<?> javaAgentLauncher = Class.forName("com.wily.introscope.api.instrument.JavaAgentLauncher");
            javaAgentLauncher.getMethod(methodName, String.class, Instrumentation.class, Map.class).invoke(null, methodName, instrumentation, params);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    public static class BootstrapPolicyBuilder {
        private final String startupArgs;
        private final String coreAgentJarName;

        private BootstrapPolicyBuilder(String args, String coreAgentJarName) {
            this.startupArgs = args;
            this.coreAgentJarName = coreAgentJarName;
            AgentArgsValidator.registerValidationHandler(new AgentProfileHandler("absolute.profile.location"));
        }

        public BootstrapPolicyBuilder(String args) {
            this(args, "Agent.jar");
        }

        public BootstrapPolicyBuilder(String args, Instrumentation instrumentation) {
            this(args, instrumentation.isRedefineClassesSupported() ? "Agent.jar" : "AgentNoRedefNoRetrans.jar");
        }

        public Map<String, String> build() throws IOException {
            LOGGER.finer("Startup arguments passed: " + this.startupArgs);
            HashMap<String, String> startupParams = new HashMap<String, String>();
            this.parseAndPopulateArguments(startupParams);
            this.populateDefaultPolicySettings(startupParams);
            this.extractStartupParametersFromPolicyFile(startupParams);
            this.validateParameters(startupParams);
            LOGGER.finer("Updated startup parameters: " + startupParams);
            return startupParams;
        }

        public Map<String, String> buildAgentMain() {
            HashMap<String, String> startupParams = new HashMap<String, String>();
            this.populateDefaultPolicySettings(startupParams);
            try {
                this.extractStartupParametersFromPolicyFile(startupParams);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            this.validateParameters(startupParams);
            LOGGER.finer("Updated startup parameters: " + startupParams);
            return startupParams;
        }

        private void populateDefaultPolicySettings(Map<String, String> startupParams) {
            startupParams.put("introscope.agent.release.version", "latest");
            startupParams.put("UseProfileFromConfigDirIfMatch".toLowerCase(), "false");
        }

        private void parseAndPopulateArguments(Map<String, String> startupParams) {
            String[][] params = AgentArgumentSplitter.splitArguments(this.startupArgs, System.out);
            if (params != null) {
                int i = 0;
                while (i < params.length) {
                    startupParams.put(params[i][0], params[i][1]);
                    ++i;
                }
            }
        }

        private void validateParameters(Map<String, String> startupParams) {
            AgentArgsValidator.validateArgs(startupParams);
        }

        private void extractStartupParametersFromPolicyFile(Map<String, String> startupParams) throws IOException {
            String bootStrapjarLocation = BootstrapAgentUtil.getBootstrapAgentJar();
            if (!BootstrapAgentInstallDirValidator.isValidPath(bootStrapjarLocation) && (bootStrapjarLocation = System.getProperty("bootstrap.jar.absolute.location")) == null) {
                throw new BootstrapAgentValidationException("Path of BootstrapAgent is not a valid directory. Please specify the location of Agent.jar using -Dbootstrap.jar.absolute.location");
            }
            startupParams.put("bootstrap.jar.absolute.location", bootStrapjarLocation);
            String bootstrapAgentInstallDir = BootstrapAgentUtil.getBootstrapAgentInstallDir(bootStrapjarLocation);
            LOGGER.finer("Bootstrap Agent Install location using API:" + bootstrapAgentInstallDir);
            if (bootstrapAgentInstallDir != null) {
                startupParams.put("bootstrap.location", bootstrapAgentInstallDir);
                String agentHome = new File(bootstrapAgentInstallDir).getAbsolutePath();
                LOGGER.info("Bootstrap agent home location: " + agentHome);
                startupParams.put("introscope.agent.bootstrap.home", agentHome);
                String agentPolicyFileAbsolutePath = startupParams.get("agent.policy.file.location");
                agentPolicyFileAbsolutePath = agentPolicyFileAbsolutePath != null ? agentPolicyFileAbsolutePath : System.getProperty("agent.policy.file.location");
                agentPolicyFileAbsolutePath = agentPolicyFileAbsolutePath != null ? agentPolicyFileAbsolutePath : String.valueOf(bootstrapAgentInstallDir) + FILE_SEPARATOR + "agent.policy";
                startupParams.put("agent.policy.file.location", agentPolicyFileAbsolutePath);
                LOGGER.fine("Agent's policy file location: " + agentPolicyFileAbsolutePath);
                if (BootstrapAgentUtil.fileExists(agentPolicyFileAbsolutePath)) {
                    PolicyFileReader.getArgsFromPropertyFile(startupParams);
                } else {
                    LOGGER.fine("No Agent Policy file found at :" + agentPolicyFileAbsolutePath + " . Looking for Release file");
                }
                String agentReleaseFileAbsolutePath = startupParams.get("agent.release.file.location");
                agentReleaseFileAbsolutePath = agentReleaseFileAbsolutePath != null ? agentReleaseFileAbsolutePath : System.getProperty("agent.release.file.location");
                agentReleaseFileAbsolutePath = agentReleaseFileAbsolutePath != null ? agentReleaseFileAbsolutePath : String.valueOf(bootstrapAgentInstallDir) + FILE_SEPARATOR + "agent.release";
                startupParams.put("agent.release.file.location", agentReleaseFileAbsolutePath);
                LOGGER.info("Agent's release file location: " + agentReleaseFileAbsolutePath);
                if (BootstrapAgentUtil.fileExists(agentReleaseFileAbsolutePath)) {
                    ReleaseFileReader.setAgentVersionToUse(startupParams);
                } else {
                    LOGGER.info("BootstrapAgent will use default settings as Release file could not be found at :" + agentReleaseFileAbsolutePath);
                }
                String version = System.getProperty("introscope.agent.release.version");
                if (version == null) {
                    version = startupParams.get("introscope.agent.release.version");
                } else {
                    LOGGER.info("Found version to use in System Properties " + version);
                }
                AgentArtifact agentToUse = BootstrapAgentUtil.getAgentForVersion(version, agentHome, this.coreAgentJarName);
                if (agentToUse == null) {
                    LOGGER.severe("Could not find release agent version. Please check if the agent artifacts have the correct release versions");
                    return;
                }
                LOGGER.info("Selected agent release version '" + agentToUse.getVersion() + "'");
                LOGGER.fine("Selected agent: " + agentToUse.getJarLocation() + " for delegation");
                startupParams.put("core.agent.jar.location", agentToUse.getJarLocation());
                AgentProfileHandler.handleAgentProfile(startupParams);
                this.setBootstrapSystemProperties(agentToUse, agentHome, version, this.coreAgentJarName);
            }
        }

        private void setBootstrapSystemProperties(AgentArtifact agentToUse, String agentHome, String version, String coreAgentJarName) {
            System.setProperty("introscope.agent.bootstrap.version.loaded", agentToUse.getVersion());
            System.setProperty("introscope.agent.bootstrap.versions.available", BootstrapAgentUtil.getListOfAvailableAgent(agentHome, coreAgentJarName));
            System.setProperty("introscope.agent.bootstrap.release.version", version);
            System.setProperty("introscope.agent.bootstrap.home", agentHome);
            System.setProperty("introscope.core.agent.jar.path", agentToUse.getJarLocation());
        }
    }
}

