/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.launch.core;

import com.wily.introscope.agent.launch.core.IFileLocker;
import com.wily.introscope.agent.launch.core.LogMessage;
import java.lang.management.ManagementFactory;
import java.nio.channels.FileLock;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BootstrapAgentAsyncLogger {
    private final Logger logger;
    private BlockingQueue<LogMessage> messageQ = new ArrayBlockingQueue<LogMessage>(500);
    private final IFileLocker fileLocker;

    public BootstrapAgentAsyncLogger(Logger logger, IFileLocker fileLocker) {
        this.logger = logger;
        this.fileLocker = fileLocker;
    }

    public void info(String message) {
        this.messageQ.add(new LogMessage(Level.INFO, message));
    }

    public void severe(String message) {
        this.messageQ.add(new LogMessage(Level.SEVERE, message));
    }

    public void warning(String message) {
        this.messageQ.add(new LogMessage(Level.WARNING, message));
    }

    public void log(Level level, String message) {
        this.messageQ.add(new LogMessage(level, message));
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void doLogAllWithFileLock() {
        String processId = ManagementFactory.getRuntimeMXBean().getName();
        FileLock lock = null;
        if (this.fileLocker != null && (lock = this.fileLocker.tryUntilAcquiredOrMaxRetries(10L, 50)) != null) {
            try {
                while (!this.messageQ.isEmpty()) {
                    LogMessage message = (LogMessage)this.messageQ.remove();
                    System.out.println("Going to write " + message.getMessage());
                    this.logger.log(message.getLevel(), message.getMessage());
                }
            }
            finally {
                if (lock != null) {
                    this.fileLocker.releaseLock(lock);
                    System.out.println("Lock released by process " + processId);
                    this.removeAllHandlers();
                }
            }
        }
    }

    private void removeAllHandlers() {
        Handler[] handlers = this.logger.getHandlers();
        int i = 0;
        while (i < handlers.length) {
            this.logger.removeHandler(handlers[i]);
            ++i;
        }
    }

    public void logAll() {
        ExecutorService pool = Executors.newSingleThreadExecutor();
        pool.submit(new Runnable(){

            @Override
            public void run() {
                BootstrapAgentAsyncLogger.this.doLogAllWithFileLock();
            }
        });
    }
}

