/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.metric.calculator;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.wily.introscope.agent.metric.calculator.AddOperation;
import com.wily.introscope.agent.metric.calculator.AggregateOperation;
import com.wily.introscope.agent.metric.calculator.BinaryOperation;
import com.wily.introscope.agent.metric.calculator.CounterOperation;
import com.wily.introscope.agent.metric.calculator.DivideOperation;
import com.wily.introscope.agent.metric.calculator.IntegerConstant;
import com.wily.introscope.agent.metric.calculator.MetricValue;
import com.wily.introscope.agent.metric.calculator.MultiplyOperation;
import com.wily.introscope.agent.metric.calculator.Operation;
import com.wily.introscope.agent.metric.calculator.RateOperation;
import com.wily.introscope.agent.metric.calculator.SubtractOperation;
import com.wily.introscope.agent.metric.calculator.UnaryOperation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OperationDeserializer
implements JsonDeserializer<Operation> {
    private final Map<String, Class<?>> classMap = Collections.synchronizedMap(new HashMap());

    public OperationDeserializer() {
        this.classMap.put("AddOperation", AddOperation.class);
        this.classMap.put("SubtractOperation", SubtractOperation.class);
        this.classMap.put("MultiplyOperation", MultiplyOperation.class);
        this.classMap.put("DivideOperation", DivideOperation.class);
        this.classMap.put("AggregateOperation", AggregateOperation.class);
        this.classMap.put("RateOperation", RateOperation.class);
        this.classMap.put("CounterOperation", CounterOperation.class);
        this.classMap.put("MetricValue", MetricValue.class);
        this.classMap.put("IntegerConstant", IntegerConstant.class);
    }

    @Override
    public Operation deserialize(JsonElement element, Type base, JsonDeserializationContext ctx) throws JsonParseException {
        JsonObject operation = element.getAsJsonObject();
        JsonElement typeElement = operation.get("type");
        if (typeElement == null) {
            return null;
        }
        String type = typeElement.getAsString();
        Class<?> clazz = this.classMap.get(type);
        if (clazz == null) {
            return null;
        }
        String resultMetric = null;
        JsonElement resultMetricElement = operation.get("resultMetric");
        if (resultMetricElement != null) {
            resultMetric = resultMetricElement.getAsString();
        }
        Operation op = null;
        try {
            JsonElement op1e;
            if (BinaryOperation.class.isAssignableFrom(clazz)) {
                op1e = operation.get("operand1");
                JsonElement op2e = operation.get("operand2");
                if (op1e == null || op2e == null) {
                    return null;
                }
                Operation op1 = (Operation)ctx.deserialize(op1e, (Type)((Object)Operation.class));
                Operation op2 = (Operation)ctx.deserialize(op2e, (Type)((Object)Operation.class));
                op = (Operation)clazz.getConstructor(Operation.class, Operation.class).newInstance(op1, op2);
            }
            if (UnaryOperation.class.isAssignableFrom(clazz)) {
                op1e = operation.get("operand");
                if (op1e == null) {
                    throw new JsonParseException("Unary operation is missing mandatory operand field.");
                }
                Operation op1 = (Operation)ctx.deserialize(op1e, (Type)((Object)Operation.class));
                op = (Operation)clazz.getConstructor(Operation.class).newInstance(op1);
            }
            if (IntegerConstant.class.isAssignableFrom(clazz)) {
                JsonElement ve = operation.get("value");
                if (ve == null) {
                    throw new JsonParseException("IntegerConstant operation missing mandatory value field.");
                }
                int value = ve.getAsInt();
                op = new IntegerConstant(value);
            }
            if (MetricValue.class.isAssignableFrom(clazz)) {
                JsonElement e = operation.get("metricPath");
                if (e == null) {
                    throw new JsonParseException("MetricValue operation missing mandatory metricPath field.");
                }
                String path = e.getAsString();
                e = operation.get("removeSourceMetric");
                boolean removeSourceMetric = false;
                if (e != null) {
                    removeSourceMetric = e.getAsBoolean();
                }
                op = new MetricValue(path, removeSourceMetric);
            }
        }
        catch (IllegalArgumentException e) {
            throw new JsonParseException("Failed to create and initialize operation element.", e);
        }
        catch (SecurityException e) {
            throw new JsonParseException("Failed to create and initialize operation element.", e);
        }
        catch (InstantiationException e) {
            throw new JsonParseException("Failed to create and initialize operation element.", e);
        }
        catch (IllegalAccessException e) {
            throw new JsonParseException("Failed to create and initialize operation element.", e);
        }
        catch (InvocationTargetException e) {
            throw new JsonParseException("Failed to create and initialize operation element.", e);
        }
        catch (NoSuchMethodException e) {
            throw new JsonParseException("Failed to create and initialize operation element.", e);
        }
        if (op != null && resultMetric != null) {
            op.setResultMetric(resultMetric);
        }
        return op;
    }
}

