/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.postofficehub.link.v1;

import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class CaptureOutputStream
extends OutputStream {
    private final String name;
    private final long limit;
    private long count = 0L;
    private final OutputStream out;
    private boolean limitLogged = false;
    private long currentTime = 0L;
    private byte[] buffer = new byte[15];
    private int buffered = 0;
    private CaptureOutputStream peer = null;
    private static final String eol = System.getProperty("line.separator");
    private static final SimpleDateFormat format = new SimpleDateFormat("dd/MM/yy  HH:mm:ss.SSS");

    private static String printBinaryDataLine(byte[] b, int offset) {
        int c;
        int index;
        StringBuilder sb = new StringBuilder();
        int len = b.length;
        int i = 0;
        while (i < 16) {
            index = i + offset;
            if (index >= len) {
                sb.append("   ");
            } else {
                c = b[index] & 0xFF;
                if (c < 16) {
                    sb.append("0");
                }
                sb.append(Integer.toHexString(c & 0xFF));
                sb.append(" ");
            }
            ++i;
        }
        i = 0;
        while (i < 16) {
            index = i + offset;
            if (index >= len) break;
            c = (char)b[index];
            if (Character.isISOControl((char)c)) {
                sb.append(".");
            } else {
                sb.append((char)c);
            }
            ++i;
        }
        return sb.toString();
    }

    public static byte[] formatBinaryEvent(String name, byte[] b) {
        return CaptureOutputStream.formatBinaryEvent(System.currentTimeMillis(), name, b);
    }

    public static byte[] formatBinaryEvent(long now, String name, byte[] b) {
        Date date = new Date(now);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < b.length) {
            if (i == 0) {
                sb.append(name);
                sb.append(":");
                sb.append(format.format(date));
                sb.append(" ");
            } else {
                sb.append("                          ");
            }
            sb.append(CaptureOutputStream.printBinaryDataLine(b, i));
            sb.append(eol);
            i += 16;
        }
        return sb.toString().getBytes();
    }

    public static byte[] formatTextEvent(String name, String text) {
        return CaptureOutputStream.formatTextEvent(System.currentTimeMillis(), name, text);
    }

    public static byte[] formatTextEvent(long now, String name, String text) {
        Date date = new Date(now);
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(":");
        sb.append(format.format(date));
        sb.append(" ");
        sb.append(text);
        sb.append(eol);
        return sb.toString().getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrite(byte[] b) throws IOException {
        OutputStream outputStream = this.out;
        synchronized (outputStream) {
            this.out.write(b);
            this.out.flush();
        }
    }

    private void sendBufferedBytes(long now) throws IOException {
        if (this.buffered > 0) {
            byte[] bytes = Arrays.copyOf(this.buffer, this.buffered);
            byte[] event = CaptureOutputStream.formatBinaryEvent(this.currentTime, this.name, bytes);
            this.count += (long)bytes.length;
            this.buffered = 0;
            this.currentTime = now;
            this.doWrite(event);
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        long now;
        if (this.limit != 0L && this.count > this.limit) {
            if (!this.limitLogged) {
                byte[] msg = CaptureOutputStream.formatTextEvent(this.name, "Stream capture limit of " + this.limit + " reached.");
                this.doWrite(msg);
                this.limitLogged = true;
            }
            return;
        }
        if (this.peer != null) {
            this.peer.flush();
        }
        if ((now = System.currentTimeMillis()) != this.currentTime) {
            this.sendBufferedBytes(now);
        }
        this.currentTime = now;
        byte[] bytes = b;
        if (this.buffered + b.length <= this.buffer.length) {
            int i = 0;
            while (i < b.length) {
                this.buffer[i + this.buffered] = b[i];
                ++i;
            }
            this.buffered += b.length;
            return;
        }
        if (this.buffered > 0) {
            bytes = new byte[this.buffered + b.length];
            System.arraycopy(this.buffer, 0, bytes, 0, this.buffered);
            System.arraycopy(b, 0, bytes, this.buffered, b.length);
            this.buffered = 0;
        }
        byte[] event = CaptureOutputStream.formatBinaryEvent(now, this.name, bytes);
        this.count += (long)bytes.length;
        this.doWrite(event);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.write(Arrays.copyOfRange(b, off, off + len));
    }

    @Override
    public void flush() throws IOException {
        this.sendBufferedBytes(System.currentTimeMillis());
    }

    @Override
    public void close() throws IOException {
        long now = System.currentTimeMillis();
        this.sendBufferedBytes(now);
        byte[] msg = CaptureOutputStream.formatTextEvent(now, this.name, "Stream closed.");
        this.doWrite(msg);
        if (this.peer != null) {
            this.peer.flush();
        }
        super.close();
    }

    public CaptureOutputStream(String name, OutputStream out) {
        this(name, out, 0L);
    }

    public CaptureOutputStream(String name, OutputStream out, long limit) {
        this.name = name;
        this.out = out;
        this.limit = limit;
        this.count = 0L;
        this.limitLogged = false;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    void setPeer(CaptureOutputStream peer) {
        this.peer = peer;
    }
}

