/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.io;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;

public final class ExtendedFile {
    private final File fBackingFile;

    public ExtendedFile(String path) {
        this.fBackingFile = new File(path);
    }

    public ExtendedFile(String path, String name) {
        this.fBackingFile = new File(path, name);
    }

    public ExtendedFile(File dir, String name) {
        this.fBackingFile = new File(dir, name);
    }

    public ExtendedFile(ExtendedFile dir, String name) {
        this.fBackingFile = new File(dir.getFile(), name);
    }

    public ExtendedFile(File nonextendedFile) {
        this(nonextendedFile.getPath());
    }

    public ExtendedFile(ExtendedFile extendedFile) {
        this(extendedFile.getFile());
    }

    public File getFile() {
        return this.fBackingFile;
    }

    public boolean isDirectory() {
        return this.getFile().isDirectory();
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    public boolean mkdir() {
        return this.getFile().mkdir();
    }

    public String[] list() {
        return this.getFile().list();
    }

    public String[] list(FilenameFilter filter) {
        return this.getFile().list(filter);
    }

    public File[] listFiles() {
        return this.getFile().listFiles();
    }

    public File[] listFiles(FilenameFilter filter) {
        return this.getFile().listFiles(filter);
    }

    public String getAbsolutePath() {
        return this.getFile().getAbsolutePath();
    }

    public String getCanonicalPath() throws IOException {
        return this.getFile().getCanonicalPath();
    }

    public URL toURL() throws IOException {
        return this.getFile().getCanonicalFile().toURL();
    }

    public File getParentFile() {
        return this.getFile().getParentFile();
    }

    public String getName() {
        return this.getFile().getName();
    }

    public void deleteOnExit() {
        this.getFile().deleteOnExit();
    }

    public boolean isAbsolute() {
        return this.getFile().isAbsolute();
    }

    public void deleteFile() throws IOException {
        if (!this.getFile().delete()) {
            throw new IOException(MessageFormat.format("Delete failed for file \"{0}\"", this.getFile().getAbsolutePath()));
        }
    }

    public void makeDirectory() throws IOException {
        if (!this.getFile().mkdir()) {
            throw new IOException("mkdir failed");
        }
    }

    public void makeDirectories() throws IOException {
        if (!this.getFile().mkdirs()) {
            throw new IOException("mkdirs failed");
        }
    }

    public void renameFileTo(File dest) throws IOException {
        if (!this.getFile().renameTo(dest)) {
            throw new IOException("renameTo failed");
        }
    }

    public void createFile() throws IOException {
        if (!this.getFile().createNewFile()) {
            throw new IOException("createFile failed");
        }
    }

    public boolean canonicalEquals(File file) {
        return ExtendedFile.getCanonicalFile(this).equals(ExtendedFile.getCanonicalFile(file));
    }

    public static File getCanonicalFile(String filename) {
        return ExtendedFile.getCanonicalFile(new File(filename));
    }

    public static File getCanonicalFile(ExtendedFile extendedFile) {
        return ExtendedFile.getCanonicalFile(extendedFile.getFile());
    }

    public static File getCanonicalFile(File file) {
        String canonicalName = ExtendedFile.safeGetCanonicalPath(file);
        return new File(canonicalName);
    }

    public static File getCanonicalFile(String path, String name) {
        String canonicalName = ExtendedFile.safeGetCanonicalPath(new File(path, name));
        return new File(canonicalName);
    }

    public static File getCanonicalFile(File path, String name) {
        String canonicalName = ExtendedFile.safeGetCanonicalPath(new File(path, name));
        return new File(canonicalName);
    }

    public String safeGetCanonicalPath() {
        return ExtendedFile.safeGetCanonicalPath(this, this.getFile().getAbsolutePath());
    }

    public String safeGetCanonicalPath(String fallback) {
        return ExtendedFile.safeGetCanonicalPath(this, fallback);
    }

    public static String safeGetCanonicalPath(File file) {
        return ExtendedFile.safeGetCanonicalPath(file, file.getAbsolutePath());
    }

    public static String safeGetCanonicalPath(ExtendedFile extendedFile) {
        return ExtendedFile.safeGetCanonicalPath(extendedFile.getFile());
    }

    public static String safeGetCanonicalPath(File file, String fallback) {
        try {
            return file.getCanonicalPath();
        }
        catch (Throwable throwable) {
            return fallback;
        }
    }

    public static String safeGetCanonicalPath(ExtendedFile extendedFile, String fallback) {
        return ExtendedFile.safeGetCanonicalPath(extendedFile.getFile(), fallback);
    }

    public String getExtension() {
        return ExtendedFile.getExtension(this);
    }

    public static String getExtension(ExtendedFile extendedFile) {
        return ExtendedFile.getExtension(extendedFile.getFile());
    }

    public static String getExtension(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return name.substring(index + 1);
    }

    public static final boolean isAbsolutePath(String target) {
        return new ExtendedFile(target).getFile().isAbsolute();
    }

    public String toString() {
        return this.fBackingFile.getAbsolutePath();
    }
}

